/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestFunctionDeclaration
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("function myFunction() {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction()\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("function myFunction()\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction() {\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("function myFunction() {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction()\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("function myFunction()\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction() {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testReturnType() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("function myFunction():void\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction():void\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testParameter() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("function myFunction(p1:String)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction(p1:String)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testParameters() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("function myFunction(p1:String, p2:Number)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction(p1:String, p2:Number)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNewLinesAmongParameters() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("function myFunction(p1:String,\np2:Number):void\n{\n\tstatement;\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction(p1:String,\n\tp2:Number):void\n{\n\tstatement;\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testParametersWithRest() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("function myFunction(p1:String, ...rest)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction(p1:String, ...rest)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testParametersRestOnly() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("function myFunction(...rest)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction(...rest)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testWrappedInParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("(function myFunction(...rest)\n{\n\tstatement;\n});", (Collection)this.problems);
        Assert.assertEquals((Object)"(function myFunction(...rest)\n{\n\tstatement;\n});", (Object)result);
    }

    @Test
    public void testAsArgument() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("identifier(function myFunction(...rest)\n{\n\tstatement;\n}, 123.4);", (Collection)this.problems);
        Assert.assertEquals((Object)"identifier(function myFunction(...rest)\n{\n\tstatement;\n}, 123.4);", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.collapseEmptyBlocks = true;
        String result = formatter.formatActionScriptText("function myFunction() {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction() {}", (Object)result);
    }
}

