/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestForStatement
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("for (var i:int = 0; i < 3; i++) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var i:int = 0; i < 3; i++)\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("for (var i:int = 0; i < 3; i++)\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var i:int = 0; i < 3; i++) {\n}", (Object)result);
    }

    @Test
    public void testInsertSpaceAfterControlFlowKeyword() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("for(var i:int = 0; i < 3; i++)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var i:int = 0; i < 3; i++)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisableInsertSpaceAfterControlFlowKeyword() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = false;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("for (var i:int = 0; i < 3; i++)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for(var i:int = 0; i < 3; i++)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("for (var i:int = 0; i < 3; i++) {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var i:int = 0; i < 3; i++)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("for (var i:int = 0; i < 3; i++)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var i:int = 0; i < 3; i++) {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testBodyWithoutParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("for (var i:int = 0; i < 3; i++) statement;", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var i:int = 0; i < 3; i++)\n\tstatement;", (Object)result);
    }

    @Test
    public void testWithBodyIsSemicolonOnSameLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("for (var i:int = 0; i < 3; i++);", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var i:int = 0; i < 3; i++);", (Object)result);
    }

    @Test
    public void testNested() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition)\n{\n\tfor (var i:int = 0; i < 3; i++)\n\t{\n\t\tstatement;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition)\n{\n\tfor (var i:int = 0; i < 3; i++)\n\t{\n\t\tstatement;\n\t}\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tfor (var i:int = 0; i < 3; i++)\n\t{\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tfor (var i:int = 0; i < 3; i++)\n\t{\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithoutParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tfor (var i:int = 0; i < 3; i++)\n\t\tstatement;\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tfor (var i:int = 0; i < 3; i++)\n\t\tstatement;\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tfor (var i:int = 0; i < 3; i++)\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tfor (var i:int = 0; i < 3; i++)\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIntentWithBodyIsSemicolonOnSameLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tfor (var i:int = 0; i < 3; i++);\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tfor (var i:int = 0; i < 3; i++);\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.collapseEmptyBlocks = true;
        String result = formatter.formatActionScriptText("for (var i:int = 0; i < 3; i++) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var i:int = 0; i < 3; i++) {}", (Object)result);
    }
}

