/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestFieldDeclaration
extends BaseFormatterTests {
    @Test
    public void testWithoutTypeAndWithoutInitializerAndWithoutNamespace() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class ClassWithField\n{\n\tvar myVar\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tvar myVar;\n}", (Object)result);
    }

    @Test
    public void testWithTypeAndWithoutInitializerAndWithoutNamespace() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class ClassWithField\n{\n\tvar myVar:String\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tvar myVar:String;\n}", (Object)result);
    }

    @Test
    public void testWithTypeAndWithInitializerAndWithoutNamespace() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class ClassWithField\n{\n\tvar myVar:Number = 123.4;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tvar myVar:Number = 123.4;\n}", (Object)result);
    }

    @Test
    public void testWithTypeAndWithInitializerAndWithNamespace() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class ClassWithField\n{\n\tpublic var myVar:Number = 123.4;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tpublic var myVar:Number = 123.4;\n}", (Object)result);
    }

    @Test
    public void testWithTypeFollowedByInlineMultilineComment() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class ClassWithField\n{\n\tpublic var myVar:Array /* of Type */;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tpublic var myVar:Array /* of Type */;\n}", (Object)result);
    }

    @Test
    public void testWithFunctionInitializer() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class ClassWithField\n{\n\tpublic var myVar:Function = function() {\n\t};\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tpublic var myVar:Function = function()\n\t{\n\t};\n}", (Object)result);
    }

    @Test
    public void testWithObjectInitializer() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class ClassWithField\n{\n\tvar myVar:Object = {};\n\t// correct indent?\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tvar myVar:Object = {};\n\t// correct indent?\n}", (Object)result);
    }
}

