/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestElseStatement
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition) {\n\tstatement;\n}\nelse {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition)\n{\n\tstatement;\n}\nelse\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition)\n{\n\tstatement;\n}\nelse\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition) {\n\tstatement;\n}\nelse {\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyIfAndElseBlocks() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition) {\n}\nelse {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition)\n{\n}\nelse\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyIfAndElseBlocks() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition)\n{\n}\nelse\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition) {\n}\nelse {\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition) {\n\tstatement;\n}\nelse {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition)\n{\n\tstatement;\n}\nelse\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition)\n{\n\tstatement;\n}\nelse\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition) {\n\tstatement;\n}\nelse {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testBodyWithoutParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition) statement;\nelse statement;", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition)\n\tstatement;\nelse\n\tstatement;", (Object)result);
    }

    @Test
    public void testWithBodyIsSemicolonOnSameLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (true);\nelse;", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true);\nelse;", (Object)result);
    }

    @Test
    public void testWithCommentBetweenIfStatementAndBodyInsideFunction() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("function myFunction():void\n{\n\tif(condition) // comment\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction():void\n{\n\tif (condition) // comment\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tif (condition)\n\t{\n\t}\n\telse\n\t{\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (condition)\n\t{\n\t}\n\telse\n\t{\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithoutParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tif (true)\n\t\tstatement;\n\telse\n\t\tstatement;\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (true)\n\t\tstatement;\n\telse\n\t\tstatement;\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tif (true)\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (true)\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIntentWithBodyIsSemicolonOnSameLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tif (true);\n\telse;\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (true);\n\telse;\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testCommentBeforeStartBody() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (true)\n{\n\tstatement;\n}\nelse // comment\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true)\n{\n\tstatement;\n}\nelse // comment\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testCommentBeforeEndBody() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (true)\n{\n}\nelse\n{\n\tstatement; // comment\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true)\n{\n}\nelse\n{\n\tstatement; // comment\n}", (Object)result);
    }

    @Test
    public void testNested() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition)\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n}\nelse\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition)\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n}\nelse\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n}", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.collapseEmptyBlocks = true;
        String result = formatter.formatActionScriptText("if (condition1) {\n}\nelse {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1) {}\nelse {}", (Object)result);
    }
}

