/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestElseIfStatement
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition1) {\n\tstatement;\n}\nelse if (condition2) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1)\n{\n\tstatement;\n}\nelse if (condition2)\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition1)\n{\n\tstatement;\n}\nelse if (condition2)\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1) {\n\tstatement;\n}\nelse if (condition2) {\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyIfAndElseIfBlocks() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition1) {\n}\nelse if (condition2) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1)\n{\n}\nelse if (condition2)\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyIfAndElseIfBlocks() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition1)\n{\n}\nelse if (condition2)\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1) {\n}\nelse if (condition2) {\n}", (Object)result);
    }

    @Test
    public void testInsertSpaceAfterControlFlowKeyword() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if(condition1)\n{\n\tstatement;\n}\nelse if(condition2)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1)\n{\n\tstatement;\n}\nelse if (condition2)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisableInsertSpaceAfterControlFlowKeyword() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = false;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition1)\n{\n\tstatement;\n}\nelse if (condition2)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if(condition1)\n{\n\tstatement;\n}\nelse if(condition2)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition1) {\n\tstatement;\n}\nelse if (condition2) {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1)\n{\n\tstatement;\n}\nelse if (condition2)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition1)\n{\n\tstatement;\n}\nelse if (condition2)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1) {\n\tstatement;\n}\nelse if (condition2) {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testBodyWithoutParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition1) statement;\nelse if (condition2) statement;", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1)\n\tstatement;\nelse if (condition2)\n\tstatement;", (Object)result);
    }

    @Test
    public void testWithBodyIsSemicolonOnSameLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition1);\nelse if (condition2);", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1);\nelse if (condition2);", (Object)result);
    }

    @Test
    public void testNextIndentWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tif (condition1)\n\t{\n\t}\n\telse if (condition2)\n\t{\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (condition1)\n\t{\n\t}\n\telse if (condition2)\n\t{\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithoutParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tif (condition1)\n\t\tstatement;\n\telse if (condition2)\n\t\tstatement;\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (condition1)\n\t\tstatement;\n\telse if (condition2)\n\t\tstatement;\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tif (condition1)\n\t{\n\t\tstatement;\n\t}\n\telse if (condition2)\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (condition1)\n\t{\n\t\tstatement;\n\t}\n\telse if (condition2)\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIntentWithBodyIsSemicolonOnSameLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tif (condition1);\n\telse if (condition2);\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (condition1);\n\telse if (condition2);\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNested() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition)\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse if (condition)\n\t{\n\t\tstatement;\n\t}\n}\nelse if (condition)\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse if (condition)\n\t{\n\t\tstatement;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition)\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse if (condition)\n\t{\n\t\tstatement;\n\t}\n}\nelse if (condition)\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse if (condition)\n\t{\n\t\tstatement;\n\t}\n}", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.collapseEmptyBlocks = true;
        String result = formatter.formatActionScriptText("if (condition1) {\n}\nelse if (condition2) {\n}\nelse {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1) {}\nelse if (condition2) {}\nelse {}", (Object)result);
    }
}

