/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestDoWhileStatement
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("do {\n}\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do\n{\n}\nwhile (true);", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("do\n{\n}\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do {\n}\nwhile (true);", (Object)result);
    }

    @Test
    public void testInsertSpaceAfterControlFlowKeyword() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("do\n{\n\tstatement;\n}\nwhile(true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do\n{\n\tstatement;\n}\nwhile (true);", (Object)result);
    }

    @Test
    public void testDisableInsertSpaceAfterControlFlowKeyword() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = false;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("do\n{\n\tstatement;\n}\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do\n{\n\tstatement;\n}\nwhile(true);", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("do {\n\tstatement;\n}\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do\n{\n\tstatement;\n}\nwhile (true);", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("do\n{\n\tstatement;\n}\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do {\n\tstatement;\n}\nwhile (true);", (Object)result);
    }

    @Test
    public void testBodyWithoutParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("do statement;\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do\n\tstatement;\nwhile (true);", (Object)result);
    }

    @Test
    public void testWithBodyIsSemicolonOnSameLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("do;\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do;\nwhile (true);", (Object)result);
    }

    @Test
    public void testNextIndentWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tdo\n\t{\n\t}\n\twhile (true);\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tdo\n\t{\n\t}\n\twhile (true);\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithoutParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tdo\n\t\tstatement;\n\twhile (true);\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tdo\n\t\tstatement;\n\twhile (true);\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tdo\n\t{\n\t\tstatement;\n\t}\n\twhile (true);\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tdo\n\t{\n\t\tstatement;\n\t}\n\twhile (true);\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIntentWithBodyIsSemicolonOnSameLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tdo;\n\twhile (true);\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tdo;\n\twhile (true);\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testWithCommentBetweenTryStatementAndBody() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("do // comment\n{\n\tstatement;\n}\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do // comment\n{\n\tstatement;\n}\nwhile (true);", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.collapseEmptyBlocks = true;
        String result = formatter.formatActionScriptText("do {\n}\nwhile (condition1);", (Collection)this.problems);
        Assert.assertEquals((Object)"do {}\nwhile (condition1);", (Object)result);
    }
}

