/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestBreakStatement
extends BaseFormatterTests {
    @Test
    public void testWithoutLabel() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("break;", (Collection)this.problems);
        Assert.assertEquals((Object)"break;", (Object)result);
    }

    @Test
    public void testWithoutLabelAndWithoutSemicolon() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("break", (Collection)this.problems);
        Assert.assertEquals((Object)"break;", (Object)result);
    }

    @Test
    public void testWithLabel() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("break label;", (Collection)this.problems);
        Assert.assertEquals((Object)"break label;", (Object)result);
    }

    @Test
    public void testWithLabelAndWithoutSemicolon() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("break label", (Collection)this.problems);
        Assert.assertEquals((Object)"break label;", (Object)result);
    }

    @Test
    public void testWithLabelOnNextLineCausesAutomaticSemicolonInsertion() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("break\nlabel;", (Collection)this.problems);
        Assert.assertEquals((Object)"break;\nlabel;", (Object)result);
    }
}

