/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestAsDocComment
extends BaseFormatterTests {
    @Test
    public void testOneLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("/** This is a comment */", (Collection)this.problems);
        Assert.assertEquals((Object)"/** This is a comment */", (Object)result);
    }

    @Test
    public void testSpacesBeforeAsterisks() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("/**\n* This is a comment\n*/", (Collection)this.problems);
        Assert.assertEquals((Object)"/**\n * This is a comment\n */", (Object)result);
    }

    @Test
    public void testBeforeClass() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("/**\n * This is a comment\n */\nclass MyClass\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"/**\n * This is a comment\n */\nclass MyClass\n{\n}", (Object)result);
    }

    @Test
    public void testBeforeClassInPackage() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("package com.example\n{\n\t/**\n\t * This is a comment\n\t */\n\tclass MyClass\n\t{\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"package com.example\n{\n\t/**\n\t * This is a comment\n\t */\n\tclass MyClass\n\t{\n\t}\n}", (Object)result);
    }

    @Test
    public void testBeforeInterface() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("/**\n * This is a comment\n */\ninterface MyInterface\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"/**\n * This is a comment\n */\ninterface MyInterface\n{\n}", (Object)result);
    }

    @Test
    public void testBeforeField() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class MyClass\n{\n\t/**\n\t * This is comment\n\t */\n\tpublic var myVar:String;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n{\n\t/**\n\t * This is comment\n\t */\n\tpublic var myVar:String;\n}", (Object)result);
    }

    @Test
    public void testBeforeMethod() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class MyClass\n{\n\t/**\n\t * This is comment\n\t */\n\tpublic function myMethod():void\n\t{\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n{\n\t/**\n\t * This is comment\n\t */\n\tpublic function myMethod():void\n\t{\n\t}\n}", (Object)result);
    }

    @Test
    public void testListing() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("/**\n * Description.\n * \n * <listing>\n * // before\n * \n * </listing>\n * \n * @see test\n */", (Collection)this.problems);
        Assert.assertEquals((Object)"/**\n * Description.\n *\n * <listing>\n * // before\n * \n * </listing>\n *\n * @see test\n */", (Object)result);
    }
}

