/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestArrayLiteral
extends BaseFormatterTests {
    @Test
    public void testEmpty() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("var array:Array = [];", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array = [];", (Object)result);
    }

    @Test
    public void testSingleNumberOnOneLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("var array:Array = [123.4];", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array = [123.4];", (Object)result);
    }

    @Test
    public void testMultipleNumbersOnOneLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("var array:Array = [123.4, 567.8, 901.2];", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array = [123.4, 567.8, 901.2];", (Object)result);
    }

    @Test
    public void testMultipleNumbersOnMultipleLines1() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("var array:Array = [123.4, 567.8,\n\t901.2];\nstatement;", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array = [123.4, 567.8,\n\t\t901.2];\nstatement;", (Object)result);
    }

    @Test
    public void testMultipleNumbersOnMultipleLines2() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("var array:Array =\n\t[\n\t\t123.4,\n\t\t567.8,\n\t\t901.2\n\t];\nstatement;", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array =\n\t[\n\t\t123.4,\n\t\t567.8,\n\t\t901.2\n\t];\nstatement;", (Object)result);
    }

    @Test
    public void testMultipleStringsOnOneLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("var array:Array = [\"abc\", \"hello world\", \"\"];", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array = [\"abc\", \"hello world\", \"\"];", (Object)result);
    }
}

