/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestXML
extends BaseFormatterTests {
    @Test
    public void testEmptyRootElementOnOneLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "<root></root>;", (Collection)this.problems);
        Assert.assertEquals((Object)"<root></root>;", (Object)result);
    }

    @Test
    public void testEmptyRootElementOnMultipleLines() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "<root>\n</root>;", (Collection)this.problems);
        Assert.assertEquals((Object)"<root>\n</root>;", (Object)result);
    }

    @Test
    public void testSelfClosingRootElement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "<root/>;", (Collection)this.problems);
        Assert.assertEquals((Object)"<root/>;", (Object)result);
    }
}

