/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestVariableDeclaration
extends BaseFormatterTests {
    @Test
    public void testWithoutTypeAndWithoutInitializer() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var myVar", (Collection)this.problems);
        Assert.assertEquals((Object)"var myVar;", (Object)result);
    }

    @Test
    public void testWithTypeAndWithoutInitializer() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var myVar:String", (Collection)this.problems);
        Assert.assertEquals((Object)"var myVar:String;", (Object)result);
    }

    @Test
    public void testWithTypeAndWithInitializer() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var myVar:Number = 123.4;", (Collection)this.problems);
        Assert.assertEquals((Object)"var myVar:Number = 123.4;", (Object)result);
    }

    @Test
    public void testWithAnyType() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var myVar:*;", (Collection)this.problems);
        Assert.assertEquals((Object)"var myVar:*;", (Object)result);
    }

    @Test
    public void testWithVectorAnyType() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var myVar:Vector.<*>;", (Collection)this.problems);
        Assert.assertEquals((Object)"var myVar:Vector.<*>;", (Object)result);
    }

    @Test
    public void testChained() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var myVar:Number = what(hi, 2), myVar2:Number = 456.7;", (Collection)this.problems);
        Assert.assertEquals((Object)"var myVar:Number = what(hi, 2), myVar2:Number = 456.7;", (Object)result);
    }
}

