/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestTryCatchStatement
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "try {\n}\ncatch (e:Object) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try\n{\n}\ncatch (e:Object)\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "try\n{\n}\ncatch (e:Object)\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try {\n}\ncatch (e:Object) {\n}", (Object)result);
    }

    @Test
    public void testInsertSpaceAfterControlFlowKeyword() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "try\n{\n\tstatement;\n}\ncatch(e:Object)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try\n{\n\tstatement;\n}\ncatch (e:Object)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisableInsertSpaceAfterControlFlowKeyword() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = false;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "try\n{\n\tstatement;\n}\ncatch (e:Object)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try\n{\n\tstatement;\n}\ncatch(e:Object)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "try {\n\tstatement;\n}\ncatch (e:Object) {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try\n{\n\tstatement;\n}\ncatch (e:Object)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "try\n{\n\tstatement;\n}\ncatch (e:Object)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try {\n\tstatement;\n}\ncatch (e:Object) {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testWithCommentBetweenTryStatementAndBody() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "try // comment\n{\n\tstatement;\n}\ncatch (e:Object) {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try // comment\n{\n\tstatement;\n}\ncatch (e:Object) {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlockWithFinally() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "try {\n}\ncatch (e:Object) {\n}\nfinally {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try\n{\n}\ncatch (e:Object)\n{\n}\nfinally\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlockWithFinally() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "try\n{\n}\ncatch (e:Object)\n{\n}\nfinally\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try {\n}\ncatch (e:Object) {\n}\nfinally {\n}", (Object)result);
    }
}

