/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestThrowStatement
extends BaseFormatterTests {
    @Test
    public void testWithoutValue() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        settings.ignoreProblems = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "throw;", null);
        Assert.assertEquals((Object)"throw;\n;", (Object)result);
    }

    @Test
    public void testWithoutValueAndWithoutSemicolon() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        settings.ignoreProblems = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "throw", null);
        Assert.assertEquals((Object)"throw;", (Object)result);
    }

    @Test
    public void testWithValue() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "throw new Error();", (Collection)this.problems);
        Assert.assertEquals((Object)"throw new Error();", (Object)result);
    }

    @Test
    public void testWithValueAndWithoutSemicolon() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "throw new Error()", (Collection)this.problems);
        Assert.assertEquals((Object)"throw new Error();", (Object)result);
    }

    @Test
    public void testWithValueOnNextLineCausesAutomaticSemicolonInsertion() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        settings.ignoreProblems = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "throw\nnew Error();", null);
        Assert.assertEquals((Object)"throw;\nnew Error();", (Object)result);
    }
}

