/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestTernaryStatement
extends BaseFormatterTests {
    @Test
    public void testBasic() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "condition ? statement : statement;", (Collection)this.problems);
        Assert.assertEquals((Object)"condition ? statement : statement;", (Object)result);
    }

    @Test
    public void testNested() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "condition ? condition ? statement : statement : condition ? statement : statement;", (Collection)this.problems);
        Assert.assertEquals((Object)"condition ? condition ? statement : statement : condition ? statement : statement;", (Object)result);
    }

    @Test
    public void testObjectLiterals() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "condition ? {} : {};", (Collection)this.problems);
        Assert.assertEquals((Object)"condition ? {} : {};", (Object)result);
    }

    @Test
    public void testInsideConditional() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        settings.collapseEmptyBlocks = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition ? statement : statement) {}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition ? statement : statement) {}", (Object)result);
    }
}

