/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestSwitchStatement
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition) {\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseAndStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tcase condition:\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseAndMultipleStatements() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tcase condition:\n\t\tstatement;\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t\tstatement;\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseAndEmptyBlockEnablePlaceOpenBraceOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tcase condition:\n\t{\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t{\n\t}\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseAndEmptyBlockDisablePlaceOpenBraceOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tcase condition:\n\t{\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition) {\n\tcase condition: {\n\t}\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseAndBlockWithStatementEnablePlaceOpenBraceOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tcase condition:\n\t{\n\t\tbreak;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t{\n\t\tbreak;\n\t}\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseAndBlockWithStatementDisablePlaceOpenBraceOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tcase condition:\n\t{\n\t\tbreak;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition) {\n\tcase condition: {\n\t\tbreak;\n\t}\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseAndStatementAfterBlockEnablePlaceOpenBraceOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tcase condition:\n\t{\n\t\tstatement;\n\t}\n\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t\t{\n\t\t\tstatement;\n\t\t}\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseAndStatementAfterBlockDisablePlaceOpenBraceOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tcase condition:\n\t{\n\t\tstatement;\n\t}\n\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition) {\n\tcase condition:\n\t\t{\n\t\t\tstatement;\n\t\t}\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithDefaultClauseAndStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tdefault:\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tdefault:\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithDefaultClauseAndMultipleStatements() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tdefault:\n\t\tstatement;\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tdefault:\n\t\tstatement;\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithDefaultClauseAndEmptyBlockEnablePlaceOpenBraceOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tdefault:\n\t{\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tdefault:\n\t{\n\t}\n}", (Object)result);
    }

    @Test
    public void testWithDefaultClauseAndEmptyBlockDisablePlaceOpenBraceOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tdefault:\n\t{\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition) {\n\tdefault: {\n\t}\n}", (Object)result);
    }

    @Test
    public void testWithDefaultClauseAndBlockWithStatementEnablePlaceOpenBraceOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tdefault:\n\t{\n\t\tbreak;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tdefault:\n\t{\n\t\tbreak;\n\t}\n}", (Object)result);
    }

    @Test
    public void testWithDefaultClauseAndBlockWithStatementDisablePlaceOpenBraceOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tdefault:\n\t{\n\t\tbreak;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition) {\n\tdefault: {\n\t\tbreak;\n\t}\n}", (Object)result);
    }

    @Test
    public void testWithDefaultClauseAndStatementAfterBlockEnablePlaceOpenBraceOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tdefault:\n\t{\n\t\tstatement;\n\t}\n\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tdefault:\n\t\t{\n\t\t\tstatement;\n\t\t}\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithDefaultClauseAndStatementAfterBlockDisablePlaceOpenBraceOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tdefault:\n\t{\n\t\tstatement;\n\t}\n\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition) {\n\tdefault:\n\t\t{\n\t\t\tstatement;\n\t\t}\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithMultipleCaseClauses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tcase condition:\n\t\tbreak;\n\tcase condition:\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t\tbreak;\n\tcase condition:\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithCaseAndDefaultClauses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tcase condition:\n\t\tbreak;\n\tdefault:\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t\tbreak;\n\tdefault:\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseFallthrough() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tcase condition:\n\tcase condition:\n\t\tbreak;\n\tcase condition:\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\tcase condition:\n\t\tbreak;\n\tcase condition:\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tswitch (condition)\n\t{\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithCaseClause() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tswitch (condition)\n\t{\n\t\tcase clause:\n\t\t\tbreak;\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t\tcase clause:\n\t\t\tbreak;\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithCaseClauseAndEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tswitch (condition)\n\t{\n\t\tcase clause:\n\t\t{\n\t\t}\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t\tcase clause:\n\t\t{\n\t\t}\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithCaseClauseAndBlockWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tswitch (condition)\n\t{\n\t\tcase clause:\n\t\t{\n\t\t\tbreak;\n\t\t}\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t\tcase clause:\n\t\t{\n\t\t\tbreak;\n\t\t}\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithDefaultClause() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tswitch (condition)\n\t{\n\t\tdefault:\n\t\t\tbreak;\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t\tdefault:\n\t\t\tbreak;\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithDefaultClauseAndEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tswitch (condition)\n\t{\n\t\tdefault:\n\t\t{\n\t\t}\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t\tdefault:\n\t\t{\n\t\t}\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithDefaultClauseAndBlockWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tswitch (condition)\n\t{\n\t\tdefault:\n\t\t{\n\t\t\tbreak;\n\t\t}\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t\tdefault:\n\t\t{\n\t\t\tbreak;\n\t\t}\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testCommentOnSameLineAsCaseClause() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tcase clause://what\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase clause: // what\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testCommentOnSameLineAsDefaultClause() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "switch (condition)\n{\n\tdefault://what\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tdefault: // what\n}", (Object)result);
    }
}

