/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestStringLiteral
extends BaseFormatterTests {
    @Test
    public void testEmptyString() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "\"\";", (Collection)this.problems);
        Assert.assertEquals((Object)"\"\";", (Object)result);
    }

    @Test
    public void testWithNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "\"\\n\";", (Collection)this.problems);
        Assert.assertEquals((Object)"\"\\n\";", (Object)result);
    }

    @Test
    public void testDoubleQuoteWithEscapedDoubleQuote() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "\"\\\"\";", (Collection)this.problems);
        Assert.assertEquals((Object)"\"\\\"\";", (Object)result);
    }

    @Test
    public void testDoubleQuoteWithUnescapedSingleQuote() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "\"'\";", (Collection)this.problems);
        Assert.assertEquals((Object)"\"'\";", (Object)result);
    }

    @Test
    public void testSingleQuoteWithEscapedSingleQuote() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "'\\'';", (Collection)this.problems);
        Assert.assertEquals((Object)"'\\'';", (Object)result);
    }

    @Test
    public void testSingleQuoteWithUnescapedDoubleQuote() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "'\"';", (Collection)this.problems);
        Assert.assertEquals((Object)"'\"';", (Object)result);
    }

    @Test
    public void testVerbatimDoubleQuoteWithBackslash() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "@\"\\\";", (Collection)this.problems);
        Assert.assertEquals((Object)"@\"\\\";", (Object)result);
    }
}

