/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestSingleLineComment
extends BaseFormatterTests {
    @Test
    public void testInsertSpaceAtStartOfLineComment() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        settings.insertSpaceAtStartOfLineComment = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "//this is a comment", (Collection)this.problems);
        Assert.assertEquals((Object)"// this is a comment", (Object)result);
    }

    @Test
    public void testDisableInsertSpaceAtStartOfLineComment() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        settings.insertSpaceAtStartOfLineComment = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "// this is a comment", (Collection)this.problems);
        Assert.assertEquals((Object)"//this is a comment", (Object)result);
    }

    @Test
    public void testAtEndOfStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        settings.insertSpaceAtStartOfLineComment = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "statement; // this is a comment", (Collection)this.problems);
        Assert.assertEquals((Object)"statement; // this is a comment", (Object)result);
    }

    @Test
    public void testOnLineBeforeStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        settings.insertSpaceAtStartOfLineComment = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "// this is a comment\nstatement;", (Collection)this.problems);
        Assert.assertEquals((Object)"// this is a comment\nstatement;", (Object)result);
    }

    @Test
    public void testWithExtraLineBeforeStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        settings.insertSpaceAtStartOfLineComment = true;
        settings.maxPreserveNewLines = 2;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "// this is a comment\n\nstatement;", (Collection)this.problems);
        Assert.assertEquals((Object)"// this is a comment\n\nstatement;", (Object)result);
    }

    @Test
    public void testOnLineAfterStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        settings.insertSpaceAtStartOfLineComment = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "statement;\n// this is a comment", (Collection)this.problems);
        Assert.assertEquals((Object)"statement;\n// this is a comment", (Object)result);
    }

    @Test
    public void testAtEndOfControlFlowStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        settings.insertSpaceAtStartOfLineComment = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (statement) // this is a comment\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (statement) // this is a comment\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testAtEndOfBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        settings.insertSpaceAtStartOfLineComment = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tstatement;\n} // this is a comment\nstatement;", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tstatement;\n} // this is a comment\nstatement;", (Object)result);
    }
}

