/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestReturnStatement
extends BaseFormatterTests {
    @Test
    public void testWithoutValue() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "return;", (Collection)this.problems);
        Assert.assertEquals((Object)"return;", (Object)result);
    }

    @Test
    public void testWithoutValueAndWithoutSemicolon() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "return", (Collection)this.problems);
        Assert.assertEquals((Object)"return;", (Object)result);
    }

    @Test
    public void testWithValue() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "return 123;", (Collection)this.problems);
        Assert.assertEquals((Object)"return 123;", (Object)result);
    }

    @Test
    public void testWithValueAndWithoutSemicolon() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "return 123", (Collection)this.problems);
        Assert.assertEquals((Object)"return 123;", (Object)result);
    }

    @Test
    public void testWithValueOnNextLineCausesAutomaticSemicolonInsertion() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "return\n123;", (Collection)this.problems);
        Assert.assertEquals((Object)"return;\n123;", (Object)result);
    }
}

