/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestPreserveNewLines
extends BaseFormatterTests {
    @Test
    public void testNoMaxPreserveNewLines() {
        FormatterSettings settings = new FormatterSettings();
        settings.maxPreserveNewLines = 0;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "/* this is a comment */\n\n\n/* this is a comment */", (Collection)this.problems);
        Assert.assertEquals((Object)"/* this is a comment */\n\n\n/* this is a comment */", (Object)result);
    }

    @Test
    public void testMaxPreserveNewLines() {
        FormatterSettings settings = new FormatterSettings();
        settings.maxPreserveNewLines = 2;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "/* this is a comment */\n\n\n/* this is a comment */", (Collection)this.problems);
        Assert.assertEquals((Object)"/* this is a comment */\n\n/* this is a comment */", (Object)result);
    }

    @Test
    public void testNewLinesBeforeEndOfStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.maxPreserveNewLines = 0;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "1 + 2\n\n+ 3\n\t+ 4;", (Collection)this.problems);
        Assert.assertEquals((Object)"1 + 2\n\n\t+ 3\n\t+ 4;", (Object)result);
    }
}

