/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestObjectLiteral
extends BaseFormatterTests {
    @Test
    public void testEmpty() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var obj:Object = {};", (Collection)this.problems);
        Assert.assertEquals((Object)"var obj:Object = {};", (Object)result);
    }

    @Test
    public void testOneFieldOnSingleLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var obj:Object = {one: 123.4};", (Collection)this.problems);
        Assert.assertEquals((Object)"var obj:Object = {one: 123.4};", (Object)result);
    }

    @Test
    public void testOneFieldOnMultipleLines() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var obj:Object = {\n\tone: 123.4\n};\nstatement;", (Collection)this.problems);
        Assert.assertEquals((Object)"var obj:Object = {\n\t\tone: 123.4\n\t};\nstatement;", (Object)result);
    }

    @Test
    public void testMultipleFields() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var obj:Object = {one: 123.4, two: \"hello world\"};", (Collection)this.problems);
        Assert.assertEquals((Object)"var obj:Object = {one: 123.4, two: \"hello world\"};", (Object)result);
    }

    @Test
    public void testMultipleFieldsOnMultipleLines1() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var obj:Object = {\n\tone: 123.4,\n\ttwo: \"hello world\"\n};\nstatement;", (Collection)this.problems);
        Assert.assertEquals((Object)"var obj:Object = {\n\t\tone: 123.4,\n\t\ttwo: \"hello world\"\n\t};\nstatement;", (Object)result);
    }

    @Test
    public void testMultipleFieldsOnMultipleLines2() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var obj:Object = {\n\tone: 123.4,\n\ttwo: \"hello world\", three: true\n};\nstatement;", (Collection)this.problems);
        Assert.assertEquals((Object)"var obj:Object = {\n\t\tone: 123.4,\n\t\ttwo: \"hello world\", three: true\n\t};\nstatement;", (Object)result);
    }

    @Test
    public void testStringField() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var obj:Object = {\"string-field\": 123.4};", (Collection)this.problems);
        Assert.assertEquals((Object)"var obj:Object = {\"string-field\": 123.4};", (Object)result);
    }
}

