/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestNumberLiteral
extends BaseFormatterTests {
    @Test
    public void testFloat() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "123.4;", (Collection)this.problems);
        Assert.assertEquals((Object)"123.4;", (Object)result);
    }

    @Test
    public void testNegativeFloat() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "-123.4;", (Collection)this.problems);
        Assert.assertEquals((Object)"-123.4;", (Object)result);
    }

    @Test
    public void testInt() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "123;", (Collection)this.problems);
        Assert.assertEquals((Object)"123;", (Object)result);
    }

    @Test
    public void testNegativeInt() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "-123;", (Collection)this.problems);
        Assert.assertEquals((Object)"-123;", (Object)result);
    }

    @Test
    public void testHexadecimal() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "0xfe1c23;", (Collection)this.problems);
        Assert.assertEquals((Object)"0xfe1c23;", (Object)result);
    }

    @Test
    public void testNegativeHexadecimal() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "-0xfe1c23;", (Collection)this.problems);
        Assert.assertEquals((Object)"-0xfe1c23;", (Object)result);
    }

    @Test
    public void testExponential() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "1.234e5;", (Collection)this.problems);
        Assert.assertEquals((Object)"1.234e5;", (Object)result);
    }

    @Test
    public void testNegativeExponential() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "1.234e-5;", (Collection)this.problems);
        Assert.assertEquals((Object)"1.234e-5;", (Object)result);
    }
}

