/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestNewStatement
extends BaseFormatterTests {
    @Test
    public void testWithClassNoParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "new Sprite;", (Collection)this.problems);
        Assert.assertEquals((Object)"new Sprite;", (Object)result);
    }

    @Test
    public void testWithClassConstructorCall() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "new Sprite();", (Collection)this.problems);
        Assert.assertEquals((Object)"new Sprite();", (Object)result);
    }

    @Test
    public void testWithVectorLiteral() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "new <Sprite>[];", (Collection)this.problems);
        Assert.assertEquals((Object)"new <Sprite>[];", (Object)result);
    }

    @Test
    public void testWithVectorLiteralAnyType() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "new <*>[];", (Collection)this.problems);
        Assert.assertEquals((Object)"new <*>[];", (Object)result);
    }
}

