/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestMetadata
extends BaseFormatterTests {
    @Test
    public void testUnknownMetaTagOnClassWithoutAttributes() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "[UnknownMetaTag]\nclass MyClass\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"[UnknownMetaTag]\nclass MyClass\n{\n}", (Object)result);
    }

    @Test
    public void testUnknownMetaTagOnClassWithoutAttributeNameAndWithValue() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "[UnknownMetaTag(\"value\")]\nclass MyClass\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"[UnknownMetaTag(\"value\")]\nclass MyClass\n{\n}", (Object)result);
    }

    @Test
    public void testUnknownMetaTagOnClassWithAttributeAndWithValue() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "[UnknownMetaTag(unknownAttr=\"value\")]\nclass MyClass\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"[UnknownMetaTag(unknownAttr=\"value\")]\nclass MyClass\n{\n}", (Object)result);
    }

    @Test
    public void testUnknownMetaTagOnClassWithMultipleAttributes() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "[UnknownMetaTag(unknownAttr1=\"value1\",unknownAttr2=\"value2\")]\nclass MyClass\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"[UnknownMetaTag(unknownAttr1=\"value1\", unknownAttr2=\"value2\")]\nclass MyClass\n{\n}", (Object)result);
    }

    @Test
    public void testEventMetaTagOnClassWithNameAndTypeAttributes() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "[Event(name=\"change\", type=\"flash.events.Event\")]\nclass MyClass\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"[Event(name=\"change\", type=\"flash.events.Event\")]\nclass MyClass\n{\n}", (Object)result);
    }

    @Test
    public void testBindableMetaTagOnFieldWithoutAttributes() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass\n{\n\t[Bindable]\n\tpublic var myVar:String;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n{\n\t[Bindable]\n\tpublic var myVar:String;\n}", (Object)result);
    }

    @Test
    public void testBindableMetaTagOnFieldWithValue() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass\n{\n\t[Bindable(\"myVarChanged\")]\n\tpublic var myVar:String;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n{\n\t[Bindable(\"myVarChanged\")]\n\tpublic var myVar:String;\n}", (Object)result);
    }

    @Test
    public void testBindableMetaTagOnFieldWithEventAttribute() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass\n{\n\t[Bindable(event = \"myVarChanged\")]\n\tpublic var myVar:String;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n{\n\t[Bindable(event=\"myVarChanged\")]\n\tpublic var myVar:String;\n}", (Object)result);
    }

    @Test
    public void testAfterSingleLineComment() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "// comment\n[UnknownMetaTag(attr1=\"one\")]\n", (Collection)this.problems);
        Assert.assertEquals((Object)"// comment\n[UnknownMetaTag(attr1=\"one\")]\n", (Object)result);
    }

    @Test
    public void testAfterMultiLineComment() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "/* comment */\n[UnknownMetaTag(attr1=\"one\")]\n", (Collection)this.problems);
        Assert.assertEquals((Object)"/* comment */\n[UnknownMetaTag(attr1=\"one\")]\n", (Object)result);
    }
}

