/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.apache.royale.formatter.MXMLTokenFormatter;
import org.junit.Assert;
import org.junit.Test;

public class TestMXMLTag
extends BaseFormatterTests {
    @Test
    public void testSelfClosingTag() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaces = false;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<s:Tag />", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag/>", (Object)result);
    }

    @Test
    public void testTagWithEmptyText() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaces = false;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<s:Tag></s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag></s:Tag>", (Object)result);
    }

    @Test
    public void testTagWithText() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaces = false;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<s:Tag>Hello World</s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag>Hello World</s:Tag>", (Object)result);
    }

    @Test
    public void testTagWithTextAndNewLines() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaces = false;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<s:Tag>\n\tHello World\n</s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag>\n\tHello World\n</s:Tag>", (Object)result);
    }

    @Test
    public void testTagWithNewLineText() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaces = false;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<s:Tag>\n</s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag>\n</s:Tag>", (Object)result);
    }

    @Test
    public void testNewLinesBetweenTags() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaces = false;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<s:Tag>\n\n</s:Tag>\n\n<s:Tag/>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag>\n\n</s:Tag>\n\n<s:Tag/>", (Object)result);
    }

    @Test
    public void testExcessWhitespaceBetweenTags() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaces = false;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<s:Tag>\t\n\n\t\t</s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag>\n\n</s:Tag>", (Object)result);
    }

    @Test
    public void testMixedTextAndTagChildren1() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaces = false;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<s:Tag>text <s:Tag/></s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag>text <s:Tag/></s:Tag>", (Object)result);
    }

    @Test
    public void testMixedTextAndTagChildren2() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaces = false;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<s:Tag><s:Tag/> text</s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag><s:Tag/> text</s:Tag>", (Object)result);
    }

    @Test
    public void testMixedTextAndTagChildren3() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaces = false;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<s:Tag><s:Tag/> text <s:Tag/></s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag><s:Tag/> text <s:Tag/></s:Tag>", (Object)result);
    }

    @Test
    public void testMultipleAttributes() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaces = false;
        settings.mxmlInsertNewLineBetweenAttributes = false;
        settings.mxmlAlignAttributes = false;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<s:Tag one=\"1\"   two=\"2\"/>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag one=\"1\" two=\"2\"/>", (Object)result);
    }

    @Test
    public void testMultipleAttributesOnePerLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaces = false;
        settings.mxmlInsertNewLineBetweenAttributes = true;
        settings.mxmlAlignAttributes = false;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<s:Tag one=\"1\" two=\"2\"/>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag one=\"1\"\n\ttwo=\"2\"/>", (Object)result);
    }

    @Test
    public void testMXMLAlignAttributes() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaces = false;
        settings.mxmlInsertNewLineBetweenAttributes = true;
        settings.mxmlAlignAttributes = true;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<s:Tag one=\"1\" two=\"2\" three=\"3\"/>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag one=\"1\"\n\t   two=\"2\"\n\t   three=\"3\"/>", (Object)result);
    }
}

