/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestLogicalOperators
extends BaseFormatterTests {
    @Test
    public void testLogicalNotOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "!a;", (Collection)this.problems);
        Assert.assertEquals((Object)"!a;", (Object)result);
    }

    @Test
    public void testLogicalAndOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a&&b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a && b;", (Object)result);
    }

    @Test
    public void testLogicalOrOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a||b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a || b;", (Object)result);
    }

    @Test
    public void testLogicalAndCompoundAssignmentOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a&&=b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a &&= b;", (Object)result);
    }

    @Test
    public void testLogicalOrCompoundAssignmentOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a||=b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a ||= b;", (Object)result);
    }

    @Test
    public void testNullishCoalescingOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a??b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a ?? b;", (Object)result);
    }
}

