/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestInterfaceDeclaration
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "interface MyInterface {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "interface MyInterface\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface {\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "interface MyInterface {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "interface MyInterface\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testOneMethod() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "interface MyInterface\n{\n\tfunction myMethod():void;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface\n{\n\tfunction myMethod():void;\n}", (Object)result);
    }

    @Test
    public void testMultipleMethods() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "interface MyInterface\n{\n\tfunction myMethod1():void;\n\tfunction myMethod2():void;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface\n{\n\tfunction myMethod1():void;\n\tfunction myMethod2():void;\n}", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.collapseEmptyBlocks = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "interface MyInterface {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface {}", (Object)result);
    }

    @Test
    public void testExtends() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "interface MyInterface extends MyOtherInterface {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface extends MyOtherInterface\n{\n}", (Object)result);
    }

    @Test
    public void testExtendsOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "interface MyInterface\n\textends MyOtherInterface {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface\n\textends MyOtherInterface\n{\n}", (Object)result);
    }

    @Test
    public void testExtendsMultiple() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "interface MyInterface extends MyOtherInterface, MyOtherInterface2 {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface extends MyOtherInterface, MyOtherInterface2\n{\n}", (Object)result);
    }
}

