/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestIdentifier
extends BaseFormatterTests {
    @Test
    public void testBasic() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"identifier;", (Object)result);
    }

    @Test
    public void testUnaryPlus() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "+identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"+identifier;", (Object)result);
    }

    @Test
    public void testUnaryPlusWithLeadingOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var a = +identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"var a = +identifier;", (Object)result);
    }

    @Test
    public void testUnaryMinus() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "-identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"-identifier;", (Object)result);
    }

    @Test
    public void testUnaryMinusWithLeadingOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var a = -identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"var a = -identifier;", (Object)result);
    }

    @Test
    public void testUnaryMinusWithParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "(-identifier);", (Collection)this.problems);
        Assert.assertEquals((Object)"(-identifier);", (Object)result);
    }

    @Test
    public void testUnaryMinusWithBrackets() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a[-identifier];", (Collection)this.problems);
        Assert.assertEquals((Object)"a[-identifier];", (Object)result);
    }

    @Test
    public void testUnaryMinusWithBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\t-identifier;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\t-identifier;\n}", (Object)result);
    }

    @Test
    public void testUnaryMinusWithSemicolon() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a;\n-identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"a;\n-identifier;", (Object)result);
    }

    @Test
    public void testUnaryMinusWithReturn() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "return -identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"return -identifier;", (Object)result);
    }

    @Test
    public void testUnaryMinusWithComma() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var array = [identifier, -identifier];", (Collection)this.problems);
        Assert.assertEquals((Object)"var array = [identifier, -identifier];", (Object)result);
    }

    @Test
    public void testUnaryMinusWithColon() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var obj = {field: -identifier};", (Collection)this.problems);
        Assert.assertEquals((Object)"var obj = {field: -identifier};", (Object)result);
    }

    @Test
    public void testNot() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "!identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"!identifier;", (Object)result);
    }

    @Test
    public void testDoubleNot() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "!!identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"!!identifier;", (Object)result);
    }
}

