/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestFunctionDeclaration
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "function myFunction() {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction()\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "function myFunction()\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction() {\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "function myFunction() {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction()\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "function myFunction()\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction() {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testReturnType() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "function myFunction():void\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction():void\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testParameter() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "function myFunction(p1:String)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction(p1:String)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testParameters() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "function myFunction(p1:String, p2:Number)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction(p1:String, p2:Number)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNewLinesAmongParameters() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "function myFunction(p1:String,\np2:Number):void\n{\n\tstatement;\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction(p1:String,\n\t\tp2:Number):void\n{\n\tstatement;\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testParametersWithRest() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "function myFunction(p1:String, ...rest)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction(p1:String, ...rest)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testParametersRestOnly() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "function myFunction(...rest)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction(...rest)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testWrappedInParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "(function myFunction(...rest)\n{\n\tstatement;\n});", (Collection)this.problems);
        Assert.assertEquals((Object)"(function myFunction(...rest)\n\t{\n\t\tstatement;\n\t});", (Object)result);
    }

    @Test
    public void testAsArgument() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "identifier(function myFunction(...rest)\n{\n\tstatement;\n}, 123.4);", (Collection)this.problems);
        Assert.assertEquals((Object)"identifier(function myFunction(...rest)\n\t{\n\t\tstatement;\n\t}, 123.4);", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.collapseEmptyBlocks = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "function myFunction() {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction() {}", (Object)result);
    }

    @Test
    public void testNested() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "function myFunction(param:String):void\n{\n\tfunction myOtherFunction(param:Number):void\n\t{\n\t\tstatement;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction(param:String):void\n{\n\tfunction myOtherFunction(param:Number):void\n\t{\n\t\tstatement;\n\t}\n}", (Object)result);
    }
}

