/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.apache.royale.formatter.MXMLTokenFormatter;
import org.junit.Assert;
import org.junit.Test;

public class TestFormatterOff
extends BaseFormatterTests {
    @Test
    public void testAS3FormatterOff() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = true;
        settings.tabSize = 2;
        settings.maxPreserveNewLines = 2;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "\t// @formatter:off\nfor(var i:int=0;i<3;i++){\n\ttrace(i)//print to console\n\n\n\n}\n\t// @formatter:on\nfor(var i:int=0;i<3;i++){\n\ttrace(i)//print to console\n\n\n\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"// @formatter:off\nfor(var i:int=0;i<3;i++){\n\ttrace(i)//print to console\n\n\n\n}\n\t// @formatter:on\nfor (var i:int = 0; i < 3; i++)\n{\n  trace(i); // print to console\n\n}", (Object)result);
    }

    @Test
    public void testMXMLFormatterOff() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = true;
        settings.tabSize = 2;
        settings.maxPreserveNewLines = 2;
        MXMLTokenFormatter formatter = new MXMLTokenFormatter(settings);
        String result = formatter.format("file.mxml", "<mx:Application>\n\t<!-- @formatter:off -->\n\t<mx:Button />\n\n\n\n\t<!-- @formatter:on -->\n\t<mx:Button />\n\n\n\n</mx:Application>", (Collection)this.problems);
        Assert.assertEquals((Object)"<mx:Application>\n  <!-- @formatter:off -->\n\t<mx:Button />\n\n\n\n\t<!-- @formatter:on -->\n  <mx:Button/>\n\n</mx:Application>", (Object)result);
    }
}

