/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestForInStatement
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "for (var key:String in object) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var key:String in object)\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "for (var key:String in object)\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var key:String in object) {\n}", (Object)result);
    }

    @Test
    public void testInsertSpaceAfterControlFlowKeyword() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "for(var key:String in object)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var key:String in object)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisableInsertSpaceAfterControlFlowKeyword() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = false;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "for (var key:String in object)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for(var key:String in object)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "for (var key:String in object) {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var key:String in object)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "for (var key:String in object)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var key:String in object) {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testBodyWithoutParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "for (var key:String in object) statement;", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var key:String in object)\n\tstatement;", (Object)result);
    }

    @Test
    public void testWithBodyIsSemicolonOnSameLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "for (var key:String in object);", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var key:String in object);", (Object)result);
    }

    @Test
    public void testNextIndentWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tfor each (var key:String in object)\n\t{\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tfor each (var key:String in object)\n\t{\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithoutParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tfor (var key:String in object)\n\t\tstatement;\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tfor (var key:String in object)\n\t\tstatement;\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tfor (var key:String in object)\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tfor (var key:String in object)\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIntentWithBodyIsSemicolonOnSameLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tfor (var key:String in object);\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tfor (var key:String in object);\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.collapseEmptyBlocks = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "for (var key:String in object) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"for (var key:String in object) {}", (Object)result);
    }
}

