/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestFieldDeclaration
extends BaseFormatterTests {
    @Test
    public void testWithoutTypeAndWithoutInitializerAndWithoutNamespace() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class ClassWithField\n{\n\tvar myVar\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tvar myVar;\n}", (Object)result);
    }

    @Test
    public void testWithTypeAndWithoutInitializerAndWithoutNamespace() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class ClassWithField\n{\n\tvar myVar:String\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tvar myVar:String;\n}", (Object)result);
    }

    @Test
    public void testWithTypeAndWithInitializerAndWithoutNamespace() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class ClassWithField\n{\n\tvar myVar:Number = 123.4;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tvar myVar:Number = 123.4;\n}", (Object)result);
    }

    @Test
    public void testWithTypeAndWithInitializerAndWithNamespace() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class ClassWithField\n{\n\tpublic var myVar:Number = 123.4;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tpublic var myVar:Number = 123.4;\n}", (Object)result);
    }

    @Test
    public void testWithTypeFollowedByInlineMultilineComment() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class ClassWithField\n{\n\tpublic var myVar:Array /* of Type */;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tpublic var myVar:Array /* of Type */;\n}", (Object)result);
    }

    @Test
    public void testWithFunctionInitializer() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class ClassWithField\n{\n\tpublic var myVar:Function = function() {\n\t};\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tpublic var myVar:Function = function()\n\t{\n\t};\n}", (Object)result);
    }

    @Test
    public void testWithObjectInitializer() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class ClassWithField\n{\n\tvar myVar:Object = {};\n\t// correct indent?\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithField\n{\n\tvar myVar:Object = {};\n\t// correct indent?\n}", (Object)result);
    }
}

