/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestElseStatement
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition) {\n\tstatement;\n}\nelse {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition)\n{\n\tstatement;\n}\nelse\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition)\n{\n\tstatement;\n}\nelse\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition) {\n\tstatement;\n}\nelse {\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyIfAndElseBlocks() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition) {\n}\nelse {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition)\n{\n}\nelse\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyIfAndElseBlocks() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition)\n{\n}\nelse\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition) {\n}\nelse {\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition) {\n\tstatement;\n}\nelse {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition)\n{\n\tstatement;\n}\nelse\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition)\n{\n\tstatement;\n}\nelse\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition) {\n\tstatement;\n}\nelse {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testBodyWithoutParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition) statement;\nelse statement;", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition)\n\tstatement;\nelse\n\tstatement;", (Object)result);
    }

    @Test
    public void testWithBodyIsSemicolonOnSameLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (true);\nelse;", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true);\nelse;", (Object)result);
    }

    @Test
    public void testWithCommentBetweenIfStatementAndBodyInsideFunction() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "function myFunction():void\n{\n\tif(condition) // comment\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"function myFunction():void\n{\n\tif (condition) // comment\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tif (condition)\n\t{\n\t}\n\telse\n\t{\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (condition)\n\t{\n\t}\n\telse\n\t{\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithoutParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tif (true)\n\t\tstatement;\n\telse\n\t\tstatement;\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (true)\n\t\tstatement;\n\telse\n\t\tstatement;\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tif (true)\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (true)\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIntentWithBodyIsSemicolonOnSameLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tif (true);\n\telse;\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (true);\n\telse;\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testCommentBeforeStartBody() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (true)\n{\n\tstatement;\n}\nelse // comment\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true)\n{\n\tstatement;\n}\nelse // comment\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testCommentBeforeEndBody() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (true)\n{\n}\nelse\n{\n\tstatement; // comment\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true)\n{\n}\nelse\n{\n\tstatement; // comment\n}", (Object)result);
    }

    @Test
    public void testNested() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition)\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n}\nelse\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition)\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n}\nelse\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse\n\t{\n\t\tstatement;\n\t}\n}", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.collapseEmptyBlocks = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition1) {\n}\nelse {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1) {}\nelse {}", (Object)result);
    }
}

