/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestElseIfStatement
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition1) {\n\tstatement;\n}\nelse if (condition2) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1)\n{\n\tstatement;\n}\nelse if (condition2)\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition1)\n{\n\tstatement;\n}\nelse if (condition2)\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1) {\n\tstatement;\n}\nelse if (condition2) {\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyIfAndElseIfBlocks() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition1) {\n}\nelse if (condition2) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1)\n{\n}\nelse if (condition2)\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyIfAndElseIfBlocks() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition1)\n{\n}\nelse if (condition2)\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1) {\n}\nelse if (condition2) {\n}", (Object)result);
    }

    @Test
    public void testInsertSpaceAfterControlFlowKeyword() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if(condition1)\n{\n\tstatement;\n}\nelse if(condition2)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1)\n{\n\tstatement;\n}\nelse if (condition2)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisableInsertSpaceAfterControlFlowKeyword() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = false;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition1)\n{\n\tstatement;\n}\nelse if (condition2)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if(condition1)\n{\n\tstatement;\n}\nelse if(condition2)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition1) {\n\tstatement;\n}\nelse if (condition2) {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1)\n{\n\tstatement;\n}\nelse if (condition2)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition1)\n{\n\tstatement;\n}\nelse if (condition2)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1) {\n\tstatement;\n}\nelse if (condition2) {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testBodyWithoutParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition1) statement;\nelse if (condition2) statement;", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1)\n\tstatement;\nelse if (condition2)\n\tstatement;", (Object)result);
    }

    @Test
    public void testWithBodyIsSemicolonOnSameLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition1);\nelse if (condition2);", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1);\nelse if (condition2);", (Object)result);
    }

    @Test
    public void testNextIndentWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tif (condition1)\n\t{\n\t}\n\telse if (condition2)\n\t{\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (condition1)\n\t{\n\t}\n\telse if (condition2)\n\t{\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithoutParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tif (condition1)\n\t\tstatement;\n\telse if (condition2)\n\t\tstatement;\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (condition1)\n\t\tstatement;\n\telse if (condition2)\n\t\tstatement;\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tif (condition1)\n\t{\n\t\tstatement;\n\t}\n\telse if (condition2)\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (condition1)\n\t{\n\t\tstatement;\n\t}\n\telse if (condition2)\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIntentWithBodyIsSemicolonOnSameLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tif (condition1);\n\telse if (condition2);\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (condition1);\n\telse if (condition2);\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNested() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition)\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse if (condition)\n\t{\n\t\tstatement;\n\t}\n}\nelse if (condition)\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse if (condition)\n\t{\n\t\tstatement;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition)\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse if (condition)\n\t{\n\t\tstatement;\n\t}\n}\nelse if (condition)\n{\n\tif (condition)\n\t{\n\t\tstatement;\n\t}\n\telse if (condition)\n\t{\n\t\tstatement;\n\t}\n}", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.collapseEmptyBlocks = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "if (condition1) {\n}\nelse if (condition2) {\n}\nelse {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1) {}\nelse if (condition2) {}\nelse {}", (Object)result);
    }
}

