/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestDoWhileStatement
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "do {\n}\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do\n{\n}\nwhile (true);", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "do\n{\n}\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do {\n}\nwhile (true);", (Object)result);
    }

    @Test
    public void testInsertSpaceAfterControlFlowKeyword() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "do\n{\n\tstatement;\n}\nwhile(true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do\n{\n\tstatement;\n}\nwhile (true);", (Object)result);
    }

    @Test
    public void testDisableInsertSpaceAfterControlFlowKeyword() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = false;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "do\n{\n\tstatement;\n}\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do\n{\n\tstatement;\n}\nwhile(true);", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "do {\n\tstatement;\n}\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do\n{\n\tstatement;\n}\nwhile (true);", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "do\n{\n\tstatement;\n}\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do {\n\tstatement;\n}\nwhile (true);", (Object)result);
    }

    @Test
    public void testBodyWithoutParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "do statement;\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do\n\tstatement;\nwhile (true);", (Object)result);
    }

    @Test
    public void testWithBodyIsSemicolonOnSameLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "do;\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do;\nwhile (true);", (Object)result);
    }

    @Test
    public void testNextIndentWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tdo\n\t{\n\t}\n\twhile (true);\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tdo\n\t{\n\t}\n\twhile (true);\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithoutParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tdo\n\t\tstatement;\n\twhile (true);\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tdo\n\t\tstatement;\n\twhile (true);\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithParentheses() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tdo\n\t{\n\t\tstatement;\n\t}\n\twhile (true);\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tdo\n\t{\n\t\tstatement;\n\t}\n\twhile (true);\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIntentWithBodyIsSemicolonOnSameLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "{\n\tdo;\n\twhile (true);\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tdo;\n\twhile (true);\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testWithCommentBetweenTryStatementAndBody() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "do // comment\n{\n\tstatement;\n}\nwhile (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"do // comment\n{\n\tstatement;\n}\nwhile (true);", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.collapseEmptyBlocks = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "do {\n}\nwhile (condition1);", (Collection)this.problems);
        Assert.assertEquals((Object)"do {}\nwhile (condition1);", (Object)result);
    }
}

