/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestContinueStatement
extends BaseFormatterTests {
    @Test
    public void testWithoutLabel() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "continue;", (Collection)this.problems);
        Assert.assertEquals((Object)"continue;", (Object)result);
    }

    @Test
    public void testWithoutLabelAndWithoutSemicolon() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "continue", (Collection)this.problems);
        Assert.assertEquals((Object)"continue;", (Object)result);
    }

    @Test
    public void testWithLabel() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "continue label;", (Collection)this.problems);
        Assert.assertEquals((Object)"continue label;", (Object)result);
    }

    @Test
    public void testWithLabelAndWithoutSemicolon() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "continue label", (Collection)this.problems);
        Assert.assertEquals((Object)"continue label;", (Object)result);
    }

    @Test
    public void testWithLabelOnNextLineCausesAutomaticSemicolonInsertion() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "continue\nlabel;", (Collection)this.problems);
        Assert.assertEquals((Object)"continue;\nlabel;", (Object)result);
    }
}

