/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestConstDeclaration
extends BaseFormatterTests {
    @Test
    public void testWithoutTypeAndWithoutInitializer() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "const myConst", (Collection)this.problems);
        Assert.assertEquals((Object)"const myConst;", (Object)result);
    }

    @Test
    public void testWithTypeAndWithoutInitializer() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "const myConst:String", (Collection)this.problems);
        Assert.assertEquals((Object)"const myConst:String;", (Object)result);
    }

    @Test
    public void testWithTypeAndWithInitializer() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "const myConst:Number = 123.4;", (Collection)this.problems);
        Assert.assertEquals((Object)"const myConst:Number = 123.4;", (Object)result);
    }
}

