/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestClassDeclaration
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass {\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = false;
        settings.collapseEmptyBlocks = true;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass {}", (Object)result);
    }

    @Test
    public void testExtends() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass extends MyOtherClass {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass extends MyOtherClass\n{\n}", (Object)result);
    }

    @Test
    public void testExtendsOnNewLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass\n\textends MyOtherClass {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n\textends MyOtherClass\n{\n}", (Object)result);
    }

    @Test
    public void testImplements() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass implements MyInterface {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass implements MyInterface\n{\n}", (Object)result);
    }

    @Test
    public void testImplementsMultiple() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass implements MyInterface, MyOtherInterface {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass implements MyInterface, MyOtherInterface\n{\n}", (Object)result);
    }

    @Test
    public void testExtendsAndImplementsOnMultipleLines() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass\n\textends MyOtherClass\n\timplements MyInterface {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n\textends MyOtherClass\n\timplements MyInterface\n{\n}", (Object)result);
    }
}

