/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestBreakStatement
extends BaseFormatterTests {
    @Test
    public void testWithoutLabel() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "break;", (Collection)this.problems);
        Assert.assertEquals((Object)"break;", (Object)result);
    }

    @Test
    public void testWithoutLabelAndWithoutSemicolon() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "break", (Collection)this.problems);
        Assert.assertEquals((Object)"break;", (Object)result);
    }

    @Test
    public void testWithLabel() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "break label;", (Collection)this.problems);
        Assert.assertEquals((Object)"break label;", (Object)result);
    }

    @Test
    public void testWithLabelAndWithoutSemicolon() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "break label", (Collection)this.problems);
        Assert.assertEquals((Object)"break label;", (Object)result);
    }

    @Test
    public void testWithLabelOnNextLineCausesAutomaticSemicolonInsertion() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "break\nlabel;", (Collection)this.problems);
        Assert.assertEquals((Object)"break;\nlabel;", (Object)result);
    }
}

