/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestBitwiseOperators
extends BaseFormatterTests {
    @Test
    public void testBitwiseNotOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "~a;", (Collection)this.problems);
        Assert.assertEquals((Object)"~a;", (Object)result);
    }

    @Test
    public void testBitwiseAndOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a&b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a & b;", (Object)result);
    }

    @Test
    public void testBitwiseOrOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a|b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a | b;", (Object)result);
    }

    @Test
    public void testBitwiseXorOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a^b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a ^ b;", (Object)result);
    }

    @Test
    public void testBitwiseLeftShiftOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a<<b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a << b;", (Object)result);
    }

    @Test
    public void testBitwiseRightShiftOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a>>b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a >> b;", (Object)result);
    }

    @Test
    public void testBitwiseRightUnsignedShiftOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a>>>b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a >>> b;", (Object)result);
    }

    @Test
    public void testBitwiseAndCompoundAssignmentOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a&=b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a &= b;", (Object)result);
    }

    @Test
    public void testBitwiseOrCompoundAssignmentOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a|=b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a |= b;", (Object)result);
    }

    @Test
    public void testBitwiseXorCompoundAssignmentOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a^=b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a ^= b;", (Object)result);
    }

    @Test
    public void testBitwiseLeftShiftCompoundAssignmentOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a<<=b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a <<= b;", (Object)result);
    }

    @Test
    public void testBitwiseRightShiftCompoundAssignmentOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a>>=b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a >>= b;", (Object)result);
    }

    @Test
    public void testBitwiseRightUnsignedShiftCompoundAssignmentOperator() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "a>>>=b;", (Collection)this.problems);
        Assert.assertEquals((Object)"a >>>= b;", (Object)result);
    }
}

