/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestAsDocComment
extends BaseFormatterTests {
    @Test
    public void testOneLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "/** This is a comment */", (Collection)this.problems);
        Assert.assertEquals((Object)"/** This is a comment */", (Object)result);
    }

    @Test
    public void testSpacesBeforeAsterisks() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "/**\n* This is a comment\n*/", (Collection)this.problems);
        Assert.assertEquals((Object)"/**\n * This is a comment\n */", (Object)result);
    }

    @Test
    public void testBeforeClass() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "/**\n * This is a comment\n */\nclass MyClass\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"/**\n * This is a comment\n */\nclass MyClass\n{\n}", (Object)result);
    }

    @Test
    public void testBeforeClassInPackage() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "package com.example\n{\n\t/**\n\t * This is a comment\n\t */\n\tclass MyClass\n\t{\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"package com.example\n{\n\t/**\n\t * This is a comment\n\t */\n\tclass MyClass\n\t{\n\t}\n}", (Object)result);
    }

    @Test
    public void testBeforeInterface() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "/**\n * This is a comment\n */\ninterface MyInterface\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"/**\n * This is a comment\n */\ninterface MyInterface\n{\n}", (Object)result);
    }

    @Test
    public void testBeforeField() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass\n{\n\t/**\n\t * This is comment\n\t */\n\tpublic var myVar:String;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n{\n\t/**\n\t * This is comment\n\t */\n\tpublic var myVar:String;\n}", (Object)result);
    }

    @Test
    public void testBeforeMethod() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "class MyClass\n{\n\t/**\n\t * This is comment\n\t */\n\tpublic function myMethod():void\n\t{\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n{\n\t/**\n\t * This is comment\n\t */\n\tpublic function myMethod():void\n\t{\n\t}\n}", (Object)result);
    }

    @Test
    public void testListing() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceAfterKeywordsInControlFlowStatements = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "/**\n * Description.\n * \n * <listing>\n * // before\n * \n * </listing>\n * \n * @see test\n */", (Collection)this.problems);
        Assert.assertEquals((Object)"/**\n * Description.\n *\n * <listing>\n * // before\n * \n * </listing>\n *\n * @see test\n */", (Object)result);
    }
}

