/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FormatterSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestArrayLiteral
extends BaseFormatterTests {
    @Test
    public void testEmpty() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var array:Array = [];", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array = [];", (Object)result);
    }

    @Test
    public void testSingleNumberOnOneLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var array:Array = [123.4];", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array = [123.4];", (Object)result);
    }

    @Test
    public void testMultipleNumbersOnOneLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var array:Array = [123.4, 567.8, 901.2];", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array = [123.4, 567.8, 901.2];", (Object)result);
    }

    @Test
    public void testMultipleNumbersOnMultipleLines1() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var array:Array = [123.4, 567.8,\n\t901.2];\nstatement;", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array = [123.4, 567.8,\n\t\t901.2];\nstatement;", (Object)result);
    }

    @Test
    public void testMultipleNumbersOnMultipleLines2() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var array:Array =\n\t[\n\t\t123.4,\n\t\t567.8,\n\t\t901.2\n\t];\nstatement;", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array =\n\t[\n\t\t123.4,\n\t\t567.8,\n\t\t901.2\n\t];\nstatement;", (Object)result);
    }

    @Test
    public void testMultipleStringsOnOneLine() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var array:Array = [\"abc\", \"hello world\", \"\"];", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array = [\"abc\", \"hello world\", \"\"];", (Object)result);
    }

    @Test
    public void testFunction() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var array:Array = [\n\tfunction():void {\n\t\tif (condition1\n\t\t\t&& condition2) {\n\t\t\tstatement;\n\t\t}\n\t}\n];", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array = [\n\t\tfunction():void\n\t\t{\n\t\t\tif (condition1\n\t\t\t\t&& condition2)\n\t\t\t{\n\t\t\t\tstatement;\n\t\t\t}\n\t\t}\n\t];", (Object)result);
    }

    @Test
    public void testObjectLiteral() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var array:Array = [\n\t{\n\t\tvalue: 123.4\n\t}\n];", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array = [\n\t\t{\n\t\t\tvalue: 123.4\n\t\t}\n\t];", (Object)result);
    }

    @Test
    public void testNested() {
        FormatterSettings settings = new FormatterSettings();
        settings.insertSpaceBeforeAndAfterBinaryOperators = true;
        settings.placeOpenBraceOnNewLine = true;
        settings.insertSpaces = false;
        ASTokenFormatter formatter = new ASTokenFormatter(settings);
        String result = formatter.format("file.as", "var array:Array = [\n\t[1, 2, 3],\n\t['one',\n\t\t'two', 'three'],\n\t[\n\t\t123.4,\n\t\t567.8\n\t]\n];", (Collection)this.problems);
        Assert.assertEquals((Object)"var array:Array = [\n\t\t[1, 2, 3],\n\t\t['one',\n\t\t\t'two', 'three'],\n\t\t[\n\t\t\t123.4,\n\t\t\t567.8\n\t\t]\n\t];", (Object)result);
    }
}

