/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.localization.LocalizationManager;
import flash.swf.Action;
import flash.swf.actions.ConstantPool;
import flash.swf.tools.Disassembler;
import flash.swf.types.ActionList;
import flash.tools.ActionLocation;
import flash.tools.debugger.Bootstrap;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SuspendedException;
import flash.tools.debugger.SwfInfo;
import flash.tools.debugger.Value;
import flash.tools.debugger.concrete.DMessage;
import flash.tools.debugger.concrete.DMessageCounter;
import flash.tools.debugger.concrete.DModule;
import flash.tools.debugger.concrete.DSuspendInfo;
import flash.tools.debugger.concrete.DSwfInfo;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.PlayerSessionManager;
import flash.util.FieldFormat;
import flex.tools.debugger.cli.AmbiguousException;
import flex.tools.debugger.cli.DebugCLI;
import flex.tools.debugger.cli.FileInfoCache;
import flex.tools.debugger.cli.FileLocation;
import flex.tools.debugger.cli.NoMatchException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.HashMap;

public class Extensions {
    public static final String m_newline = System.getProperty("line.separator");

    public static void doShowStats(DebugCLI cli) throws IllegalStateException {
        Session session = cli.getSession();
        StringBuilder sb = new StringBuilder();
        try {
            long amt;
            int i;
            PlayerSession p = (PlayerSession)session;
            DMessageCounter cnt = p.getMessageCounter();
            sb.append(Extensions.getLocalizationManager().getLocalizedTextString("key16"));
            sb.append(m_newline);
            for (i = 0; i <= 65; ++i) {
                amt = cnt.getInCount(i);
                if (amt <= 0L) continue;
                sb.append('\n');
                sb.append(DMessage.inTypeName(i));
                sb.append(" = ");
                sb.append(amt);
            }
            sb.append("\n\n");
            sb.append(Extensions.getLocalizationManager().getLocalizedTextString("key17"));
            sb.append("\n");
            for (i = 0; i <= 57; ++i) {
                amt = cnt.getOutCount(i);
                if (amt <= 0L) continue;
                sb.append('\n');
                sb.append(DMessage.outTypeName(i));
                sb.append(" = ");
                sb.append(amt);
            }
            sb.append('\n');
            cli.out(sb.toString());
        }
        catch (NullPointerException e) {
            throw new IllegalStateException();
        }
    }

    public static void doShowFuncs(DebugCLI cli) {
        StringBuilder sb = new StringBuilder();
        String arg = null;
        FileInfoCache fileInfo = cli.getFileCache();
        try {
            if (cli.hasMoreTokens()) {
                arg = cli.nextToken();
                int id = arg.equals(".") ? cli.propertyGet("$listmodule") : cli.parseFileArg(cli.getActiveIsolateId(), -1, arg);
                DModule m = (DModule)fileInfo.getFile(id, cli.getActiveIsolateId());
                m.lineMapping(sb);
            } else {
                SourceFile[] ar = fileInfo.getFileList();
                if (ar == null) {
                    cli.err(Extensions.getLocalizationManager().getLocalizedTextString("key18"));
                } else {
                    for (int i = 0; i < ar.length; ++i) {
                        DModule m = (DModule)ar[i];
                        m.lineMapping(sb);
                    }
                }
            }
            cli.out(sb.toString());
        }
        catch (NullPointerException npe) {
            cli.err(Extensions.getLocalizationManager().getLocalizedTextString("key19"));
        }
        catch (ParseException pe) {
            cli.err(pe.getMessage());
        }
        catch (AmbiguousException ae) {
            cli.err(ae.getMessage());
        }
        catch (NoMatchException nme) {
            cli.err(nme.getMessage());
        }
    }

    public static void doShowProperties(DebugCLI cli) {
        Object value;
        StringBuilder sb = new StringBuilder();
        Session session = cli.getSession();
        for (String key : cli.propertyKeys()) {
            int value2 = cli.propertyGet(key);
            sb.append(key);
            sb.append(" = ");
            sb.append(value2);
            sb.append('\n');
        }
        PlayerSessionManager mgr = (PlayerSessionManager)Bootstrap.sessionManager();
        sb.append(Extensions.getLocalizationManager().getLocalizedTextString("key21"));
        sb.append('\n');
        for (String key : mgr.keySet()) {
            value = mgr.getPreferenceAsObject(key);
            sb.append(key);
            sb.append(" = ");
            sb.append(value);
            sb.append('\n');
        }
        if (session != null) {
            PlayerSession psession = (PlayerSession)session;
            sb.append(Extensions.getLocalizationManager().getLocalizedTextString("key22"));
            sb.append('\n');
            for (String key : psession.keySet()) {
                value = psession.getPreferenceAsObject(key);
                sb.append(key);
                sb.append(" = ");
                sb.append(value);
                sb.append('\n');
            }
        }
        cli.out(sb.toString());
    }

    public static void doShowBreak(DebugCLI cli) throws NotConnectedException {
        int isolateId = cli.getActiveIsolateId();
        cli.waitTilHalted(isolateId);
        try {
            Session session = cli.getSession();
            StringBuilder sb = new StringBuilder();
            if (session.getWorkerSession(isolateId).isSuspended()) {
                sb.append(Extensions.getLocalizationManager().getLocalizedTextString("stopped"));
                sb.append(' ');
                Extensions.appendBreakInfo(cli, sb, true, isolateId);
            } else {
                sb.append(Extensions.getLocalizationManager().getLocalizedTextString("key24"));
            }
            cli.out(sb.toString());
        }
        catch (NullPointerException npe) {
            cli.err(Extensions.getLocalizationManager().getLocalizedTextString("key25"));
        }
    }

    public static void appendBreakInfo(DebugCLI cli, StringBuilder sb, boolean includeFault, int isolateId) throws NotConnectedException {
        HashMap<String, Object> args;
        Session session = cli.getSession();
        FileInfoCache fileInfo = cli.getFileCache();
        int reason = session.suspendReason();
        int offset = ((PlayerSession)session).getSuspendOffset();
        int index = ((PlayerSession)session).getSuspendActionIndex();
        SwfInfo info = null;
        try {
            info = fileInfo.getSwfs(isolateId)[index];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (info != null) {
            args = new HashMap<String, Object>();
            args.put("swfName", FileInfoCache.nameOfSwf(info));
            sb.append(Extensions.getLocalizationManager().getLocalizedTextString("key35", args));
            sb.append(' ');
        }
        args = new HashMap();
        args.put("address", "0x" + FieldFormat.formatLongToHex((StringBuilder)new StringBuilder(), (long)offset, (int)8) + " (" + offset + ")");
        sb.append(Extensions.getLocalizationManager().getLocalizedTextString("atAddress", args));
        if (includeFault) {
            args = new HashMap();
            StringBuilder reasonBuffer = new StringBuilder();
            cli.appendReason(reasonBuffer, reason);
            args.put("fault", reasonBuffer.toString());
            sb.append(' ');
            sb.append(Extensions.getLocalizationManager().getLocalizedTextString("haltedDueToFault", args));
        }
    }

    public static void doShowVariable(DebugCLI cli) throws PlayerDebugException {
        int isolateId = cli.getActiveIsolateId();
        cli.waitTilHalted(isolateId);
        try {
            Session session = cli.getSession();
            long id = cli.nextLongToken();
            String name = cli.hasMoreTokens() ? cli.nextToken() : null;
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append(" = ");
            Value v = ((PlayerSession)session).getValue(id, name, isolateId);
            cli.m_exprCache.appendVariableValue(sb, v, isolateId);
            cli.out(sb.toString());
        }
        catch (NullPointerException npe) {
            cli.err(Extensions.getLocalizationManager().getLocalizedTextString("key26"));
        }
    }

    public static void doDisassemble(DebugCLI cli) throws PlayerDebugException {
        int currentModule = cli.propertyGet("$listmodule");
        int currentLine = cli.propertyGet("$listline");
        int currentIsolate = cli.propertyGet("$listworker");
        String arg1 = null;
        int module1 = currentModule;
        int line1 = currentLine;
        String arg2 = null;
        int line2 = currentLine;
        boolean functionNamed = false;
        int numLines = 0;
        try {
            FileInfoCache fileInfo = cli.getFileCache();
            Session session = cli.getSession();
            int isolateId = cli.getActiveIsolateId();
            if (cli.hasMoreTokens()) {
                arg1 = cli.nextToken();
                if (arg1.equals("-")) {
                    line1 = line2 = line1 - 1;
                } else {
                    boolean wasFunc = false;
                    FileLocation[] fileLocations = cli.parseLocationArg(currentModule, currentLine, arg1, false);
                    if (fileLocations.length == 1) {
                        module1 = fileLocations[0].getModule();
                        line2 = line1 = fileLocations[0].getLine();
                        boolean bl = functionNamed = fileLocations[0].getWasFunc() != 0;
                    }
                    if (cli.hasMoreTokens()) {
                        arg2 = cli.nextToken();
                        line2 = cli.parseLineArg(module1, arg2);
                    }
                }
            } else if (fileInfo.getFile(currentModule, currentIsolate) == null) {
                DSuspendInfo info = ((PlayerSession)session).getSuspendInfoIsolate(isolateId);
                int at = info.getOffset();
                int which = info.getActionIndex();
                int until = info.getNextOffset();
                if (info.getReason() == 0) {
                    throw new SuspendedException();
                }
                SwfInfo swf = fileInfo.getSwfs(isolateId)[which];
                Extensions.outputAssembly(cli, (DSwfInfo)swf, at, until);
                throw new AmbiguousException(Extensions.getLocalizationManager().getLocalizedTextString("key27"));
            }
            if (cli.hasMoreTokens()) {
                cli.err(Extensions.getLocalizationManager().getLocalizedTextString("key28"));
            } else {
                SourceFile file = fileInfo.getFile(module1);
                numLines = file.getLineCount();
                if (line1 > numLines && arg1 != null) {
                    throw new IndexOutOfBoundsException();
                }
                if (arg2 == null) {
                    line2 = line1;
                }
                if (line1 < 1) {
                    line2 += -(line1 - 1);
                    line1 = 1;
                }
                if (line2 > numLines) {
                    line2 = numLines;
                }
                if (line1 > line2) {
                    throw new IndexOutOfBoundsException();
                }
                DSwfInfo swf = (DSwfInfo)fileInfo.swfForFile(file, cli.getActiveIsolateId());
                ActionLocation lStart = null;
                ActionLocation lEnd = null;
                if (swf == null) {
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("arg3", file.getName());
                    cli.err(Extensions.getLocalizationManager().getLocalizedTextString("key29", args));
                } else if (functionNamed) {
                    int offset = file.getOffsetForLine(line1);
                    lStart = swf.locate(offset);
                    if (lStart.function == null) {
                        cli.err(Extensions.getLocalizationManager().getLocalizedTextString("key30"));
                    } else {
                        ActionList al = new ActionList(true);
                        al.setActionOffset(0, (Action)lStart.function);
                        lStart.actions = al;
                        lStart.at = 0;
                        lEnd = new ActionLocation();
                        lEnd.actions = al;
                        lEnd.at = 0;
                        Extensions.outputAssembly(cli, (SwfInfo)swf, lStart, lEnd);
                    }
                } else {
                    ActionLocation lastEnd = null;
                    for (int i = line1; i <= line2; ++i) {
                        int offset = file.getOffsetForLine(i);
                        if (offset != 0) {
                            lStart = swf.locate(offset);
                            lEnd = swf.locateSourceLineEnd(lStart);
                            if (lastEnd != null) {
                                ++lastEnd.at;
                                if (lastEnd.actions != lStart.actions && lastEnd.actions.size() != lastEnd.at) {
                                    String atString = Integer.toHexString(lastEnd.actions.getOffset(lastEnd.at));
                                    HashMap<String, String> args = new HashMap<String, String>();
                                    args.put("arg4", atString);
                                    cli.out(Extensions.getLocalizationManager().getLocalizedTextString("key31", args));
                                    ActionLocation gapEnd = swf.locateSourceLineEnd(lastEnd);
                                    Extensions.outputAssembly(cli, (SwfInfo)swf, lastEnd, gapEnd);
                                } else if (lastEnd.at < lStart.at) {
                                    ActionLocation gapEnd = new ActionLocation(lStart);
                                    --gapEnd.at;
                                    Extensions.outputAssembly(cli, (SwfInfo)swf, lastEnd, gapEnd);
                                }
                            }
                            lastEnd = lEnd;
                        }
                        cli.outputSource(module1, i, file.getLine(i));
                        if (offset == 0) continue;
                        Extensions.outputAssembly(cli, (SwfInfo)swf, lStart, lEnd);
                    }
                    cli.propertyPut("$listmodule", module1);
                    cli.propertyPut("$listline", line2 + 1);
                    cli.m_repeatLine = "disassemble";
                }
            }
        }
        catch (IndexOutOfBoundsException iob) {
            String name = "#" + module1;
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("arg5", Integer.toString(line1));
            args.put("arg6", name);
            args.put("arg7", Integer.toString(numLines));
            cli.err(Extensions.getLocalizationManager().getLocalizedTextString("key32", args));
        }
        catch (AmbiguousException ae) {
            cli.err(ae.getMessage());
        }
        catch (NullPointerException npe) {
            cli.err(Extensions.getLocalizationManager().getLocalizedTextString("key33"));
        }
        catch (ParseException pe) {
            cli.err(pe.getMessage());
        }
        catch (NoMatchException nme) {
            cli.err(nme.getMessage());
        }
        catch (SuspendedException se) {
            cli.err(Extensions.getLocalizationManager().getLocalizedTextString("key34"));
        }
    }

    private static LocalizationManager getLocalizationManager() {
        return DebugCLI.getLocalizationManager();
    }

    public static ActionLocation outputAssembly(DebugCLI cli, DSwfInfo swf, int start, int end) {
        ActionLocation lStart = swf.locate(start);
        ActionLocation lEnd = end > -1 ? swf.locate(end) : swf.locateSourceLineEnd(lStart);
        return Extensions.outputAssembly(cli, (SwfInfo)swf, lStart, lEnd);
    }

    public static ActionLocation outputAssembly(DebugCLI cli, SwfInfo info, ActionLocation lStart, ActionLocation lEnd) {
        if (lStart.actions != lEnd.actions) {
            lEnd.at = lStart.actions.size() - 1;
        }
        Disassembler.disassemble((ActionList)lStart.actions, (ConstantPool)lStart.pool, (int)lStart.at, (int)lEnd.at, (PrintWriter)new PrintWriter(cli.getOut()));
        return lEnd;
    }
}

