/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.tools.debugger.Bootstrap;
import flash.tools.debugger.DebuggerLocalizer;
import flash.tools.debugger.Frame;
import flash.tools.debugger.InProgressException;
import flash.tools.debugger.Isolate;
import flash.tools.debugger.IsolateSession;
import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSupportedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SessionManager;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SourceLocator;
import flash.tools.debugger.SuspendedException;
import flash.tools.debugger.SwfInfo;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.VersionException;
import flash.tools.debugger.Watch;
import flash.tools.debugger.concrete.DSwfInfo;
import flash.tools.debugger.events.BreakEvent;
import flash.tools.debugger.events.ConsoleErrorFault;
import flash.tools.debugger.events.DebugEvent;
import flash.tools.debugger.events.ExceptionFault;
import flash.tools.debugger.events.FaultEvent;
import flash.tools.debugger.events.FileListModifiedEvent;
import flash.tools.debugger.events.FunctionMetaDataAvailableEvent;
import flash.tools.debugger.events.IsolateCreateEvent;
import flash.tools.debugger.events.IsolateExitEvent;
import flash.tools.debugger.events.SwfLoadedEvent;
import flash.tools.debugger.events.SwfUnloadedEvent;
import flash.tools.debugger.events.TraceEvent;
import flash.tools.debugger.expression.ECMA;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;
import flash.tools.debugger.expression.ValueExp;
import flash.util.FieldFormat;
import flash.util.Trace;
import flex.tools.debugger.cli.AmbiguousException;
import flex.tools.debugger.cli.BreakAction;
import flex.tools.debugger.cli.CatchAction;
import flex.tools.debugger.cli.DisplayAction;
import flex.tools.debugger.cli.ExpressionCache;
import flex.tools.debugger.cli.Extensions;
import flex.tools.debugger.cli.FaultActions;
import flex.tools.debugger.cli.FileInfoCache;
import flex.tools.debugger.cli.FileLocation;
import flex.tools.debugger.cli.Help;
import flex.tools.debugger.cli.InternalProperty;
import flex.tools.debugger.cli.LocationCollection;
import flex.tools.debugger.cli.NoMatchException;
import flex.tools.debugger.cli.StringIntArray;
import flex.tools.debugger.cli.VariableFacade;
import flex.tools.debugger.cli.WatchAction;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang.LocaleUtils;

public class DebugCLI
implements Runnable,
SourceLocator {
    public static final String VERSION = "82";
    public static final int CMD_UNKNOWN = 0;
    public static final int CMD_QUIT = 1;
    public static final int CMD_CONTINUE = 2;
    public static final int CMD_STEP = 3;
    public static final int CMD_NEXT = 4;
    public static final int CMD_FINISH = 5;
    public static final int CMD_BREAK = 6;
    public static final int CMD_SET = 7;
    public static final int CMD_LIST = 8;
    public static final int CMD_PRINT = 9;
    public static final int CMD_TUTORIAL = 10;
    public static final int CMD_INFO = 11;
    public static final int CMD_HOME = 12;
    public static final int CMD_RUN = 13;
    public static final int CMD_FILE = 14;
    public static final int CMD_DELETE = 15;
    public static final int CMD_SOURCE = 16;
    public static final int CMD_COMMENT = 17;
    public static final int CMD_CLEAR = 18;
    public static final int CMD_HELP = 19;
    public static final int CMD_SHOW = 20;
    public static final int CMD_KILL = 21;
    public static final int CMD_HANDLE = 22;
    public static final int CMD_ENABLE = 23;
    public static final int CMD_DISABLE = 24;
    public static final int CMD_DISPLAY = 25;
    public static final int CMD_UNDISPLAY = 26;
    public static final int CMD_COMMANDS = 27;
    public static final int CMD_PWD = 28;
    public static final int CMD_CF = 29;
    public static final int CMD_CONDITION = 30;
    public static final int CMD_AWATCH = 31;
    public static final int CMD_WATCH = 32;
    public static final int CMD_RWATCH = 33;
    public static final int CMD_WHAT = 34;
    public static final int CMD_DISASSEMBLE = 35;
    public static final int CMD_HALT = 36;
    public static final int CMD_MCTREE = 37;
    public static final int CMD_VIEW_SWF = 38;
    public static final int CMD_DOWN = 39;
    public static final int CMD_UP = 40;
    public static final int CMD_FRAME = 41;
    public static final int CMD_DIRECTORY = 42;
    public static final int CMD_CATCH = 43;
    public static final int CMD_CONNECT = 44;
    public static final int CMD_WORKER = 45;
    public static final int INFO_UNKNOWN_CMD = 100;
    public static final int INFO_ARGS_CMD = 101;
    public static final int INFO_BREAK_CMD = 102;
    public static final int INFO_FILES_CMD = 103;
    public static final int INFO_HANDLE_CMD = 104;
    public static final int INFO_FUNCTIONS_CMD = 105;
    public static final int INFO_LOCALS_CMD = 106;
    public static final int INFO_SCOPECHAIN_CMD = 107;
    public static final int INFO_SOURCES_CMD = 108;
    public static final int INFO_STACK_CMD = 109;
    public static final int INFO_VARIABLES_CMD = 110;
    public static final int INFO_DISPLAY_CMD = 111;
    public static final int INFO_TARGETS_CMD = 112;
    public static final int INFO_SWFS_CMD = 113;
    public static final int INFO_WORKERS_CMD = 114;
    public static final int SHOW_UNKNOWN_CMD = 200;
    public static final int SHOW_NET_CMD = 201;
    public static final int SHOW_FUNC_CMD = 202;
    public static final int SHOW_URI_CMD = 203;
    public static final int SHOW_PROPERTIES_CMD = 204;
    public static final int SHOW_FILES_CMD = 205;
    public static final int SHOW_BREAK_CMD = 206;
    public static final int SHOW_VAR_CMD = 207;
    public static final int SHOW_MEM_CMD = 208;
    public static final int SHOW_LOC_CMD = 209;
    public static final int SHOW_DIRS_CMD = 210;
    public static final int ENABLE_ONCE_CMD = 301;
    public static final int METADATA_RETRIES = 40;
    public static final boolean WORKER_DISPLAY_INTERNAL_SWAP_INFO = true;
    Stack<LineNumberReader> m_readerStack = new Stack();
    public PrintStream m_err;
    public PrintStream m_out;
    Session m_session;
    String m_launchURI;
    boolean m_fullnameOption = false;
    String m_cdPath;
    String m_mruURI = null;
    String m_connectPort;
    private boolean m_quietMode;
    public static final String m_newline = System.getProperty("line.separator");
    private static final LocalizationManager m_localizationManager = new LocalizationManager();
    private static final FaultActions.FaultActionsBuilder faultActionsBuilder = new FaultActions.FaultActionsBuilder(m_localizationManager);
    List<String> m_sourceDirectories;
    int m_sourceDirectoriesChangeCount;
    private File m_flexHomeDirectory;
    private boolean m_initializedFlexHomeDirectory;
    FileInfoCache m_fileInfo;
    FaultActions m_faultTable = faultActionsBuilder.build();
    Vector<Integer> m_breakIsolates;
    ExpressionCache m_exprCache = new ExpressionCache(this);
    Vector<BreakAction> m_breakpoints = new Vector();
    Vector<WatchAction> m_watchpoints = new Vector();
    Vector<CatchAction> m_catchpoints = new Vector();
    ArrayList<DisplayAction> m_displays = new ArrayList();
    int m_activeIsolate;
    DebugCLIIsolateState m_mainState;
    int m_lastPromptIsolate;
    private HashMap<Integer, DebugCLIIsolateState> m_isolateState;
    LineNumberReader m_in;
    public LineNumberReader m_keyboardStream;
    Vector<String> m_keyboardInput = new Vector();
    boolean m_keyboardReadRequest;
    StringTokenizer m_currentTokenizer;
    String m_currentToken;
    String m_currentLine;
    public String m_repeatLine;
    private boolean m_isIde;
    public static final String LIST_MODULE = "$listmodule";
    public static final String LIST_LINE = "$listline";
    public static final String LIST_WORKER = "$listworker";
    private static final String LIST_SIZE = "$listsize";
    private static final String COLUMN_WIDTH = "$columnwidth";
    private static final String UPDATE_DELAY = "$updatedelay";
    private static final String HALT_TIMEOUT = "$halttimeout";
    private static final String BPNUM = "$bpnum";
    private static final String LAST_FRAME_DEPTH = "$lastframedepth";
    private static final String CURRENT_FRAME_DEPTH = "$currentframedepth";
    public static final String DISPLAY_FRAME_NUMBER = "$displayframenumber";
    private static final String FILE_LIST_WRAP = "$filelistwrap";
    private static final String NO_WAITING = "$nowaiting";
    private static final String INFO_STACK_SHOW_THIS = "$infostackshowthis";
    private static final String PLAYER_FULL_SUPPORT = "$playerfullsupport";
    public static final String DISPLAY_ATTRIBUTES = "$displayattributes";
    private static final int AUTHORED_FILE = 1;
    private static final int FRAMEWORK_FILE = 2;
    private static final int SYNTHETIC_FILE = 3;
    private static final int ACTIONS_FILE = 4;
    private static final String[] FRAMEWORK_FILE_PACKAGES;
    static StringIntArray g_commandArray;
    static StringIntArray g_infoCommandArray;
    static StringIntArray g_showCommandArray;
    static StringIntArray g_enableCommandArray;
    static StringIntArray g_disableCommandArray;

    private DebugCLIIsolateState getIsolateState(int isolateId) {
        if (isolateId == 1) {
            return this.m_mainState;
        }
        DebugCLIIsolateState isolateState = null;
        if (!this.m_isolateState.containsKey(isolateId)) {
            isolateState = new DebugCLIIsolateState(this);
            this.m_isolateState.put(isolateId, isolateState);
        } else {
            isolateState = this.m_isolateState.get(isolateId);
        }
        return isolateState;
    }

    public int getActiveIsolateId() {
        return this.m_activeIsolate;
    }

    private boolean getRequestResume(int isolateId) {
        return this.getIsolateState((int)isolateId).m_requestResume;
    }

    private void setRequestResume(boolean value, int isolateId) {
        this.getIsolateState((int)isolateId).m_requestResume = value;
    }

    private boolean getStepResume(int isolateId) {
        return this.getIsolateState((int)isolateId).m_stepResume;
    }

    private void setStepResume(boolean value, int isolateId) {
        this.getIsolateState((int)isolateId).m_stepResume = value;
    }

    private boolean getRequestHalt(int isolateId) {
        return this.getIsolateState((int)isolateId).m_requestHalt;
    }

    private void setRequestHalt(boolean value, int isolateId) {
        this.getIsolateState((int)isolateId).m_requestHalt = value;
    }

    private InitialPromptState getPromptState(int isolateId) {
        return this.getIsolateState((int)isolateId).m_promptState;
    }

    private void setPromptState(InitialPromptState value, int isolateId) {
        this.getIsolateState((int)isolateId).m_promptState = value;
    }

    public static void main(String[] args) {
        FileReader sr;
        DebugCLI cli = new DebugCLI();
        cli.m_err = System.err;
        cli.m_out = System.out;
        cli.initSourceDirectoriesList();
        cli.m_keyboardStream = new LineNumberReader(new InputStreamReader(System.in));
        cli.pushStream(cli.m_keyboardStream);
        cli.processArgs(args);
        String userHome = System.getProperty("user.home");
        String userDir = System.getProperty("user.dir");
        if (userDir != null && !userDir.equals(userHome)) {
            try {
                sr = new FileReader(new File(userDir, ".fdbinit"));
                cli.pushStream(new LineNumberReader(sr));
            }
            catch (FileNotFoundException sr2) {
                // empty catch block
            }
        }
        if (userHome != null) {
            try {
                sr = new FileReader(new File(userHome, ".fdbinit"));
                cli.pushStream(new LineNumberReader(sr));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        cli.execute();
    }

    public DebugCLI() {
        this.m_sourceDirectories = new LinkedList<String>();
        this.initProperties();
        this.m_mainState = new DebugCLIIsolateState(this);
        this.m_lastPromptIsolate = -1;
        this.initIsolateState();
    }

    public static LocalizationManager getLocalizationManager() {
        return m_localizationManager;
    }

    public Session getSession() {
        return this.m_session;
    }

    public FileInfoCache getFileCache() {
        return this.m_fileInfo;
    }

    public boolean isIde() {
        return this.m_isIde;
    }

    public String module2ClassName(int moduleId) {
        String pkg = null;
        try {
            SourceFile file = this.m_fileInfo.getFile(moduleId);
            pkg = file.getPackageName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pkg;
    }

    LineNumberReader popStream() {
        return this.m_readerStack.pop();
    }

    public void pushStream(LineNumberReader r) {
        this.m_readerStack.push(r);
    }

    boolean haveStreams() {
        return !this.m_readerStack.empty();
    }

    public void processArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) == '-') {
                if (arg.equals("-unit")) {
                    System.setProperty("fdbunit", "");
                    continue;
                }
                if (arg.equals("-fullname") || arg.equals("-f")) {
                    this.m_fullnameOption = true;
                    continue;
                }
                if (arg.equals("-cd")) {
                    if (i + 1 >= args.length) continue;
                    this.m_cdPath = args[i++];
                    continue;
                }
                if (arg.equals("-p")) {
                    if (i + 1 >= args.length) continue;
                    this.m_connectPort = args[++i];
                    continue;
                }
                if (arg.equals("-ide")) {
                    this.m_isIde = true;
                    continue;
                }
                if (arg.equals("-lang")) {
                    if (i + 1 >= args.length) continue;
                    DebugCLI.getLocalizationManager().setLocale(LocaleUtils.toLocale((String)args[++i]));
                    continue;
                }
                this.err("Unknown command-line argument: " + arg);
                continue;
            }
            StringReader sr = new StringReader("run " + arg + m_newline);
            this.pushStream(new LineNumberReader(sr));
        }
    }

    protected String readLine() throws IOException {
        String line = null;
        line = this.haveStreams() ? this.m_in.readLine() : this.keyboardReadLine();
        this.setCurrentLine(line);
        return line;
    }

    synchronized String keyboardReadLine() {
        this.m_keyboardReadRequest = true;
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.m_keyboardInput.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.m_keyboardStream != null) {
            try {
                if (this.m_keyboardReadRequest) {
                    String s = this.m_keyboardStream.readLine();
                    this.m_keyboardInput.add(s);
                    this.m_keyboardReadRequest = false;
                    DebugCLI debugCLI = this;
                    synchronized (debugCLI) {
                        this.notifyAll();
                        continue;
                    }
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setCurrentLine(String s) {
        this.m_currentLine = s;
        if (this.m_currentLine == null) {
            this.m_currentTokenizer = null;
        } else {
            this.m_currentLine = this.m_currentLine.trim();
            if (this.m_repeatLine != null && !this.haveStreams() && this.m_currentLine.length() == 0) {
                this.m_currentLine = this.m_repeatLine;
            }
            this.m_currentTokenizer = new StringTokenizer(this.m_currentLine, " \n\r\t");
        }
    }

    public boolean hasMoreTokens() {
        return this.m_currentTokenizer.hasMoreTokens();
    }

    public String nextToken() {
        this.m_currentToken = this.m_currentTokenizer.nextToken();
        return this.m_currentToken;
    }

    public int nextIntToken() throws NumberFormatException {
        this.nextToken();
        return Integer.parseInt(this.m_currentToken);
    }

    public long nextLongToken() throws NumberFormatException {
        this.nextToken();
        return Long.parseLong(this.m_currentToken);
    }

    public String restOfLine() {
        return this.m_currentTokenizer.nextToken("").trim();
    }

    public void execute() {
        this.displayStartMessage();
        Thread t = new Thread((Runnable)this, "Keyboard input");
        t.start();
        while (this.haveStreams()) {
            try {
                this.m_in = this.popStream();
                this.process();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException io) {
                HashMap<String, IOException> args = new HashMap<String, IOException>();
                args.put("exceptionMessage", io);
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("errorWhileProcessingFile", args));
            }
        }
        this.exitSession();
        this.m_keyboardStream = null;
    }

    public PrintStream getOut() {
        return this.m_out;
    }

    private void displayStartMessage() {
        String build = DebugCLI.getLocalizationManager().getLocalizedTextString("defaultBuildName");
        try {
            Properties p = new Properties();
            p.load(this.getClass().getResourceAsStream("version.properties"));
            String buildString = p.getProperty("build");
            if (buildString != null && !buildString.equals("")) {
                build = buildString;
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        HashMap<String, String> aboutMap = new HashMap<String, String>();
        aboutMap.put("build", build);
        this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("about", aboutMap));
        this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("copyright"));
    }

    void displayPrompt() {
        this.m_out.print("(fdb) ");
    }

    void displayCommandPrompt() {
        this.m_out.print(">");
    }

    void repeat(StringBuilder sb, char c, int n) {
        while (n-- > 0) {
            sb.append(c);
        }
    }

    boolean yesNoQuery(String prompt) throws IOException {
        boolean result = false;
        this.m_out.print(prompt);
        this.m_out.print(DebugCLI.getLocalizationManager().getLocalizedTextString("yesOrNoAppendedToAllQuestions"));
        String in = this.readLine();
        if (in != null && in.equals(DebugCLI.getLocalizationManager().getLocalizedTextString("singleCharacterUserTypesForYes"))) {
            result = true;
        } else {
            if (in != null && in.equals("escape")) {
                throw new IllegalArgumentException("escape");
            }
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("yesNoQueryNotConfirmed"));
        }
        return result;
    }

    public void err(String s) {
        this.out(s);
    }

    public void out(String s) {
        if (s.length() > 0 && s.charAt(s.length() - 1) == '\n') {
            this.m_out.print(s);
        } else {
            this.m_out.println(s);
        }
    }

    static String uft() {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        long used = total - free;
        NumberFormat nf = NumberFormat.getInstance();
        return "Used " + nf.format(used) + " - free " + nf.format(free) + " - total " + nf.format(total);
    }

    void initProperties() {
        this.propertyPut(LIST_SIZE, 10);
        this.propertyPut(LIST_LINE, 1);
        this.propertyPut(LIST_MODULE, 1);
        this.propertyPut(LIST_WORKER, 1);
        this.propertyPut(COLUMN_WIDTH, 70);
        this.propertyPut(UPDATE_DELAY, 25);
        this.propertyPut(HALT_TIMEOUT, 7000);
        this.propertyPut(BPNUM, 0);
        this.propertyPut(LAST_FRAME_DEPTH, 0);
        this.propertyPut(CURRENT_FRAME_DEPTH, 0);
        this.propertyPut(DISPLAY_FRAME_NUMBER, 0);
        this.propertyPut(FILE_LIST_WRAP, 999999);
        this.propertyPut(NO_WAITING, 0);
        this.propertyPut(INFO_STACK_SHOW_THIS, 1);
    }

    public void propertyPut(String k, int v) {
        this.m_exprCache.put(k, v);
    }

    public int propertyGet(String k) {
        return (Integer)this.m_exprCache.get(k);
    }

    public Set<String> propertyKeys() {
        return this.m_exprCache.keySet();
    }

    void process() throws IOException {
        boolean done = false;
        while (!done) {
            try {
                this.runningLoop();
                if (!this.haveStreams()) {
                    this.displayPrompt();
                }
                this.readLine();
                if (this.m_currentLine == null) break;
                done = this.processLine();
            }
            catch (NoResponseException nre) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noResponseException"));
            }
            catch (NotSuspendedException nse) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("notSuspendedException"));
            }
            catch (AmbiguousException nse) {
            }
            catch (IllegalStateException ise) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("illegalStateException"));
            }
            catch (IllegalMonitorStateException ime) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("illegalMonitorStateException"));
            }
            catch (NoSuchElementException nse) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSuchElementException"));
            }
            catch (NumberFormatException nfe) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("numberFormatException"));
            }
            catch (SocketException se) {
                HashMap<String, String> socketArgs = new HashMap<String, String>();
                socketArgs.put("message", se.getMessage());
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("socketException", socketArgs));
            }
            catch (VersionException ve) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("versionException"));
            }
            catch (NotConnectedException ve) {
            }
            catch (Exception e) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("unexpectedError"));
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("stackTraceFollows"));
                e.printStackTrace();
            }
            if (!this.isConnectionLost()) continue;
            try {
                this.dumpHaltState(false);
            }
            catch (PlayerDebugException pde) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("sessionEndedAbruptly"));
            }
        }
    }

    boolean isConnectionLost() {
        boolean lost = false;
        if (this.m_session != null && !this.m_session.isConnected()) {
            lost = true;
        }
        return lost;
    }

    boolean haveConnection() {
        boolean have = false;
        if (this.m_session != null && this.m_session.isConnected()) {
            have = true;
        }
        return have;
    }

    void doShow() throws AmbiguousException, PlayerDebugException {
        if (!this.hasMoreTokens()) {
            this.out(this.getHelpTopic("show"));
        } else {
            String subCmdString = this.nextToken();
            int subCmd = this.showCommandFor(subCmdString);
            switch (subCmd) {
                case 201: {
                    this.doShowStats();
                    break;
                }
                case 202: {
                    this.doShowFuncs();
                    break;
                }
                case 203: {
                    this.doShowUri();
                    break;
                }
                case 204: {
                    this.doShowProperties();
                    break;
                }
                case 205: {
                    this.doShowFiles();
                    break;
                }
                case 206: {
                    this.doShowBreak();
                    break;
                }
                case 207: {
                    this.doShowVariable();
                    break;
                }
                case 208: {
                    this.doShowMemory();
                    break;
                }
                case 209: {
                    this.doShowLocations();
                    break;
                }
                case 210: {
                    this.doShowDirectories();
                    break;
                }
                default: {
                    this.doUnknown("show", subCmdString);
                }
            }
        }
    }

    void doShowUri() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("URI = ");
            sb.append(this.m_session.getURI());
            this.out(sb.toString());
        }
        catch (Exception e) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noUriReceived"));
        }
    }

    void doShowFiles() {
        try {
            StringBuilder sb = new StringBuilder();
            for (Isolate isolate : this.m_session.getWorkers()) {
                Iterator<?> itr = this.m_fileInfo.getAllFiles(isolate.getId());
                while (itr.hasNext()) {
                    SourceFile m = (SourceFile)((Map.Entry)itr.next()).getValue();
                    String name = m.getName();
                    int id = m.getId();
                    String path = m.getFullPath();
                    sb.append(id);
                    sb.append(' ');
                    sb.append(path);
                    sb.append(", ");
                    sb.append(name);
                    sb.append(" (");
                    if (isolate.getId() == 1) {
                        sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("mainThread"));
                    } else {
                        HashMap<String, Integer> wArgs = new HashMap<String, Integer>();
                        wArgs.put("worker", isolate.getId() - 1);
                        sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inWorker", wArgs));
                    }
                    sb.append(")");
                    sb.append(m_newline);
                }
            }
            this.out(sb.toString());
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSourceFilesFound"));
        }
    }

    void doShowMemory() {
        this.out(DebugCLI.uft());
    }

    void doShowLocations() {
        StringBuilder sb = new StringBuilder();
        sb.append("Num Type           Disp Enb Address    What" + m_newline);
        int count = this.breakpointCount();
        for (int i = 0; i < count; ++i) {
            BreakAction b = this.breakpointAt(i);
            int num = b.getId();
            FieldFormat.formatLong((StringBuilder)sb, (long)num, (int)3);
            sb.append(" breakpoint     ");
            if (b.isAutoDisable()) {
                sb.append("dis  ");
            } else if (b.isAutoDelete()) {
                sb.append("del  ");
            } else {
                sb.append("keep ");
            }
            if (b.isEnabled()) {
                sb.append("y   ");
            } else {
                sb.append("n   ");
            }
            Iterator<Location> itr = b.getLocations().iterator();
            while (itr.hasNext()) {
                Location l = itr.next();
                SourceFile file = l.getFile();
                String funcName = file == null ? DebugCLI.getLocalizationManager().getLocalizedTextString("unknownBreakpointLocation") : file.getFunctionNameForLine(this.m_session, l.getLine());
                int offset = this.adjustOffsetForUnitTests(file == null ? 0 : file.getOffsetForLine(l.getLine()));
                sb.append("0x");
                FieldFormat.formatLongToHex((StringBuilder)sb, (long)offset, (int)8);
                sb.append(' ');
                if (funcName != null) {
                    HashMap<String, String> funcArgs = new HashMap<String, String>();
                    funcArgs.put("functionName", funcName);
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inFunctionAt", funcArgs));
                }
                sb.append(file.getName());
                sb.append("#");
                sb.append(file.getId());
                sb.append(':');
                sb.append(l.getLine());
                try {
                    SwfInfo info = this.m_fileInfo.swfForFile(file, l.getIsolateId());
                    HashMap<String, Object> swfArgs = new HashMap<String, Object>();
                    swfArgs.put("swf", FileInfoCache.shortNameOfSwf(info));
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inSwf", swfArgs));
                    if (l.getIsolateId() == 1) {
                        sb.append(" (");
                        sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("mainThread"));
                        sb.append(")");
                    } else {
                        swfArgs = new HashMap();
                        swfArgs.put("worker", l.getIsolateId() - 1);
                        sb.append(" (");
                        sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inWorker", swfArgs));
                        sb.append(")");
                    }
                }
                catch (NullPointerException npe) {
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("nonRestorable"));
                }
                sb.append(m_newline);
                if (!itr.hasNext()) continue;
                sb.append("                            ");
            }
        }
        this.out(sb.toString());
    }

    private int adjustOffsetForUnitTests(int offset) {
        if (System.getProperty("fdbunit") == null) {
            return offset;
        }
        return 0;
    }

    void doShowDirectories() {
        this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("sourceDirectoriesSearched"));
        for (String dir : this.m_sourceDirectories) {
            this.out("  " + dir);
        }
    }

    void doHalt() throws SuspendedException, NotConnectedException, NoResponseException {
        this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("attemptingToSuspend"));
        IsolateSession session = this.m_session.getWorkerSession(this.getActiveIsolateId());
        if (!session.isSuspended()) {
            session.suspend();
        }
        if (session.isSuspended()) {
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("playerStopped"));
        } else {
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("playerRunning"));
        }
    }

    public void appendReason(StringBuilder sb, int reason) {
        switch (reason) {
            case 0: {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_Unknown"));
                break;
            }
            case 1: {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_HitBreakpoint"));
                break;
            }
            case 2: {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_HitWatchpoint"));
                break;
            }
            case 3: {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_ProgramThrewException"));
                break;
            }
            case 4: {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_StopRequest"));
                break;
            }
            case 5: {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_ProgramFinishedStepping"));
                break;
            }
            case 6: {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_HaltOpcode"));
                break;
            }
            case 7: {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_ScriptHasLoadedIntoFlashPlayer"));
            }
        }
    }

    void doInfo() throws AmbiguousException, PlayerDebugException {
        if (!this.hasMoreTokens()) {
            this.out(this.getHelpTopic("info"));
        } else {
            String subCmdString = this.nextToken();
            int subCmd = this.infoCommandFor(subCmdString);
            switch (subCmd) {
                case 101: {
                    this.doInfoArgs();
                    break;
                }
                case 102: {
                    this.doInfoBreak();
                    break;
                }
                case 103: {
                    this.doInfoFiles();
                    break;
                }
                case 105: {
                    this.doInfoFuncs();
                    break;
                }
                case 104: {
                    this.doInfoHandle();
                    break;
                }
                case 106: {
                    this.doInfoLocals();
                    break;
                }
                case 107: {
                    this.doInfoScopeChain();
                    break;
                }
                case 108: {
                    this.doInfoSources();
                    break;
                }
                case 109: {
                    this.doInfoStack();
                    break;
                }
                case 110: {
                    this.doInfoVariables();
                    break;
                }
                case 111: {
                    this.doInfoDisplay();
                    break;
                }
                case 112: {
                    this.doInfoTargets();
                    break;
                }
                case 113: {
                    this.doInfoSwfs();
                    break;
                }
                case 114: {
                    this.doInfoWorkers();
                    break;
                }
                default: {
                    this.doUnknown("info", subCmdString);
                }
            }
        }
    }

    void doInfoWorkers() throws NotConnectedException, NotSupportedException, NotSuspendedException, NoResponseException {
        Isolate[] isolates = this.m_session.getWorkers();
        if (isolates == null || isolates.length == 0) {
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("noWorkersRunning"));
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Isolate t : isolates) {
            Object status = DebugCLI.getLocalizationManager().getLocalizedTextString("workerRunning");
            if (this.m_session.getWorkerSession(t.getId()).isSuspended()) {
                status = DebugCLI.getLocalizationManager().getLocalizedTextString("workerSuspended");
            }
            if (this.m_activeIsolate == t.getId()) {
                status = (String)status + " " + DebugCLI.getLocalizationManager().getLocalizedTextString("workerSelected");
            }
            if (t.getId() == 1) {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("mainThread"));
                sb.append(" ");
                sb.append(0);
            } else {
                HashMap<String, Integer> workArgs = new HashMap<String, Integer>();
                workArgs.put("worker", t.getId() - 1);
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inWorker", workArgs));
            }
            sb.append(" - " + (String)status + m_newline);
        }
        this.out(sb.toString());
    }

    void doInfoStack() throws PlayerDebugException {
        this.waitTilHalted(this.m_activeIsolate);
        StringBuilder sb = new StringBuilder();
        Frame[] stack = this.m_session.getWorkerSession(this.m_activeIsolate).getFrames();
        if (stack == null || stack.length == 0) {
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("noStackAvailable"));
        } else {
            boolean showThis = this.propertyGet(INFO_STACK_SHOW_THIS) == 1;
            for (int i = 0; i < stack.length; ++i) {
                Frame frame = stack[i];
                boolean valid = this.appendFrameInfo(sb, frame, i, showThis, true);
                sb.append(m_newline);
                if (!valid) break;
            }
        }
        this.out(sb.toString());
    }

    boolean appendFrameInfo(StringBuilder sb, Frame ctx, int frameNumber, boolean showThis, boolean showFileId) throws PlayerDebugException {
        boolean validFrame = true;
        int i = frameNumber;
        Location loc = ctx.getLocation();
        SourceFile file = loc.getFile();
        int line = loc.getLine();
        String name = file == null ? "<null>" : file.getName();
        String sig = ctx.getCallSignature();
        String func = DebugCLI.extractFunctionName(sig);
        if (file == null && line < 0) {
            validFrame = false;
        } else {
            Variable[] var = ctx.getArguments(this.m_session);
            Variable dis = ctx.getThis(this.m_session);
            boolean displayArgs = func != null || var != null;
            sb.append('#');
            FieldFormat.formatLong((StringBuilder)sb, (long)i, (int)3);
            sb.append(' ');
            if (showThis && dis != null) {
                this.m_exprCache.appendVariable(sb, dis, ctx.getIsolateId());
                sb.append(".");
            }
            if (func != null) {
                sb.append(func);
            }
            if (displayArgs) {
                sb.append('(');
                for (int j = 0; j < var.length; ++j) {
                    Variable v = var[j];
                    sb.append(v.getName());
                    sb.append('=');
                    this.m_exprCache.appendVariableValue(sb, v.getValue(), ctx.getIsolateId());
                    if (j + 1 >= var.length) continue;
                    sb.append(", ");
                }
                sb.append(")");
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("atFilename"));
            }
            sb.append(name);
            if (file != null && (showFileId || !this.m_fileInfo.inFileList(file))) {
                sb.append('#');
                sb.append(file.getId());
            }
            sb.append(':');
            sb.append(line);
        }
        return validFrame;
    }

    public static String extractFunctionName(String sig) {
        int at = sig.indexOf(40);
        if (at > -1) {
            sig = sig.substring(0, at);
        }
        if (sig != null && (at = sig.indexOf("::")) > -1) {
            sig = sig.substring(at + 2);
        }
        return sig;
    }

    void doInfoVariables() throws PlayerDebugException {
        this.waitTilHalted(this.m_activeIsolate);
        StringBuilder sb = new StringBuilder();
        try {
            Variable[] vars = this.m_session.getWorkerSession(this.m_activeIsolate).getVariableList();
            for (int i = 0; i < vars.length; ++i) {
                Variable v = vars[i];
                if (v.isAttributeSet(32) || v.isAttributeSet(65536)) continue;
                this.m_exprCache.appendVariable(sb, vars[i], this.m_activeIsolate);
                sb.append(m_newline);
            }
        }
        catch (NullPointerException npe) {
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("noVariables"));
        }
        this.out(sb.toString());
    }

    void doInfoDisplay() {
        StringBuilder sb = new StringBuilder();
        sb.append("Num Enb Expression" + m_newline);
        int count = this.displayCount();
        for (int i = 0; i < count; ++i) {
            DisplayAction b = this.displayAt(i);
            int num = b.getId();
            String exp = b.getContent();
            sb.append(':');
            FieldFormat.formatLong((StringBuilder)sb, (long)num, (int)3);
            if (b.isEnabled()) {
                sb.append(" y  ");
            } else {
                sb.append(" n  ");
            }
            sb.append(exp);
            sb.append(m_newline);
        }
        this.out(sb.toString());
    }

    void doInfoArgs() throws PlayerDebugException {
        this.waitTilHalted(this.m_activeIsolate);
        StringBuilder sb = new StringBuilder();
        try {
            int num = this.propertyGet(DISPLAY_FRAME_NUMBER);
            Frame[] frames = this.m_session.getWorkerSession(this.m_activeIsolate).getFrames();
            Variable[] vars = frames[num].getArguments(this.m_session);
            for (int i = 0; i < vars.length; ++i) {
                this.m_exprCache.appendVariable(sb, vars[i], this.m_activeIsolate);
                sb.append(m_newline);
            }
        }
        catch (NullPointerException npe) {
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("noArguments"));
        }
        catch (ArrayIndexOutOfBoundsException aix) {
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("notInValidFrame"));
        }
        this.out(sb.toString());
    }

    void doInfoLocals() throws PlayerDebugException {
        this.waitTilHalted(this.m_activeIsolate);
        StringBuilder sb = new StringBuilder();
        try {
            int num = this.propertyGet(DISPLAY_FRAME_NUMBER);
            Frame[] ar = this.m_session.getWorkerSession(this.m_activeIsolate).getFrames();
            Frame ctx = ar[num];
            Variable[] vars = ctx.getLocals(this.m_session);
            for (int i = 0; i < vars.length; ++i) {
                Variable v = vars[i];
                if (!v.isAttributeSet(32)) continue;
                this.m_exprCache.appendVariable(sb, v, this.m_activeIsolate);
                sb.append(m_newline);
            }
        }
        catch (NullPointerException npe) {
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("noLocals"));
        }
        catch (ArrayIndexOutOfBoundsException aix) {
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("notInValidFrame"));
        }
        this.out(sb.toString());
    }

    void doInfoScopeChain() throws PlayerDebugException {
        this.waitTilHalted(this.m_activeIsolate);
        StringBuilder sb = new StringBuilder();
        try {
            int num = this.propertyGet(DISPLAY_FRAME_NUMBER);
            Frame[] ar = this.m_session.getWorkerSession(this.m_activeIsolate).getFrames();
            Frame ctx = ar[num];
            Variable[] scopes = ctx.getScopeChain(this.m_session);
            for (int i = 0; i < scopes.length; ++i) {
                Variable scope = scopes[i];
                this.m_exprCache.appendVariable(sb, scope, this.m_activeIsolate);
                sb.append(m_newline);
            }
        }
        catch (NullPointerException npe) {
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("noScopeChain"));
        }
        catch (ArrayIndexOutOfBoundsException aix) {
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("notInValidFrame"));
        }
        this.out(sb.toString());
    }

    void doInfoTargets() {
        if (!this.haveConnection()) {
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("noActiveSession"));
            if (this.m_launchURI != null) {
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("uri", this.m_launchURI);
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("runWillLaunchUri", args));
            }
        } else {
            String uri = this.m_session.getURI();
            if (uri == null || uri.length() < 1) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("targetUnknown"));
            } else {
                this.out(uri);
            }
        }
    }

    void doInfoSwfs() {
        try {
            StringBuilder sb = new StringBuilder();
            SwfInfo[] swfs = this.m_fileInfo.getSwfs(this.m_activeIsolate);
            for (int i = 0; i < swfs.length; ++i) {
                SwfInfo e = swfs[i];
                if (e == null || e.isUnloaded()) continue;
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("swfName", FileInfoCache.nameOfSwf(e));
                args.put("size", NumberFormat.getInstance().format(e.getSwfSize()));
                try {
                    int size = e.getSwdSize(this.m_session);
                    SourceFile[] files = e.getSourceList(this.m_session);
                    int max = Integer.MIN_VALUE;
                    int min = Integer.MAX_VALUE;
                    for (int j = 0; j < files.length; ++j) {
                        SourceFile f = files[j];
                        int id = f.getId();
                        max = id > max ? id : max;
                        min = id < min ? id : min;
                    }
                    args.put("scriptCount", Integer.toString(e.getSourceCount(this.m_session)));
                    args.put("min", Integer.toString(min));
                    args.put("max", Integer.toString(max));
                    args.put("plus", e.isProcessingComplete() ? "+" : "");
                    args.put("moreInfo", size == 0 ? DebugCLI.getLocalizationManager().getLocalizedTextString("remainingSourceBeingLoaded") : "");
                }
                catch (InProgressException ipe) {
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("debugInfoBeingLoaded"));
                }
                args.put("url", e.getUrl());
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("swfInfo", args));
                sb.append(m_newline);
            }
            this.out(sb.toString());
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSWFs"));
        }
    }

    private int getFileType(SourceFile sourceFile) {
        String name = sourceFile.getName();
        String pkg = sourceFile.getPackageName();
        if (name.startsWith("<") && name.endsWith(">") || name.equals("GeneratedLocale")) {
            return 3;
        }
        for (String frameworkPkg : FRAMEWORK_FILE_PACKAGES) {
            if (!pkg.startsWith(frameworkPkg + "\\") && !pkg.startsWith(frameworkPkg + "/") && !pkg.equals(frameworkPkg)) continue;
            return 2;
        }
        if (name.startsWith("Actions for")) {
            return 4;
        }
        return 1;
    }

    void buildFileList(StringBuilder sb, boolean authoredFilesOnly) {
        SourceFile[] ar = this.m_fileInfo.getFileList(this.m_activeIsolate);
        if (ar == null) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSourceFilesFound"));
            return;
        }
        Vector<String> authoredFiles = new Vector<String>();
        Vector<String> frameworkFiles = new Vector<String>();
        Vector<String> syntheticFiles = new Vector<String>();
        Vector<String> actionsFiles = new Vector<String>();
        block6: for (int i = 0; i < ar.length; ++i) {
            SourceFile m = ar[i];
            int fileType = this.getFileType(m);
            int id = m.getId();
            String entry = m.getName() + "#" + id;
            switch (fileType) {
                case 3: {
                    syntheticFiles.add(entry);
                    continue block6;
                }
                case 2: {
                    frameworkFiles.add(entry);
                    continue block6;
                }
                case 4: {
                    actionsFiles.add(entry);
                    continue block6;
                }
                case 1: {
                    authoredFiles.add(entry);
                }
            }
        }
        int wrapAt = this.propertyGet(FILE_LIST_WRAP);
        if (!authoredFilesOnly) {
            if (actionsFiles.size() > 0) {
                this.appendStrings(sb, actionsFiles, actionsFiles.size() > wrapAt);
            }
            if (frameworkFiles.size() > 0) {
                sb.append("---" + m_newline);
                this.appendStrings(sb, frameworkFiles, frameworkFiles.size() > wrapAt);
            }
            if (syntheticFiles.size() > 0) {
                sb.append("---" + m_newline);
                this.appendStrings(sb, syntheticFiles, syntheticFiles.size() > wrapAt);
            }
            sb.append("---" + m_newline);
        }
        this.appendStrings(sb, authoredFiles, authoredFiles.size() > wrapAt);
    }

    void appendStrings(StringBuilder sb, Vector<String> v, boolean flow) {
        int count = v.size();
        int width = 0;
        int maxCol = this.propertyGet(COLUMN_WIDTH);
        for (int i = 0; i < count; ++i) {
            String s = v.get(i);
            sb.append(s);
            if (flow) {
                if ((width += s.length() + 2) >= maxCol) {
                    sb.append(m_newline);
                    width = 0;
                    continue;
                }
                sb.append(", ");
                continue;
            }
            sb.append(m_newline);
        }
        if (flow && width > 0) {
            sb.append(m_newline);
        }
    }

    void doInfoFiles() {
        try {
            StringBuilder sb = new StringBuilder();
            if (this.hasMoreTokens()) {
                String arg = this.nextToken();
                this.listFilesMatching(sb, arg);
            } else {
                this.buildFileList(sb, false);
            }
            this.out(sb.toString());
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException();
        }
    }

    void doInfoHandle() {
        if (this.hasMoreTokens()) {
            String faultName = this.nextToken();
            if (!this.m_faultTable.exists(faultName)) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("unrecognizedFault"));
            } else {
                this.listFault(faultName);
            }
        } else {
            StringBuilder sb = new StringBuilder();
            this.appendFaultTitles(sb);
            Object[] names = this.m_faultTable.names();
            Arrays.sort(names);
            for (int i = 0; i < names.length; ++i) {
                this.appendFault(sb, (String)names[i]);
            }
            this.out(sb.toString());
        }
    }

    void doInfoFuncs() {
        StringBuilder sb = new StringBuilder();
        String arg = null;
        try {
            if (this.hasMoreTokens()) {
                arg = this.nextToken();
                int id = arg.equals(".") ? this.propertyGet(LIST_MODULE) : this.parseFileArg(this.m_activeIsolate, -1, arg);
                SourceFile m = this.m_fileInfo.getFile(id, this.m_activeIsolate);
                this.listFunctionsFor(sb, m);
            } else {
                SourceFile[] ar = this.m_fileInfo.getFileList(this.m_activeIsolate);
                if (ar == null) {
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSourceFilesFound"));
                } else {
                    for (int i = 0; i < ar.length; ++i) {
                        SourceFile m = ar[i];
                        this.listFunctionsFor(sb, m);
                    }
                }
            }
            this.out(sb.toString());
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noFunctionsFound"));
        }
        catch (ParseException pe) {
            this.err(pe.getMessage());
        }
        catch (NoMatchException nme) {
            this.err(nme.getMessage());
        }
        catch (AmbiguousException ae) {
            this.err(ae.getMessage());
        }
    }

    void listFunctionsFor(StringBuilder sb, SourceFile m) {
        Object[] names = m.getFunctionNames(this.m_session);
        if (names == null) {
            return;
        }
        Arrays.sort(names);
        HashMap<String, CallSite> args = new HashMap<String, CallSite>();
        args.put("sourceFile", (CallSite)((Object)(m.getName() + "#" + m.getId())));
        sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("functionsInSourceFile", args));
        sb.append(m_newline);
        for (int j = 0; j < names.length; ++j) {
            Object fname = names[j];
            sb.append(' ');
            sb.append((String)fname);
            sb.append(' ');
            sb.append(m.getLineForFunctionName(this.m_session, (String)fname));
            sb.append(m_newline);
        }
    }

    void listFilesMatching(StringBuilder sb, String match) {
        SourceFile[] sourceFiles = this.m_fileInfo.getFiles(match);
        for (int j = 0; j < sourceFiles.length; ++j) {
            SourceFile sourceFile = sourceFiles[j];
            sb.append(sourceFile.getName());
            sb.append('#');
            sb.append(sourceFile.getId());
            sb.append(m_newline);
        }
    }

    void doInfoSources() {
        try {
            StringBuilder sb = new StringBuilder();
            this.buildFileList(sb, true);
            this.out(sb.toString());
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException();
        }
    }

    void doInfoBreak() throws NotConnectedException {
        StringBuilder sb = new StringBuilder();
        sb.append("Num Type           Disp Enb Address    What" + m_newline);
        int count = this.breakpointCount();
        for (int i = 0; i < count; ++i) {
            HashMap<String, String> args;
            BreakAction b = this.breakpointAt(i);
            int status = b.getStatus();
            boolean isResolved = status == 1;
            Location l = b.getLocation();
            LocationCollection locations = b.getLocations();
            SourceFile file = l != null ? l.getFile() : null;
            String funcName = file == null ? null : file.getFunctionNameForLine(this.m_session, l.getLine());
            boolean singleSwf = b.isSingleSwf();
            int cmdCount = b.getCommandCount();
            int hits = b.getHits();
            String cond = b.getConditionString();
            boolean silent = b.isSilent();
            int offset = this.adjustOffsetForUnitTests(file == null ? 0 : file.getOffsetForLine(l.getLine()));
            int num = b.getId();
            FieldFormat.formatLong((StringBuilder)sb, (long)num, (int)3);
            sb.append(" breakpoint     ");
            if (b.isAutoDisable()) {
                sb.append("dis  ");
            } else if (b.isAutoDelete()) {
                sb.append("del  ");
            } else {
                sb.append("keep ");
            }
            if (b.isEnabled()) {
                sb.append("y   ");
            } else {
                sb.append("n   ");
            }
            sb.append("0x");
            FieldFormat.formatLongToHex((StringBuilder)sb, (long)offset, (int)8);
            sb.append(' ');
            if (funcName != null) {
                HashMap<String, String> args2 = new HashMap<String, String>();
                args2.put("functionName", funcName);
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inFunctionAt", args2));
            }
            if (file != null) {
                sb.append(file.getName());
                if (isResolved && singleSwf) {
                    sb.append("#");
                    sb.append(file.getId());
                }
                sb.append(':');
                sb.append(l.getLine());
            } else {
                String expr = b.getBreakpointExpression();
                if (expr != null) {
                    sb.append(expr);
                }
            }
            StringBuilder workerList = new StringBuilder();
            if (locations != null) {
                Iterator<Location> iterator = locations.iterator();
                while (iterator.hasNext()) {
                    Location location = iterator.next();
                    workerList.append(location.getIsolateId() - 1);
                    if (!iterator.hasNext()) continue;
                    workerList.append(" / ");
                }
            }
            if (l != null) {
                HashMap<String, String> workerArgs = new HashMap<String, String>();
                workerArgs.put("worker", workerList.toString());
                sb.append(" (");
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inWorker", workerArgs));
                sb.append(") ");
            }
            switch (status) {
                case 2: {
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNotYetResolved"));
                    break;
                }
                case 3: {
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointAmbiguous"));
                    break;
                }
                case 4: {
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNoCode"));
                }
            }
            if (singleSwf && isResolved) {
                try {
                    SwfInfo info = this.m_fileInfo.swfForFile(file, l.getIsolateId());
                    HashMap<String, String> swfArgs = new HashMap<String, String>();
                    swfArgs.put("swf", FileInfoCache.nameOfSwf(info));
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inSwf", swfArgs));
                }
                catch (NullPointerException npe) {
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("nonRestorable"));
                }
            }
            sb.append(m_newline);
            String INDENT = "        ";
            if (cond != null && cond.length() > 0) {
                sb.append("        ");
                args = new HashMap();
                args.put("breakpointCondition", cond);
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString(DebugCLI.getLocalizationManager().getLocalizedTextString("stopOnlyIfConditionMet", args)));
                sb.append(m_newline);
            }
            if (hits > 0) {
                sb.append("        ");
                args = new HashMap<String, String>();
                args.put("count", Integer.toString(hits));
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointAlreadyHit", args));
                sb.append(m_newline);
            }
            if (silent) {
                sb.append("        ");
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("silentBreakpoint") + m_newline);
            }
            for (int j = 0; j < cmdCount; ++j) {
                sb.append("        ");
                sb.append(b.commandAt(j));
                sb.append(m_newline);
            }
        }
        int wcount = this.watchpointCount();
        for (int k = 0; k < wcount; ++k) {
            WatchAction b = this.watchpointAt(k);
            int id = b.getId();
            FieldFormat.formatLong((StringBuilder)sb, (long)id, (int)4);
            int flags = b.getKind();
            switch (flags) {
                case 1: {
                    sb.append("rd watchpoint  ");
                    break;
                }
                case 2: {
                    sb.append("wr watchpoint  ");
                    break;
                }
                default: {
                    sb.append("watchpoint     ");
                }
            }
            sb.append("keep ");
            sb.append("y   ");
            sb.append("           ");
            sb.append(b.getExpr());
            sb.append(m_newline);
        }
        int ccount = this.catchpointCount();
        for (int k = 0; k < ccount; ++k) {
            CatchAction c = this.catchpointAt(k);
            int id = c.getId();
            FieldFormat.formatLong((StringBuilder)sb, (long)id, (int)4);
            String typeToCatch = c.getTypeToCatch();
            if (typeToCatch == null) {
                typeToCatch = "*";
            }
            sb.append("catch          ");
            sb.append("keep ");
            sb.append("y   ");
            sb.append("           ");
            sb.append(typeToCatch);
            sb.append(m_newline);
        }
        this.out(sb.toString());
    }

    void dumpHaltState(boolean postStep) throws NotConnectedException, SuspendedException, NoResponseException, NotSupportedException, NotSuspendedException, IOException {
        this.processEvents();
        if (this.hasAnyPendingResumes() != -1 && !postStep) {
            return;
        }
        if (!this.m_session.isConnected()) {
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("sessionTerminated"));
            this.exitSession();
        } else {
            if (!this.m_quietMode && this.hasAnythingSuspended()) {
                StringBuilder sbLine = new StringBuilder();
                this.dumpBreakLine(postStep, sbLine);
                StringBuilder sbBreak = new StringBuilder();
                boolean silent = this.processBreak(postStep, sbBreak, this.m_activeIsolate);
                StringBuilder sb = new StringBuilder();
                if (silent) {
                    this.dumpBreakLine(postStep, sb);
                } else {
                    sb.append((CharSequence)sbLine);
                    if (sbLine.length() > 0 && sbLine.charAt(sbLine.length() - 1) != '\n') {
                        sb.append(m_newline);
                    }
                    sb.append((CharSequence)sbBreak);
                }
                if (sb.length() > 0) {
                    this.out(sb.toString());
                }
            } else if (!this.m_quietMode) {
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("playerDidNotStop"));
            }
            this.m_quietMode = false;
        }
    }

    Location getCurrentLocation() {
        return this.getCurrentLocationIsolate(1);
    }

    Location getCurrentLocationIsolate(int isolateId) {
        Location where = null;
        try {
            Frame[] ar = this.m_session.getWorkerSession(isolateId).getFrames();
            this.propertyPut(CURRENT_FRAME_DEPTH, ar.length > 0 ? ar.length : 0);
            where = ar.length > 0 ? ar[0].getLocation() : null;
        }
        catch (PlayerDebugException playerDebugException) {
            // empty catch block
        }
        return where;
    }

    void dumpBreakLine(boolean postStep, StringBuilder sb) throws NotConnectedException {
        int bp = -1;
        String name = DebugCLI.getLocalizationManager().getLocalizedTextString("unknownFilename");
        int line = -1;
        this.propertyPut(DISPLAY_FRAME_NUMBER, 0);
        int targetIsolate = this.getLastStoppedIsolate();
        boolean activeIsolateChanged = this.m_activeIsolate != targetIsolate;
        this.m_activeIsolate = targetIsolate;
        this.propertyPut(LIST_WORKER, targetIsolate);
        Location l = this.getCurrentLocationIsolate(targetIsolate);
        int reason = 0;
        try {
            reason = this.m_session.getWorkerSession(targetIsolate).suspendReason();
        }
        catch (PlayerDebugException playerDebugException) {
            // empty catch block
        }
        if (reason == 7) {
            this.m_fileInfo.setDirty();
            this.m_fileInfo.getSwfsIsolate(targetIsolate);
            this.processEvents();
            this.propagateBreakpoints(targetIsolate);
            this.propertyPut(LIST_LINE, 1);
            this.propertyPut(LIST_WORKER, targetIsolate);
            this.propertyPut(LIST_MODULE, 1);
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("additionalCodeLoaded"));
            if (activeIsolateChanged) {
                sb.append(m_newline + DebugCLI.getLocalizationManager().getLocalizedTextString("workerChanged") + " " + (targetIsolate - 1) + m_newline);
            }
            sb.append(m_newline);
            if (this.resolveBreakpoints(sb)) {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("setAdditionalBreakpoints") + m_newline);
            } else {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("fixBreakpoints") + m_newline);
            }
            this.setPromptState(InitialPromptState.SHOWN_ONCE, targetIsolate);
        } else if (l == null || l.getFile() == null) {
            if (activeIsolateChanged) {
                sb.append(m_newline + DebugCLI.getLocalizationManager().getLocalizedTextString("workerChanged") + " " + (targetIsolate - 1) + m_newline);
            }
            this.propertyPut(LAST_FRAME_DEPTH, 0);
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("executionHalted"));
            sb.append(' ');
            this.appendBreakInfo(sb, this.m_activeIsolate);
        } else {
            if (activeIsolateChanged) {
                sb.append(m_newline + DebugCLI.getLocalizationManager().getLocalizedTextString("workerChanged") + " " + (targetIsolate - 1) + m_newline);
            }
            SourceFile file = l.getFile();
            name = file.getName();
            line = l.getLine();
            String funcName = file.getFunctionNameForLine(this.m_session, line);
            int lastModule = this.propertyGet(LIST_MODULE);
            int lastDepth = this.propertyGet(LAST_FRAME_DEPTH);
            int thisModule = file.getId();
            int thisDepth = this.propertyGet(CURRENT_FRAME_DEPTH);
            this.propertyPut(LAST_FRAME_DEPTH, thisDepth);
            if (!postStep || lastModule != thisModule || lastDepth != thisDepth) {
                String formatString;
                HashMap<String, Object> args;
                String reasonForHalting;
                if (reason == 3 || reason == 4) {
                    StringBuilder s = new StringBuilder();
                    this.appendReason(s, reason);
                    reasonForHalting = s.toString();
                } else {
                    bp = this.enabledBreakpointIndexOf(l);
                    if (bp > -1) {
                        args = new HashMap<String, Object>();
                        args.put("breakpointNumber", Integer.toString(this.breakpointAt(bp).getId()));
                        reasonForHalting = DebugCLI.getLocalizationManager().getLocalizedTextString("hitBreakpoint", args);
                    } else {
                        reasonForHalting = DebugCLI.getLocalizationManager().getLocalizedTextString("executionHalted");
                    }
                }
                args = new HashMap();
                args.put("reasonForHalting", reasonForHalting);
                args.put("fileAndLine", name + ":" + line);
                if (funcName != null) {
                    args.put("functionName", funcName);
                    formatString = "haltedInFunction";
                } else {
                    formatString = "haltedInFile";
                }
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString(formatString, args));
                if (!this.m_fullnameOption) {
                    sb.append(m_newline);
                }
            }
            this.setListingPosition(thisModule, line, targetIsolate);
            if (!this.m_fullnameOption) {
                this.appendSource(sb, file.getId(), line, file.getLine(line), false);
            }
        }
    }

    private int getLastStoppedIsolate() {
        int targetIsolate = 1;
        if (this.m_breakIsolates.size() > 0) {
            targetIsolate = this.m_breakIsolates.get(this.m_breakIsolates.size() - 1);
        }
        return targetIsolate;
    }

    void appendFullnamePosition(StringBuilder sb, SourceFile file, int lineNbr) {
        String name = file.getFullPath();
        if (name.startsWith("file:/")) {
            name = name.substring(6);
        }
        sb.append('\u001a');
        sb.append('\u001a');
        sb.append(name);
        sb.append(':');
        sb.append(lineNbr);
        sb.append(':');
        sb.append('0');
        sb.append(':');
        sb.append("beg");
        sb.append(':');
        sb.append('0');
    }

    void dumpTraceLine(String s) {
        StringBuilder sb = new StringBuilder();
        sb.append("[trace] ");
        sb.append(s);
        this.out(sb.toString());
    }

    void dumpFaultLine(FaultEvent e) {
        StringBuilder sb = new StringBuilder();
        if (e instanceof ConsoleErrorFault) {
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("linePrefixWhenDisplayingConsoleError"));
            sb.append(' ');
            sb.append(e.information);
            String stackTrace = e.stackTrace();
            if (stackTrace != null && stackTrace.length() > 0) {
                sb.append("\n").append(stackTrace);
            }
        } else {
            String stackTrace;
            String name = e.name();
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("linePrefixWhenDisplayingFault"));
            sb.append(' ');
            sb.append(name);
            if (e.information != null && e.information.length() > 0) {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("informationAboutFault"));
                sb.append(e.information);
            }
            if ((stackTrace = e.stackTrace()) != null && stackTrace.length() > 0) {
                sb.append("\n").append(stackTrace);
            }
        }
        this.out(sb.toString());
    }

    void handleSwfLoadedEvent(SwfLoadedEvent e) {
        this.dumpSwfLoadedLine(e);
    }

    void dumpSwfLoadedLine(SwfLoadedEvent e) {
        int at = e.path.lastIndexOf(63);
        String name = at > -1 ? e.path.substring(0, at) : e.path;
        StringBuilder sb = new StringBuilder();
        sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("linePrefixWhenSwfLoaded"));
        sb.append(' ');
        sb.append(name);
        sb.append(" - ");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("size", NumberFormat.getInstance().format(e.swfSize));
        sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("sizeAfterDecompression", args));
        this.out(sb.toString());
    }

    void propagateBreakpoints(int isolateId) throws NotConnectedException {
        SwfInfo[] swfs = this.m_fileInfo.getSwfsIsolate(isolateId);
        SwfInfo swf = swfs.length > 0 ? swfs[swfs.length - 1] : null;
        int size = this.m_breakpoints.size();
        for (int i = 0; swf != null && i < size; ++i) {
            BreakAction bp = this.breakpointAt(i);
            if (bp.isSingleSwf() || bp.getStatus() != 1 || !bp.isPropagable()) continue;
            try {
                Location l = bp.getLocation();
                int line = l.getLine();
                SourceFile f = l.getFile();
                Location newLoc = this.findAndEnableBreak(swf, f, line);
                if (newLoc == null) {
                    throw new RuntimeException("newLock == null");
                }
                bp.addLocation(newLoc);
                this.dumpAddedBreakpoint(bp);
                continue;
            }
            catch (InProgressException ipe) {
                if (this.breakpointCount() <= 0) continue;
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("breakpointNumber", Integer.toString(bp.getId()));
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNotPropagated", args));
            }
        }
    }

    private void dumpAddedBreakpoint(BreakAction bp) {
        String formatString;
        Location l = bp.getLocations().last();
        int which = bp.getId();
        String name = l.getFile().getName();
        int offset = this.adjustOffsetForUnitTests(l.getFile().getOffsetForLine(l.getLine()));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("breakpointNumber", Integer.toString(which));
        args.put("file", name);
        args.put("line", Integer.toString(l.getLine()));
        if (offset != 0) {
            args.put("offset", "0x" + Integer.toHexString(offset));
            formatString = "createdBreakpointWithOffset";
        } else {
            formatString = "createdBreakpoint";
        }
        this.out(DebugCLI.getLocalizationManager().getLocalizedTextString(formatString, args));
    }

    void handleSwfUnloadedEvent(SwfUnloadedEvent e) {
        this.dumpSwfUnloadedLine(e);
    }

    void dumpSwfUnloadedLine(SwfUnloadedEvent e) {
        int at = e.path.lastIndexOf(63);
        String name = at > -1 ? e.path.substring(0, at) : e.path;
        StringBuilder sb = new StringBuilder();
        sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("linePrefixWhenSwfUnloaded"));
        sb.append(' ');
        sb.append(name);
        this.out(sb.toString());
    }

    void doContinue() throws NotConnectedException {
        int stoppedIsolate = this.m_activeIsolate;
        this.waitTilHalted(stoppedIsolate);
        this.setRequestResume(true, stoppedIsolate);
        this.m_repeatLine = this.m_currentLine;
    }

    boolean hasAnythingSuspended() throws NotConnectedException {
        boolean hasAnythingSuspended = false;
        for (Integer id : this.m_breakIsolates) {
            if (!this.m_session.getWorkerSession(id).isSuspended()) continue;
            hasAnythingSuspended = true;
            break;
        }
        return hasAnythingSuspended;
    }

    int hasAnyPendingResumes() throws NotConnectedException {
        int rid = -1;
        if (this.m_mainState.m_requestResume) {
            return 1;
        }
        for (Integer id : this.m_breakIsolates) {
            if (!this.getIsolateState((int)id.intValue()).m_requestResume) continue;
            rid = id;
            break;
        }
        return rid;
    }

    int hasPendingInitialPrompts() throws NotConnectedException {
        int rid = -1;
        for (Integer id : this.m_breakIsolates) {
            if (this.getPromptState(id) == InitialPromptState.DONE) continue;
            rid = id;
            break;
        }
        return rid;
    }

    public void runningLoop() throws NoResponseException, NotConnectedException, SuspendedException, NotSupportedException, NotSuspendedException, IOException {
        int update = this.propertyGet(UPDATE_DELAY);
        boolean nowait = this.propertyGet(NO_WAITING) == 1;
        boolean stop = false;
        boolean noConnection = !this.haveConnection();
        boolean hasAnythingSuspended = false;
        int targetIsolate = 1;
        if (!noConnection) {
            hasAnythingSuspended = this.hasAnythingSuspended();
        }
        if (hasAnythingSuspended && this.m_breakIsolates.size() > 0) {
            targetIsolate = this.m_breakIsolates.get(this.m_breakIsolates.size() - 1);
        }
        if (noConnection || hasAnythingSuspended && this.hasAnyPendingResumes() == -1) {
            this.processEvents();
            stop = true;
            if (!noConnection) {
                int pendingPromptIsolate = -1;
                pendingPromptIsolate = this.m_lastPromptIsolate != -1 && this.getPromptState(this.m_lastPromptIsolate) != InitialPromptState.DONE ? this.m_lastPromptIsolate : this.hasPendingInitialPrompts();
                if (pendingPromptIsolate != -1 && pendingPromptIsolate == this.m_activeIsolate) {
                    this.dumpInitialPrompt(pendingPromptIsolate);
                }
            }
        }
        while (!stop) {
            IsolateSession workerSession;
            int pendingResumeId;
            if (!nowait) {
                this.m_keyboardReadRequest = true;
            }
            if ((pendingResumeId = this.hasAnyPendingResumes()) != -1) {
                try {
                    workerSession = this.m_session.getWorkerSession(pendingResumeId);
                    if (this.getStepResume(pendingResumeId)) {
                        workerSession.stepContinue();
                    } else {
                        workerSession.resume();
                    }
                    this.setPromptState(InitialPromptState.DONE, pendingResumeId);
                    this.removeBreakIsolate(pendingResumeId);
                }
                catch (NotSuspendedException nse) {
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("playerAlreadyRunning"));
                }
                this.setRequestResume(false, pendingResumeId);
                this.setRequestHalt(false, pendingResumeId);
                this.setStepResume(false, pendingResumeId);
            }
            try {
                Thread.sleep(update);
            }
            catch (InterruptedException nse) {
                // empty catch block
            }
            this.processEvents();
            if (!this.haveConnection()) {
                stop = true;
                this.dumpHaltState(false);
                continue;
            }
            if (this.hasAnythingSuspended()) {
                targetIsolate = this.m_breakIsolates.size() > 0 ? this.m_breakIsolates.get(this.m_breakIsolates.size() - 1) : 1;
                int tries = 3;
                IsolateSession workerSession2 = this.m_session.getWorkerSession(targetIsolate);
                while (tries-- > 0 && workerSession2.suspendReason() == 0) {
                    try {
                        Thread.sleep(100L);
                        this.processEvents();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.dumpHaltState(false);
                if (this.getRequestResume(targetIsolate)) continue;
                stop = true;
                continue;
            }
            if (nowait) {
                stop = true;
                continue;
            }
            if (this.m_keyboardInput.isEmpty() || System.getProperty("fdbunit") != null) continue;
            this.m_keyboardInput.clear();
            try {
                if (!this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("doYouWantToHalt"))) continue;
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("attemptingToHalt"));
                workerSession = this.m_session.getWorkerSession(this.m_activeIsolate);
                workerSession.suspend();
                this.getIsolateState((int)this.m_activeIsolate).m_requestHalt = true;
                if (!this.haveConnection()) {
                    this.dumpHaltState(false);
                    stop = true;
                    continue;
                }
                if (workerSession.isSuspended()) continue;
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotHalt"));
            }
            catch (IllegalArgumentException iae) {
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("escapingFromDebuggerPendingLoop"));
                this.propertyPut(NO_WAITING, 1);
                stop = true;
            }
            catch (IOException io) {
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("error", io.getMessage());
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("continuingDueToError", args));
            }
            catch (SuspendedException suspendedException) {}
        }
        if (nowait) {
            this.processEvents();
        }
    }

    private void dumpInitialPrompt(int targetIsolate) throws NotConnectedException {
        boolean activeIsolateChanged = this.m_activeIsolate != targetIsolate;
        this.m_activeIsolate = targetIsolate;
        if (activeIsolateChanged) {
            this.propertyPut(LIST_WORKER, targetIsolate);
            this.propertyPut(LIST_LINE, 1);
            this.propertyPut(LIST_MODULE, 1);
            this.propagateBreakpoints(targetIsolate);
        }
        StringBuilder sb = new StringBuilder();
        if (this.getPromptState(targetIsolate) == InitialPromptState.NEVER_SHOWN) {
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("additionalCodeLoaded"));
            sb.append(m_newline + DebugCLI.getLocalizationManager().getLocalizedTextString("workerChanged") + " " + (targetIsolate - 1) + m_newline);
            sb.append(m_newline);
            this.setPromptState(InitialPromptState.SHOWN_ONCE, targetIsolate);
        }
        if (this.resolveBreakpoints(sb)) {
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("setAdditionalBreakpoints") + m_newline);
        } else {
            sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("fixBreakpoints") + m_newline);
        }
        if (sb.length() > 0) {
            this.out(sb.toString());
        }
    }

    private void removeBreakIsolate(int targetIsolate) {
        for (int i = 0; i < this.m_breakIsolates.size(); ++i) {
            int id = this.m_breakIsolates.get(i);
            if (id != targetIsolate) continue;
            this.m_breakIsolates.remove(i);
            break;
        }
    }

    void doHome() {
        try {
            Location l = this.getCurrentLocationIsolate(this.m_activeIsolate);
            SourceFile file = l.getFile();
            int module = file.getId();
            int line = l.getLine();
            int worker = l.getIsolateId();
            this.setListingPosition(module, line, worker);
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("currentLocationUnknown"));
        }
    }

    void dumpStep() throws NotConnectedException, SuspendedException, IOException, NotSupportedException, NotSuspendedException, NoResponseException {
        this.dumpHaltState(true);
    }

    private void stepWithTimeout(AnyKindOfStep step, int isolateId) throws PlayerDebugException {
        int timeout = this.m_session.getPreference("$responsetimeout");
        long timeoutTime = System.currentTimeMillis() + (long)timeout;
        step.step();
        IsolateSession workerSession = this.m_session.getWorkerSession(isolateId);
        while (System.currentTimeMillis() < timeoutTime && !workerSession.isSuspended()) {
            this.processEvents();
            if (this.m_session.isSuspended()) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (System.currentTimeMillis() >= timeoutTime && !workerSession.isSuspended()) {
            throw new NoResponseException(timeout);
        }
    }

    private boolean allowedToStep(int isolateId) throws NotConnectedException {
        int suspendReason = this.m_session.getWorkerSession(isolateId).suspendReason();
        if (suspendReason == 7) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("cannotStep"));
            return false;
        }
        return true;
    }

    void doStep() throws PlayerDebugException, IOException {
        this.waitTilHalted(this.m_activeIsolate);
        if (!this.allowedToStep(this.m_activeIsolate)) {
            return;
        }
        int count = 1;
        if (this.hasMoreTokens()) {
            count = this.nextIntToken();
        }
        DebugCLIIsolateState state = this.getIsolateState(this.m_activeIsolate);
        block0: while (count-- > 0) {
            this.stepWithTimeout(new AnyKindOfStep(){

                @Override
                public void step() throws PlayerDebugException {
                    DebugCLI.this.m_session.getWorkerSession(DebugCLI.this.m_activeIsolate).stepInto();
                }
            }, this.m_activeIsolate);
            while (true) {
                this.dumpStep();
                if (!state.m_requestResume) continue block0;
                state.m_requestResume = false;
                this.stepWithTimeout(new AnyKindOfStep(){

                    @Override
                    public void step() throws PlayerDebugException {
                        DebugCLI.this.m_session.getWorkerSession(DebugCLI.this.m_activeIsolate).stepContinue();
                    }
                }, this.m_activeIsolate);
            }
        }
        this.m_repeatLine = this.m_currentLine;
    }

    void doNext() throws PlayerDebugException, IOException {
        block6: {
            this.waitTilHalted(this.m_activeIsolate);
            if (!this.allowedToStep(this.m_activeIsolate)) {
                return;
            }
            int count = 1;
            if (this.hasMoreTokens()) {
                count = this.nextIntToken();
            }
            DebugCLIIsolateState state = this.getIsolateState(this.m_activeIsolate);
            try {
                block2: while (count-- > 0) {
                    this.stepWithTimeout(new AnyKindOfStep(){

                        @Override
                        public void step() throws PlayerDebugException {
                            DebugCLI.this.m_session.getWorkerSession(DebugCLI.this.m_activeIsolate).stepOver();
                        }
                    }, this.m_activeIsolate);
                    while (true) {
                        this.dumpStep();
                        if (!state.m_requestResume) continue block2;
                        state.m_requestResume = false;
                        this.stepWithTimeout(new AnyKindOfStep(){

                            @Override
                            public void step() throws PlayerDebugException {
                                DebugCLI.this.m_session.getWorkerSession(DebugCLI.this.m_activeIsolate).stepContinue();
                            }
                        }, this.m_activeIsolate);
                    }
                }
            }
            catch (NoResponseException nre) {
                if (count <= 0) break block6;
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("count", Integer.toString(count));
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("abortingStep", args));
            }
        }
        this.m_repeatLine = this.m_currentLine;
    }

    void doFinish() throws PlayerDebugException, IOException {
        this.waitTilHalted(this.m_activeIsolate);
        if (!this.allowedToStep(this.m_activeIsolate)) {
            return;
        }
        DebugCLIIsolateState state = this.getIsolateState(this.m_activeIsolate);
        try {
            int depth = this.propertyGet(CURRENT_FRAME_DEPTH);
            if (depth < 2) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("finishCommandNotMeaningfulOnOutermostFrame"));
            } else {
                this.stepWithTimeout(new AnyKindOfStep(){

                    @Override
                    public void step() throws PlayerDebugException {
                        DebugCLI.this.m_session.getWorkerSession(DebugCLI.this.m_activeIsolate).stepOut();
                    }
                }, this.m_activeIsolate);
                while (true) {
                    this.dumpStep();
                    if (!state.m_requestResume) break;
                    state.m_requestResume = false;
                    this.stepWithTimeout(new AnyKindOfStep(){

                        @Override
                        public void step() throws PlayerDebugException {
                            DebugCLI.this.m_session.getWorkerSession(DebugCLI.this.m_activeIsolate).stepContinue();
                        }
                    }, this.m_activeIsolate);
                }
                this.m_repeatLine = this.m_currentLine;
            }
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("finishCommandNotMeaningfulWithoutStack"));
        }
    }

    void doDelete() throws IOException, AmbiguousException, NotConnectedException, SuspendedException, NotSupportedException, NotSuspendedException, NoResponseException {
        this.waitTilHalted(this.m_activeIsolate);
        try {
            if (!this.hasMoreTokens()) {
                if (this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("askDeleteAllBreakpoints"))) {
                    int count = this.breakpointCount();
                    for (int i = count - 1; i > -1; --i) {
                        this.removeBreakpointAt(i);
                    }
                    this.removeAllWatchpoints();
                    this.removeAllCatchpoints();
                }
            } else {
                String arg = this.nextToken();
                int cmd = this.disableCommandFor(arg);
                int id = -1;
                if (cmd == 25) {
                    this.doUnDisplay();
                } else {
                    id = cmd == 6 ? this.nextIntToken() : Integer.parseInt(arg);
                    do {
                        try {
                            int at = this.breakpointIndexOf(id);
                            if (at > -1) {
                                this.removeBreakpointAt(at);
                                continue;
                            }
                            at = this.watchpointIndexOf(id);
                            if (at > -1) {
                                this.removeWatchpointAt(at);
                                continue;
                            }
                            at = this.catchpointIndexOf(id);
                            this.removeCatchpointAt(at);
                        }
                        catch (IndexOutOfBoundsException iob) {
                            HashMap<String, String> args = new HashMap<String, String>();
                            args.put("breakpointNumber", this.m_currentToken);
                            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noBreakpointNumber", args));
                        }
                    } while ((id = this.hasMoreTokens() ? this.nextIntToken() : -1) > -1);
                }
            }
        }
        catch (NumberFormatException nfe) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badBreakpointNumber", args));
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandFailed"));
        }
    }

    void doBreak() throws NotConnectedException, NoResponseException, NotSupportedException, NotSuspendedException, IOException, SuspendedException {
        int isolateId;
        int savedIsolateId = isolateId = this.propertyGet(LIST_WORKER);
        this.waitTilHalted(isolateId);
        int module = this.propertyGet(LIST_MODULE);
        int line = this.propertyGet(LIST_LINE);
        FileLocation[] fileLocations = new FileLocation[]{};
        boolean wasAlreadySuspended = false;
        String arg = null;
        boolean propagate = true;
        try {
            if (this.hasMoreTokens()) {
                arg = this.nextToken();
                propagate = !arg.contains("@");
                fileLocations = this.parseLocationArg(module, line, arg);
            } else {
                FileLocation fileLocation;
                Location l = this.getCurrentLocationIsolate(isolateId);
                FileLocation[] file = l.getFile();
                fileLocations[0] = fileLocation = new FileLocation(isolateId, file.getId(), l.getLine());
            }
            boolean switching = false;
            for (FileLocation fileLocation : fileLocations) {
                isolateId = fileLocation.getIsolateId();
                module = fileLocation.getModule();
                line = fileLocation.getLine();
                if (isolateId != savedIsolateId) {
                    switching = true;
                    wasAlreadySuspended = this.swapActiveWorkerAndStop(isolateId);
                }
                BreakAction b = this.addBreakpoint(module, line, isolateId, propagate);
                this.dumpAddedBreakpoint(b);
                this.propertyPut(BPNUM, b.getId());
                if (!switching) continue;
                this.continueAndSwapActiveWorkerBack(savedIsolateId, wasAlreadySuspended);
                switching = false;
            }
        }
        catch (ParseException pe) {
            this.err(pe.getMessage());
        }
        catch (AmbiguousException ae) {
            this.err(ae.getMessage());
        }
        catch (NoMatchException nme) {
            BreakAction b = this.addUnresolvedBreakpoint(arg, this.m_activeIsolate);
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("breakpointNumber", Integer.toString(b.getId()));
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointCreatedButNotYetResolved", args));
            this.propertyPut(BPNUM, b.getId());
        }
        catch (NullPointerException npe) {
            Object filename;
            try {
                filename = this.m_fileInfo.getFile(module, isolateId).getName() + "#" + module;
            }
            catch (Exception e) {
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("fileNumber", Integer.toString(module));
                filename = DebugCLI.getLocalizationManager().getLocalizedTextString("fileNumber", args);
            }
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("filename", filename);
            args.put("line", Integer.toString(line));
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNotSetNoCode", args));
            this.continueAndSwapActiveWorkerBack(savedIsolateId, wasAlreadySuspended);
        }
        catch (InProgressException e) {
            e.printStackTrace();
        }
    }

    private boolean swapActiveWorkerAndStop(int isolateId) throws IOException, NotSupportedException, NotSuspendedException, NoResponseException, NotConnectedException, SuspendedException {
        return this.swapActiveWorkerAndStop(isolateId, true);
    }

    private boolean swapActiveWorkerAndStop(int isolateId, boolean displayInfo) throws IOException, NotSupportedException, NotSuspendedException, NoResponseException, NotConnectedException, SuspendedException {
        this.doWorker(isolateId, displayInfo);
        IsolateSession session = this.m_session.getWorkerSession(this.m_activeIsolate);
        boolean suspended = session.isSuspended();
        if (!suspended) {
            session.suspend();
            this.waitTilHalted(this.m_activeIsolate);
        }
        return suspended;
    }

    private void continueAndSwapActiveWorkerBack(int savedIsolateId, boolean wasAlreadySuspended) throws NotConnectedException, IOException, NotSupportedException, NotSuspendedException, NoResponseException {
        this.continueAndSwapActiveWorkerBack(savedIsolateId, wasAlreadySuspended, true);
    }

    private void continueAndSwapActiveWorkerBack(int savedIsolateId, boolean wasAlreadySuspended, boolean displayInfo) throws NotConnectedException, IOException, NotSupportedException, NotSuspendedException, NoResponseException {
        if (!wasAlreadySuspended) {
            this.m_quietMode = !displayInfo;
            this.doContinue();
        }
        if (this.m_activeIsolate != savedIsolateId) {
            this.doWorker(savedIsolateId, displayInfo);
        }
    }

    void doClear() throws NotConnectedException, SuspendedException, NoResponseException, NotSupportedException, NotSuspendedException, IOException {
        block9: {
            int module = this.propertyGet(LIST_MODULE);
            int line = this.propertyGet(LIST_LINE);
            int isolateId = this.propertyGet(LIST_WORKER);
            String arg = null;
            this.waitTilHalted(this.m_activeIsolate);
            try {
                if (this.hasMoreTokens()) {
                    FileLocation[] fileLocations;
                    arg = this.nextToken();
                    for (FileLocation fileLocation : fileLocations = this.parseLocationArg(module, line, arg)) {
                        isolateId = fileLocation.getIsolateId();
                        module = fileLocation.getModule();
                        line = fileLocation.getLine();
                        try {
                            this.removeBreakpoint(module, line, isolateId);
                        }
                        catch (ArrayIndexOutOfBoundsException aio) {
                            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointLocationUnknown"));
                        }
                        catch (NullPointerException npe) {
                            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNotCleared"));
                        }
                    }
                }
            }
            catch (ParseException pe) {
                this.err(pe.getMessage());
            }
            catch (AmbiguousException ae) {
                this.err(ae.getMessage());
            }
            catch (NoMatchException e) {
                if (this.removeUnresolvedBreakpoint(arg) != null) break block9;
                this.err(e.getMessage());
            }
        }
    }

    BreakAction removeBreakpoint(int fileId, int line, int isolateId) throws ArrayIndexOutOfBoundsException, NotConnectedException, SuspendedException, IOException, NotSupportedException, NotSuspendedException, NoResponseException {
        int at = this.breakpointIndexOf(fileId, line, isolateId);
        return this.removeBreakpointAt(at, isolateId);
    }

    BreakAction removeUnresolvedBreakpoint(String unresolvedLocation) throws NotConnectedException, SuspendedException, IOException, NotSupportedException, NotSuspendedException, NoResponseException {
        int size = this.breakpointCount();
        for (int i = 0; i < size; ++i) {
            BreakAction b = this.breakpointAt(i);
            String s = b.getBreakpointExpression();
            if (s == null || !s.equals(unresolvedLocation)) continue;
            this.m_breakpoints.removeElementAt(i);
            return b;
        }
        return null;
    }

    private BreakAction removeBreakpointAt(int at, int isolateId) throws ArrayIndexOutOfBoundsException, NotConnectedException, NoResponseException, NotSupportedException, SuspendedException, NotSuspendedException, IOException {
        BreakAction a = this.breakpointAt(at);
        if (a.getStatus() == 1) {
            int savedIsolateId = this.m_activeIsolate;
            boolean wasAlreadySuspended = false;
            Location location = null;
            Iterator<Location> iterator = a.getLocations().iterator();
            while (iterator.hasNext()) {
                location = iterator.next();
                if (location.getIsolateId() != isolateId) continue;
                boolean switching = false;
                if (location.getIsolateId() != savedIsolateId) {
                    switching = true;
                    wasAlreadySuspended = this.swapActiveWorkerAndStop(location.getIsolateId());
                }
                LocationCollection locationCollection = new LocationCollection();
                locationCollection.add(location);
                this.breakDisableRequest(locationCollection);
                a.getLocations().remove(location);
                if (a.getLocations().isEmpty()) {
                    this.m_breakpoints.removeElementAt(at);
                }
                if (!switching) continue;
                this.continueAndSwapActiveWorkerBack(savedIsolateId, wasAlreadySuspended);
            }
        } else if (a.getStatus() == 2) {
            this.m_breakpoints.removeElementAt(at);
        }
        return a;
    }

    BreakAction removeBreakpointAt(int at) throws ArrayIndexOutOfBoundsException, NotConnectedException, NoResponseException, NotSupportedException, SuspendedException, NotSuspendedException, IOException {
        BreakAction a = this.breakpointAt(at);
        if (a.getStatus() == 1) {
            int savedIsolateId = this.m_activeIsolate;
            Iterator<Location> iterator = a.getLocations().iterator();
            while (iterator.hasNext()) {
                Location location = iterator.next();
                if (location.getIsolateId() != savedIsolateId) {
                    boolean wasAlreadySuspended = this.swapActiveWorkerAndStop(a.getLocation().getIsolateId());
                    LocationCollection locationCollection = new LocationCollection();
                    locationCollection.add(location);
                    this.breakDisableRequest(locationCollection);
                    this.continueAndSwapActiveWorkerBack(savedIsolateId, wasAlreadySuspended);
                    continue;
                }
                this.breakDisableRequest(a.getLocations());
            }
            this.m_breakpoints.removeElementAt(at);
        } else if (a.getStatus() == 2) {
            this.m_breakpoints.removeElementAt(at);
        }
        return a;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    BreakAction addBreakpoint(int fileId, int line, int isolateId, boolean propagate) throws NotConnectedException, NullPointerException, InProgressException {
        BreakAction b;
        boolean bpExistsButNotForThisIsolate;
        SourceFile f = this.m_fileInfo.getFile(fileId, isolateId);
        int bp = this.breakpointIndexOf(fileId, line, 0, true, -1);
        int at = this.breakpointIndexOf(fileId, line, 0, true, isolateId);
        boolean bpDoesNotExistAtAll = at == -1 && bp == -1;
        boolean bl = bpExistsButNotForThisIsolate = at == -1 && bp > -1;
        if (bpDoesNotExistAtAll) {
            LocationCollection col = this.enableBreak(f, line, isolateId);
            b = new BreakAction(col);
            b.setEnabled(true);
            b.setSingleSwf(this.m_fileInfo.isSwfFilterOn());
            b.setPropagable(propagate);
            this.breakpointAdd(b);
            return b;
        } else {
            if (!bpExistsButNotForThisIsolate) return this.breakpointAt(at);
            b = this.breakpointAt(bp);
            if (b == null) return b;
            SwfInfo[] swfs = this.m_fileInfo.getSwfsIsolate(isolateId);
            SwfInfo swf = swfs.length > 0 ? swfs[swfs.length - 1] : null;
            Location newLoc = this.findAndEnableBreak(swf, f, line);
            if (newLoc == null) throw new RuntimeException("newLock == null");
            b.addLocation(newLoc);
        }
        return b;
    }

    private BreakAction addUnresolvedBreakpoint(String unresolvedLocation, int isolateId) {
        BreakAction b = new BreakAction(unresolvedLocation);
        b.setEnabled(true);
        b.setSingleSwf(this.m_fileInfo.isSwfFilterOn());
        this.breakpointAdd(b);
        return b;
    }

    private boolean resolveBreakpoints(StringBuilder sb) {
        int count = this.breakpointCount();
        boolean success = true;
        for (int i = 0; i < count; ++i) {
            BreakAction b = this.breakpointAt(i);
            try {
                this.tryResolveBreakpoint(b, sb);
                continue;
            }
            catch (Exception e) {
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("breakpointNumber", Integer.toString(b.getId()));
                args.put("expression", b.getBreakpointExpression());
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("attemptingToResolve", args));
                sb.append(m_newline);
                sb.append(e.getMessage());
                sb.append(m_newline);
                success = false;
            }
        }
        return success;
    }

    private boolean tryResolveBreakpoint(BreakAction b, StringBuilder sb) throws AmbiguousException {
        boolean resolved;
        int status = b.getStatus();
        boolean bl = resolved = status == 1;
        if (status == 2 || resolved) {
            try {
                FileLocation[] fileLocations;
                this.waitTilHalted(this.m_activeIsolate);
                int module = this.propertyGet(LIST_MODULE);
                int line = this.propertyGet(LIST_LINE);
                String arg = b.getBreakpointExpression();
                if (arg != null && (fileLocations = this.parseLocationArg(module, line, arg, false)).length == 1) {
                    String formatString;
                    int isolateId = fileLocations[0].getIsolateId();
                    module = fileLocations[0].getModule();
                    line = fileLocations[0].getLine();
                    SourceFile f = this.m_fileInfo.getFile(module, isolateId);
                    LocationCollection col = this.enableBreak(f, line, isolateId);
                    if (col.isEmpty()) {
                        throw new NullPointerException(DebugCLI.getLocalizationManager().getLocalizedTextString("noExecutableCode"));
                    }
                    b.setLocations(col);
                    Location l = col.first();
                    SourceFile file = l != null ? l.getFile() : null;
                    String funcName = file == null ? null : file.getFunctionNameForLine(this.m_session, l.getLine());
                    HashMap<String, Object> args = new HashMap<String, Object>();
                    args.put("breakpointNumber", Integer.toString(b.getId()));
                    if (b.isSingleSwf() && file != null) {
                        Object filename = file.getName();
                        filename = (String)filename + "#" + file.getId();
                        args.put("file", filename);
                    }
                    args.put("line", l.getLine());
                    if (funcName != null) {
                        args.put("functionName", funcName);
                        formatString = "resolvedBreakpointToFunction";
                    } else {
                        formatString = "resolvedBreakpointToFile";
                    }
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString(formatString, args));
                    sb.append(m_newline);
                    sb.append(m_newline);
                    resolved |= true;
                }
            }
            catch (NotConnectedException module) {
            }
            catch (NoMatchException module) {
            }
            catch (ParseException e) {
                if (Trace.error) {
                    Trace.trace((String)e.toString());
                }
            }
            catch (AmbiguousException e) {
                b.setStatus(3);
                throw e;
            }
            catch (NullPointerException e) {
                b.setStatus(4);
                throw e;
            }
        }
        return resolved;
    }

    LocationCollection enableBreak(SourceFile f, int line, int isolateId) throws NotConnectedException {
        LocationCollection col = new LocationCollection();
        boolean singleSwfBreakpoint = this.m_fileInfo.isSwfFilterOn();
        SwfInfo swf = this.m_fileInfo.getSwfFilter();
        if (singleSwfBreakpoint) {
            Location l;
            block7: {
                l = null;
                try {
                    l = this.findAndEnableBreak(swf, f, line);
                }
                catch (InProgressException e) {
                    if (!Trace.error) break block7;
                    Trace.trace((String)((swf == null ? "SWF " : swf.getUrl()) + " still loading, breakpoint at " + f.getName() + ":" + line + " not set"));
                }
            }
            col.add(l);
        } else {
            SwfInfo[] swfs;
            for (SwfInfo swf1 : swfs = this.m_fileInfo.getSwfs(isolateId)) {
                Location l;
                block8: {
                    swf = swf1;
                    if (swf == null) continue;
                    l = null;
                    try {
                        l = this.findAndEnableBreak(swf, f, line);
                    }
                    catch (InProgressException e) {
                        if (!Trace.error) break block8;
                        Trace.trace((String)(swf.getUrl() + " still loading, breakpoint at " + f.getName() + ":" + line + " not set"));
                    }
                }
                if (l == null) continue;
                col.add(l);
            }
        }
        return col;
    }

    Location findAndEnableBreak(SwfInfo swf, SourceFile file, int line) throws NotConnectedException, InProgressException {
        if (swf == null) {
            return this.breakEnableRequest(file.getId(), line, swf.getIsolateId());
        }
        for (SourceFile similarFile : this.getSimilarSourceFilesInSwf(swf, file)) {
            Location location = this.breakEnableRequest(similarFile.getId(), line, swf.getIsolateId());
            if (location == null) continue;
            return location;
        }
        return null;
    }

    private List<SourceFile> getSimilarSourceFilesInSwf(SwfInfo info, SourceFile file) throws InProgressException {
        if (!(info.isProcessingComplete() || info instanceof DSwfInfo && ((DSwfInfo)info).hasAllSource())) {
            throw new InProgressException();
        }
        LinkedList<SourceFile> result = new LinkedList<SourceFile>();
        for (SourceFile each : info.getSourceList(this.m_session)) {
            if (!this.m_fileInfo.filesMatch(file, each)) continue;
            result.add(each);
        }
        return result;
    }

    Location breakEnableRequest(int fileId, int line, int isolateId) throws NotConnectedException {
        Location l = null;
        try {
            l = this.m_session.getWorkerSession(isolateId).setBreakpoint(fileId, line);
        }
        catch (NoResponseException noResponseException) {
            // empty catch block
        }
        return l;
    }

    void breakDisableRequest(LocationCollection col) throws NotConnectedException {
        int at = 0;
        boolean hit = false;
        Location l = col.first();
        do {
            if ((at = this.breakpointIndexOf(l, at)) <= -1) continue;
            if (this.breakpointAt(at).isEnabled()) {
                hit = true;
                try {
                    this.m_session.clearBreakpoint(l);
                }
                catch (NoResponseException noResponseException) {}
                continue;
            }
            ++at;
        } while (at > -1 && !hit);
    }

    BreakAction breakpointAt(int at) {
        return this.m_breakpoints.elementAt(at);
    }

    boolean breakpointAdd(BreakAction a) {
        return this.m_breakpoints.add(a);
    }

    int breakpointCount() {
        return this.m_breakpoints.size();
    }

    int breakpointIndexOf(int fileId, int line) {
        return this.breakpointIndexOf(fileId, line, 0, true);
    }

    int breakpointIndexOf(int fileId, int line, int isolateId) {
        return this.breakpointIndexOf(fileId, line, 0, true, isolateId);
    }

    int breakpointIndexOf(Location l, int start) {
        return this.breakpointIndexOf(l.getFile().getId(), l.getLine(), start, true);
    }

    int enabledBreakpointIndexOf(Location l) {
        return this.breakpointIndexOf(l.getFile().getId(), l.getLine(), 0, false);
    }

    int breakpointIndexOf(int fileId, int line, int start, boolean includeDisabled) {
        return this.breakpointIndexOf(fileId, line, start, includeDisabled, this.m_activeIsolate);
    }

    int breakpointIndexOf(int fileId, int line, int start, boolean includeDisabled, int isolateId) {
        int size = this.breakpointCount();
        int hit = -1;
        for (int i = start; hit < 0 && i < size; ++i) {
            BreakAction b = this.breakpointAt(i);
            if (!b.locationMatches(fileId, line, isolateId) || !includeDisabled && !b.isEnabled()) continue;
            hit = i;
        }
        return hit;
    }

    int breakpointIndexOf(int id) {
        int size = this.breakpointCount();
        int hit = -1;
        for (int i = 0; hit < 0 && i < size; ++i) {
            BreakAction b = this.breakpointAt(i);
            if (b.getId() != id) continue;
            hit = i;
        }
        return hit;
    }

    DisplayAction displayAt(int at) {
        return this.m_displays.get(at);
    }

    boolean displayAdd(DisplayAction a) {
        return this.m_displays.add(a);
    }

    void displayRemoveAt(int at) {
        this.m_displays.remove(at);
    }

    int displayCount() {
        return this.m_displays.size();
    }

    int displayIndexOf(int id) {
        int size = this.displayCount();
        int hit = -1;
        for (int i = 0; hit < 0 && i < size; ++i) {
            DisplayAction b = this.displayAt(i);
            if (b.getId() != id) continue;
            hit = i;
        }
        return hit;
    }

    void doSet() throws NotConnectedException {
        try {
            ValueExp exp = null;
            if (!this.hasMoreTokens()) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("setCommand"));
            } else {
                String s = this.restOfLine();
                exp = this.parseExpression(s);
                if (exp != null) {
                    if (!exp.containsAssignment()) {
                        throw new IllegalAccessException("=");
                    }
                    this.evalExpression(exp, this.m_activeIsolate);
                }
            }
        }
        catch (IllegalAccessException iae) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("operator", iae.getMessage());
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("missingOperator", args));
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotEvaluate"));
        }
    }

    void doPrint() throws NotConnectedException {
        try {
            Object result = null;
            boolean isLookupMembers = false;
            if (!this.hasMoreTokens()) {
                try {
                    result = this.m_exprCache.get("$");
                }
                catch (ArrayIndexOutOfBoundsException aib) {
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandHistoryIsEmpty"));
                    throw new NullPointerException();
                }
            } else {
                String s = this.restOfLine();
                ValueExp expr = this.parseExpression(s);
                if (expr.containsAssignment()) {
                    throw new IllegalAccessException();
                }
                result = this.evalExpression((ValueExp)expr, (int)this.m_activeIsolate).value;
                isLookupMembers = expr.isLookupMembers();
            }
            int which = this.m_exprCache.add(result);
            StringBuilder sb = new StringBuilder();
            sb.append('$');
            sb.append(which);
            sb.append(" = ");
            if (result instanceof Variable) {
                result = ((Variable)result).getValue();
            }
            if (result instanceof InternalProperty) {
                sb.append(((InternalProperty)result).valueOf());
            } else if (isLookupMembers) {
                sb.append(result);
            } else {
                this.m_exprCache.appendVariableValue(sb, result, this.m_activeIsolate);
            }
            this.out(sb.toString());
            this.m_repeatLine = this.m_currentLine;
        }
        catch (ArrayIndexOutOfBoundsException aio) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("number", aio.getMessage());
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("historyHasNotReached", args));
        }
        catch (IllegalAccessException iae) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSideEffectsAllowed"));
        }
        catch (NoSuchVariableException nsv) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("variable", nsv.getMessage());
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("variableUnknown", args));
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotEvaluate"));
        }
    }

    ValueExp parseExpression(String s) {
        ValueExp expr = null;
        try {
            expr = this.m_exprCache.parse(s);
        }
        catch (ParseException pe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("expressionCouldNotBeParsed") + " " + pe.getMessage());
        }
        catch (IOException io) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("expressionCouldNotBeParsed") + " " + s);
        }
        return expr;
    }

    ExpressionCache.EvaluationResult evalExpression(ValueExp expr, int isolateId) {
        return this.evalExpression(expr, true, isolateId);
    }

    ExpressionCache.EvaluationResult evalExpression(ValueExp expr, boolean displayExceptions, int isolateId) {
        ExpressionCache.EvaluationResult result;
        block8: {
            result = null;
            try {
                result = this.m_exprCache.evaluate(expr, isolateId);
            }
            catch (NoSuchVariableException nsv) {
                if (displayExceptions) {
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("variable", nsv.getMessage());
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("variableUnknown", args));
                }
            }
            catch (NumberFormatException nfe) {
                if (displayExceptions) {
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("value", nfe.getMessage());
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotConvertToNumber", args));
                }
            }
            catch (PlayerFaultException pfe) {
                if (displayExceptions) {
                    this.err(pfe.getMessage());
                }
            }
            catch (PlayerDebugException e) {
                if (!displayExceptions) break block8;
                this.err(e.getMessage());
            }
        }
        return result;
    }

    void doMcTree() throws NotConnectedException, NotSuspendedException, NoResponseException {
        this.waitTilHalted(this.m_activeIsolate);
        try {
            String var = this.nextToken();
            String member = "_target";
            boolean printPath = false;
            Object result = null;
            String name = null;
            if (this.hasMoreTokens()) {
                member = this.nextToken();
                while (this.hasMoreTokens()) {
                    String option = this.nextToken();
                    if (!option.equalsIgnoreCase("fullpath")) continue;
                    printPath = true;
                }
            }
            ValueExp expr = this.parseExpression(var);
            result = this.evalExpression((ValueExp)expr, (int)this.m_activeIsolate).value;
            StringBuilder sb = new StringBuilder();
            if (result instanceof Variable) {
                name = ((Variable)result).getName();
                result = ((Variable)result).getValue();
            }
            if (!(result instanceof Value)) {
                throw new NoSuchVariableException(result);
            }
            ArrayList<Object> e = new ArrayList<Object>();
            this.dumpTree(new HashMap<Object, String>(), e, name, (Value)result, member);
            this.treeResults(sb, e, member, printPath);
            this.out(sb.toString());
        }
        catch (NoSuchVariableException nsv) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("variable", nsv.getMessage());
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("variableUnknown", args));
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotEvaluate"));
        }
    }

    void doViewSwf() {
        try {
            if (this.hasMoreTokens()) {
                String swfName = this.nextToken();
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("swf", swfName);
                if (this.m_fileInfo.setSwfFilter(swfName)) {
                    this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("commandsLimitedToSpecifiedSwf", args));
                } else {
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("notValidSwf", args));
                }
            } else {
                this.m_fileInfo.setSwfFilter(null);
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("commandsApplyToAllSwfs"));
            }
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noActiveSession"));
        }
    }

    void doUp() throws PlayerDebugException {
        int num = this.propertyGet(DISPLAY_FRAME_NUMBER) + 1;
        try {
            this.propertyPut(DISPLAY_FRAME_NUMBER, num);
            this.dumpFrame(num);
            this.setListingToFrame(num);
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noActiveSession"));
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("frameNumber", Integer.toString(num));
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("frameDoesNotExist", args));
        }
        this.m_repeatLine = this.m_currentLine;
    }

    void doDown() throws PlayerDebugException {
        int num = this.propertyGet(DISPLAY_FRAME_NUMBER) - 1;
        try {
            this.propertyPut(DISPLAY_FRAME_NUMBER, num);
            this.dumpFrame(num);
            this.setListingToFrame(num);
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noActiveSession"));
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("frameNumber", Integer.toString(num));
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("frameDoesNotExist", args));
        }
        this.m_repeatLine = this.m_currentLine;
    }

    void doFrame() throws PlayerDebugException {
        int num = 0;
        try {
            if (this.hasMoreTokens()) {
                num = this.nextIntToken();
            }
            this.propertyPut(DISPLAY_FRAME_NUMBER, num);
            this.dumpFrame(num);
            this.setListingToFrame(num);
        }
        catch (NumberFormatException nfe) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("notANumber", args));
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("frameNumber", Integer.toString(num));
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("frameDoesNotExist", args));
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noActiveSession"));
        }
    }

    void dumpFrame(int frm) throws PlayerDebugException, ArrayIndexOutOfBoundsException {
        StringBuilder sb = new StringBuilder();
        Frame[] ar = this.m_session.getWorkerSession(this.m_activeIsolate).getFrames();
        this.appendFrameInfo(sb, ar[frm], frm, false, true);
        sb.append(m_newline);
        this.out(sb.toString());
    }

    void setListingToFrame(int frameNum) throws PlayerDebugException {
        Frame[] frames = this.m_session.getWorkerSession(this.m_activeIsolate).getFrames();
        Frame ctx = frames[frameNum];
        Location l = ctx.getLocation();
        SourceFile f = l.getFile();
        int id = f.getId();
        int line = l.getLine();
        this.setListingPosition(id, line, ctx.getIsolateId());
    }

    void setListingPosition(int module, int line, int workerid) {
        SourceFile f;
        this.propertyPut(LIST_MODULE, module);
        this.propertyPut(LIST_LINE, line);
        this.propertyPut(LIST_WORKER, workerid);
        if (this.m_fullnameOption && (f = this.m_fileInfo.getFile(module)) != null) {
            StringBuilder sb = new StringBuilder();
            this.appendFullnamePosition(sb, f, line);
            sb.append('\n');
            this.out(sb.toString());
        }
    }

    void dumpTree(Map<Object, String> tree, List<Object> e, String name, Value result, String member) throws NotSuspendedException, NoResponseException, NotConnectedException {
        String memName;
        Variable m;
        int i;
        Variable[] members;
        if (name == null) {
            name = "";
        }
        if (tree.containsKey(result)) {
            return;
        }
        tree.put(result, name);
        Value proto = result;
        boolean done = false;
        while (!done && proto != null) {
            members = proto.getMembers(this.m_session);
            proto = null;
            for (i = 0; i < members.length; ++i) {
                m = members[i];
                memName = m.getName();
                if (memName.equals(member) && !tree.containsKey(m)) {
                    e.add(name);
                    e.add(result);
                    e.add(m);
                    tree.put(m, name + "." + memName);
                    done = true;
                    continue;
                }
                if (!memName.equals("__proto__")) continue;
                proto = members[i].getValue();
            }
        }
        done = false;
        proto = result;
        while (!done && proto != null) {
            members = proto.getMembers(this.m_session);
            proto = null;
            for (i = 0; i < members.length; ++i) {
                m = members[i];
                memName = m.getName();
                if (m.getValue().getType() != 3 && m.getValue().getType() != 5) continue;
                if (m.getValue().getId() != -1L) {
                    this.dumpTree(tree, e, name, m.getValue(), member);
                    continue;
                }
                if (!memName.equals("__proto__")) continue;
                proto = m.getValue();
            }
        }
    }

    StringBuilder treeResults(StringBuilder sb, List<Object> e, String memName, boolean fullName) {
        Iterator<Object> i = e.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Variable key = (Variable)i.next();
            Variable val = (Variable)i.next();
            if (fullName) {
                sb.append(name);
            }
            this.m_exprCache.appendVariableValue(sb, key.getValue(), key.getName(), key.getIsolateId());
            sb.append(".");
            sb.append(memName);
            sb.append(" = ");
            this.m_exprCache.appendVariableValue(sb, val.getValue(), val.getName(), val.getIsolateId());
            sb.append(m_newline);
        }
        return sb;
    }

    public void outputSource(int module, int line, String s) {
        StringBuilder sb = new StringBuilder();
        this.appendSource(sb, module, line, s, true);
        this.out(sb.toString());
    }

    void appendSource(StringBuilder sb, int module, int line, String s, boolean markCurrent) {
        String lineS = String.valueOf(line);
        int padding = 6 - lineS.length();
        if (markCurrent && this.isCurrentLocation(module, line)) {
            sb.append('=');
        } else {
            sb.append(' ');
        }
        sb.append(lineS);
        this.repeat(sb, ' ', padding);
        sb.append(s);
    }

    boolean isCurrentLocation(int module, int line) {
        SourceFile file;
        boolean yes = false;
        Location l = this.getCurrentLocation();
        if (l != null && (file = l.getFile()) != null && file.getId() == module && l.getLine() == line) {
            yes = true;
        }
        return yes;
    }

    private int parseLineNumber(String lineNumber) throws ParseException {
        try {
            return Integer.parseInt(lineNumber);
        }
        catch (NumberFormatException nfe) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", lineNumber);
            throw new ParseException(DebugCLI.getLocalizationManager().getLocalizedTextString("expectedLineNumber", args), 0);
        }
    }

    private int parseFileNumber(String fileNumber) throws ParseException {
        try {
            return Integer.parseInt(fileNumber);
        }
        catch (NumberFormatException nfe) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", fileNumber);
            throw new ParseException(DebugCLI.getLocalizationManager().getLocalizedTextString("expectedFileNumber", args), 0);
        }
    }

    private int parseWorkerId(String workerId) throws ParseException {
        try {
            return Integer.parseInt(workerId);
        }
        catch (NumberFormatException nfe) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", workerId);
            throw new ParseException(DebugCLI.getLocalizationManager().getLocalizedTextString("expectedIsolateNumber", args), 0);
        }
    }

    private int parseFileName(int isolateId, String partialFileName) throws NoMatchException, AmbiguousException {
        SourceFile[] sourceFiles = this.m_fileInfo.getFiles(partialFileName, isolateId);
        int nSourceFiles = sourceFiles.length;
        if (nSourceFiles == 0) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("name", partialFileName);
            throw new NoMatchException(DebugCLI.getLocalizationManager().getLocalizedTextString("noSourceFileWithSpecifiedName", args));
        }
        if (nSourceFiles > 1) {
            String s = DebugCLI.getLocalizationManager().getLocalizedTextString("ambiguousMatchingFilenames") + m_newline;
            for (int i = 0; i < nSourceFiles; ++i) {
                SourceFile sourceFile = sourceFiles[i];
                s = s + " " + sourceFile.getName() + "#" + sourceFile.getId();
                if (i >= nSourceFiles - 1) continue;
                s = s + m_newline;
            }
            throw new AmbiguousException(s);
        }
        return sourceFiles[0].getId();
    }

    private int[] parseFunctionName(int module, String partialFunctionName, boolean onlyThisModule) throws NoMatchException, AmbiguousException {
        SourceFile m = this.m_fileInfo.getFile(module, this.m_activeIsolate);
        ArrayList<ModuleFunctionPair> functionNames = new ArrayList<ModuleFunctionPair>();
        this.appendFunctionNamesMatching(functionNames, m, partialFunctionName);
        if (functionNames.size() == 0) {
            if (!onlyThisModule) {
                for (Isolate isolate : this.m_session.getWorkers()) {
                    Iterator<?> fileIter = this.m_fileInfo.getAllFiles(isolate.getId());
                    while (fileIter.hasNext()) {
                        SourceFile nextFile = (SourceFile)((Map.Entry)fileIter.next()).getValue();
                        if (nextFile == m) continue;
                        this.appendFunctionNamesMatching(functionNames, nextFile, partialFunctionName);
                    }
                }
            }
            if (functionNames.size() == 0) {
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("name", partialFunctionName);
                throw new NoMatchException(DebugCLI.getLocalizationManager().getLocalizedTextString("noFunctionWithSpecifiedName", args));
            }
        }
        if (functionNames.size() > 1) {
            Object[] functionNameArray = functionNames.toArray(new ModuleFunctionPair[functionNames.size()]);
            Arrays.sort(functionNameArray);
            String s = DebugCLI.getLocalizationManager().getLocalizedTextString("ambiguousMatchingFunctionNames") + m_newline;
            HashMap<String, Object> args = new HashMap<String, Object>();
            for (int i = 0; i < functionNameArray.length; ++i) {
                String moduleName = this.m_fileInfo.getFile(((ModuleFunctionPair)functionNameArray[i]).moduleId, this.m_activeIsolate).getName();
                String functionName = ((ModuleFunctionPair)functionNameArray[i]).functionName;
                args.put("functionName", functionName);
                args.put("filename", moduleName + "#" + ((ModuleFunctionPair)functionNameArray[i]).moduleId);
                s = s + " " + DebugCLI.getLocalizationManager().getLocalizedTextString("functionInFile", args);
                if (i >= functionNameArray.length - 1) continue;
                s = s + m_newline;
            }
            throw new AmbiguousException(s);
        }
        ModuleFunctionPair pair = functionNames.get(0);
        module = pair.moduleId;
        m = this.m_fileInfo.getFile(module, this.m_activeIsolate);
        int line = m.getLineForFunctionName(this.m_session, pair.functionName);
        return new int[]{module, line};
    }

    private void appendFunctionNamesMatching(List<ModuleFunctionPair> functionNameList, SourceFile m, String partialName) {
        int exactHitAt = -1;
        int parenAt = partialName.lastIndexOf(40);
        if (parenAt > -1) {
            partialName = partialName.substring(0, parenAt);
        }
        String[] names = m.getFunctionNames(this.m_session);
        for (int i = 0; i < names.length; ++i) {
            String functionName = names[i];
            if (functionName.equals(partialName)) {
                exactHitAt = i;
                break;
            }
            if (!functionName.startsWith(partialName)) continue;
            functionNameList.add(new ModuleFunctionPair(m.getId(), functionName));
        }
        if (exactHitAt > -1) {
            functionNameList.clear();
            functionNameList.add(new ModuleFunctionPair(m.getId(), names[exactHitAt]));
        }
    }

    public int parseFileArg(int isolateId, int module, String arg) throws ParseException, AmbiguousException, NoMatchException {
        if (arg.length() == 0) {
            return module;
        }
        char firstChar = arg.charAt(0);
        if (Character.isDigit(firstChar) || firstChar == '-') {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", arg);
            throw new ParseException(DebugCLI.getLocalizationManager().getLocalizedTextString("expectedFile", args), 0);
        }
        if (firstChar == '#') {
            if (isolateId == this.m_activeIsolate) {
                return this.parseFileNumber(arg.substring(1));
            }
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", arg);
            throw new NoMatchException(DebugCLI.getLocalizationManager().getLocalizedTextString("noSuchFileOrFunction", args));
        }
        return this.parseFileName(isolateId, arg);
    }

    public int parseLineArg(int module, String arg) throws ParseException, AmbiguousException, NoMatchException {
        if (arg.length() == 0) {
            return 1;
        }
        char firstChar = arg.charAt(0);
        if (Character.isDigit(firstChar) || firstChar == '-') {
            return this.parseLineNumber(arg);
        }
        if (firstChar == '#') {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", arg);
            throw new ParseException(DebugCLI.getLocalizationManager().getLocalizedTextString("expectedLineNumber", args), 0);
        }
        int[] moduleAndLine = this.parseFunctionName(module, arg, true);
        return moduleAndLine[1];
    }

    public FileLocation[] parseLocationArg(int module, int line, String arg) throws ParseException, AmbiguousException, NoMatchException {
        return this.parseLocationArg(module, line, arg, true);
    }

    public FileLocation[] parseLocationArg(int module, int line, String arg, boolean all) throws ParseException, AmbiguousException, NoMatchException {
        FileLocation fileLocation;
        int workerId = -1;
        int colonAt = arg.indexOf(58);
        int wasFunc = 0;
        char firstChar = arg.charAt(0);
        ArrayList<FileLocation> fileLocations = new ArrayList<FileLocation>();
        Iterator<Integer> iterator = this.m_isolateState.keySet().iterator();
        if (colonAt < 0) {
            if (Character.isDigit(firstChar) || firstChar == '-') {
                line = this.parseLineNumber(arg);
            } else if (firstChar == '#') {
                workerId = this.m_activeIsolate;
                module = this.parseFileNumber(arg.substring(1));
                line = 1;
                fileLocation = new FileLocation(workerId + 1, module, line, wasFunc);
                fileLocations.add(fileLocation);
            } else {
                try {
                    int[] moduleAndLine = this.parseFunctionName(module, arg, false);
                    module = moduleAndLine[0];
                    line = moduleAndLine[1];
                    wasFunc = 1;
                    FileLocation fileLocation2 = new FileLocation(workerId + 1, module, line, wasFunc);
                    fileLocations.add(fileLocation2);
                }
                catch (NoMatchException pe) {
                    if (all) {
                        while (iterator.hasNext()) {
                            int currentIsolate = iterator.next();
                            try {
                                module = this.parseFileName(currentIsolate, arg);
                                line = 1;
                                FileLocation fileLocation3 = new FileLocation(currentIsolate, module, line, wasFunc);
                                fileLocations.add(fileLocation3);
                            }
                            catch (NoMatchException fileLocation3) {}
                        }
                    }
                    module = this.parseFileName(this.m_activeIsolate, arg);
                    line = 1;
                    FileLocation fileLocation4 = new FileLocation(this.m_activeIsolate, module, line, wasFunc);
                    fileLocations.add(fileLocation4);
                }
            }
        } else {
            workerId = this.m_activeIsolate;
            if (firstChar == '@') {
                workerId = this.parseWorkerId(arg.substring(1, colonAt));
                if ((colonAt = (arg = arg.substring(colonAt + 1)).indexOf(58)) < 0) {
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("token", arg);
                    throw new NoMatchException(DebugCLI.getLocalizationManager().getLocalizedTextString("noSuchFileOrFunction", args));
                }
                module = this.parseFileArg(workerId + 1, module, arg.substring(0, colonAt));
                line = this.parseLineArg(module, arg.substring(colonAt + 1));
                wasFunc = arg.substring(colonAt + 1).length() > 1 && Character.isDigit(arg.substring(colonAt + 1).charAt(0)) ? 0 : 1;
                fileLocation = new FileLocation(workerId + 1, module, line, wasFunc);
                fileLocations.add(fileLocation);
            } else if (all) {
                while (iterator.hasNext()) {
                    int currentIsolate = iterator.next();
                    try {
                        module = this.parseFileArg(currentIsolate, module, arg.substring(0, colonAt));
                        line = this.parseLineArg(module, arg.substring(colonAt + 1));
                        wasFunc = arg.substring(colonAt + 1).length() > 1 && Character.isDigit(arg.substring(colonAt + 1).charAt(0)) ? 0 : 1;
                        fileLocation = new FileLocation(currentIsolate, module, line, wasFunc);
                        fileLocations.add(fileLocation);
                    }
                    catch (NoMatchException fileLocation5) {}
                }
            } else {
                module = this.parseFileName(this.m_activeIsolate, arg.substring(0, colonAt));
                line = this.parseLineArg(module, arg.substring(colonAt + 1));
                wasFunc = arg.substring(colonAt + 1).length() > 1 && Character.isDigit(arg.substring(colonAt + 1).charAt(0)) ? 0 : 1;
                fileLocation = new FileLocation(this.m_activeIsolate, module, line, wasFunc);
                fileLocations.add(fileLocation);
            }
        }
        if (fileLocations.size() == 0) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", arg);
            throw new NoMatchException(DebugCLI.getLocalizationManager().getLocalizedTextString("noSuchFileOrFunction", args));
        }
        Object[] original = fileLocations.toArray();
        return (FileLocation[])Arrays.copyOf(original, original.length, FileLocation[].class);
    }

    void doWhat() throws NotConnectedException {
        this.waitTilHalted(this.m_activeIsolate);
        try {
            Object result = null;
            String s = this.restOfLine();
            ValueExp expr = this.parseExpression(s);
            if (expr.containsAssignment()) {
                throw new IllegalAccessException();
            }
            result = this.evalExpression((ValueExp)expr, (int)this.m_activeIsolate).value;
            StringBuilder sb = new StringBuilder();
            if (result instanceof Variable) {
                Variable v = (Variable)result;
                if (v.isAttributeSet(32)) {
                    s = DebugCLI.getLocalizationManager().getLocalizedTextString("localVariable");
                } else if (v.isAttributeSet(65536)) {
                    s = DebugCLI.getLocalizationManager().getLocalizedTextString("functionArgumentVariable");
                } else if (!(v instanceof VariableFacade) || (s = ((VariableFacade)v).getPath()) == null || s.length() <= 0) {
                    s = "_global";
                }
                sb.append(s);
            } else {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("mustBeOnlyOneVariable"));
            }
            this.out(sb.toString());
        }
        catch (IllegalAccessException iae) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSideEffectsAllowed"));
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotEvaluate"));
        }
    }

    void doList() {
        int currentModule = this.propertyGet(LIST_MODULE);
        int currentLine = this.propertyGet(LIST_LINE);
        int listsize = this.propertyGet(LIST_SIZE);
        int workerid = this.propertyGet(LIST_WORKER);
        String arg1 = null;
        int module1 = currentModule;
        int line1 = currentLine;
        String arg2 = null;
        int line2 = currentLine;
        int numLines = 0;
        try {
            if (this.hasMoreTokens()) {
                arg1 = this.nextToken();
                if (arg1.equals("-")) {
                    line1 = line2 = line1 - 2 * listsize;
                } else {
                    FileLocation[] fileLocations = this.parseLocationArg(currentModule, currentLine, arg1, false);
                    if (fileLocations.length == 1) {
                        module1 = fileLocations[0].getModule();
                        line2 = line1 = fileLocations[0].getLine();
                    }
                    if (this.hasMoreTokens()) {
                        arg2 = this.nextToken();
                        line2 = this.parseLineArg(module1, arg2);
                    }
                }
            }
            if (this.hasMoreTokens()) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("lineJunk"));
            } else {
                int newLine;
                int half = listsize / 2;
                SourceFile file = this.m_fileInfo.getFile(module1, workerid);
                numLines = file.getLineCount();
                if (numLines == 1 && file.getLine(1).equals("")) {
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("sourceFileNotFound"));
                    newLine = currentLine;
                } else {
                    if (line1 > numLines && arg1 != null) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (arg2 == null) {
                        line2 = line1 + half - 1;
                        line1 -= listsize - half;
                    }
                    if (line1 < 1) {
                        line2 += -(line1 - 1);
                        line1 = 1;
                    }
                    if (line2 > numLines) {
                        line2 = numLines;
                    }
                    if (line1 > line2) {
                        throw new IndexOutOfBoundsException();
                    }
                    SourceFile source = this.m_fileInfo.getFile(module1, workerid);
                    for (int i = line1; i <= line2; ++i) {
                        this.outputSource(module1, i, source.getLine(i));
                    }
                    newLine = line2 + half + (listsize % 2 == 0 ? 1 : 2);
                }
                this.propertyPut(LIST_MODULE, module1);
                this.propertyPut(LIST_LINE, newLine);
                this.propertyPut(LIST_WORKER, workerid);
                this.m_repeatLine = "list";
            }
        }
        catch (IndexOutOfBoundsException iob) {
            String name = "#" + module1;
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("line", Integer.toString(line1));
            args.put("filename", name);
            args.put("total", Integer.toString(numLines));
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("lineNumberOutOfRange", args));
        }
        catch (AmbiguousException ae) {
            this.err(ae.getMessage());
        }
        catch (NoMatchException nme) {
            this.err(nme.getMessage());
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noFilesFound"));
        }
        catch (ParseException pe) {
            this.err(pe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRun() throws IOException {
        if (this.m_session != null) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("sessionInProgress"));
            return;
        }
        SessionManager mgr = Bootstrap.sessionManager();
        if (this.hasMoreTokens() && !this.setLaunchURI(this.restOfLine())) {
            return;
        }
        if (this.m_connectPort == null) {
            mgr.startListening();
        }
        try {
            if (this.m_connectPort != null) {
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("waitingToConnectToPlayer"));
                this.m_session = mgr.connect(Integer.valueOf(this.m_connectPort), null);
            } else if (this.m_launchURI == null) {
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("waitingForPlayerToConnect"));
                this.m_session = mgr.accept(null);
            } else {
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("launchingWithUrl") + m_newline + this.m_launchURI);
                this.m_session = mgr.launch(this.m_launchURI, null, true, null, null);
            }
            if (this.m_session == null) {
                throw new SocketTimeoutException();
            }
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("playerConnectedSessionStarting"));
            this.initSession(this.m_session);
            try {
                this.waitTilHalted(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setInitialSourceFile();
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("setBreakpointsThenResume"));
            this.setPromptState(InitialPromptState.DONE, 1);
            try {
                if (this.m_session.getPreference("$playersupportsget") == 0) {
                    this.err(m_newline + DebugCLI.getLocalizationManager().getLocalizedTextString("warningNotAllCommandsSupported"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (FileNotFoundException fnf) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("uri", fnf.getLocalizedMessage());
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("fileDoesNotExist", args));
        }
        catch (SocketTimeoutException ste) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("failedToConnect"));
        }
        catch (IOException io) {
            this.err(io.getLocalizedMessage());
        }
        finally {
            if (this.m_connectPort == null) {
                mgr.stopListening();
            }
        }
    }

    void doConnect() throws IOException {
        int port = 0;
        if (this.hasMoreTokens()) {
            try {
                port = this.nextIntToken();
            }
            catch (NumberFormatException ex) {
                this.err(ex.getLocalizedMessage());
            }
        } else {
            port = 7936;
        }
        if (port > 0) {
            this.m_connectPort = String.valueOf(port);
            this.doRun();
        }
    }

    private void setInitialSourceFile() {
        int largestAuthoredId = -1;
        SourceFile[] files = this.m_fileInfo.getFileList(this.m_activeIsolate);
        for (int i = 0; i < files.length; ++i) {
            SourceFile sf = files[i];
            if (sf.getId() <= largestAuthoredId || this.getFileType(sf) != 1) continue;
            largestAuthoredId = sf.getId();
        }
        if (largestAuthoredId != -1) {
            this.setListingPosition(largestAuthoredId, 1, this.m_activeIsolate);
        }
    }

    private boolean setLaunchURI(String launchURI) {
        if (launchURI != null) {
            SessionManager mgr = Bootstrap.sessionManager();
            if (!mgr.supportsLaunch() && System.getProperty("fdbunit") == null) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("manuallyLaunchPlayer"));
                return false;
            }
            if (this.m_fullnameOption && ((String)launchURI).startsWith("//")) {
                launchURI = "http:" + (String)launchURI;
            }
        }
        this.m_launchURI = launchURI;
        return true;
    }

    void doFile() {
        if (!this.hasMoreTokens()) {
            this.setLaunchURI(null);
        } else {
            this.setLaunchURI(this.restOfLine());
        }
    }

    void doSource() {
        String name = "";
        try {
            name = this.nextToken();
            FileReader f = new FileReader(name);
            this.pushStream(this.m_in);
            this.m_in = new LineNumberReader(f);
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("sourceCommandRequiresPath"));
        }
        catch (NoSuchElementException nse) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("sourceCommandRequiresPath"));
        }
        catch (FileNotFoundException fnf) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("filename", name);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("fileNotFound", args));
        }
    }

    void listFault(String f) {
        StringBuilder sb = new StringBuilder();
        this.appendFaultTitles(sb);
        this.appendFault(sb, f);
        this.out(sb.toString());
    }

    void appendFault(StringBuilder sb, String f) {
        sb.append(f);
        int space = 30 - f.length();
        this.repeat(sb, ' ', space);
        boolean stop = this.m_faultTable.is(f, "stop");
        boolean print = this.m_faultTable.is(f, "print");
        sb.append(stop ? "Yes" : "No");
        this.repeat(sb, ' ', stop ? 0 : 1);
        this.repeat(sb, ' ', 5);
        sb.append(print ? "Yes" : "No");
        this.repeat(sb, ' ', print ? 0 : 1);
        this.repeat(sb, ' ', 7);
        String desc = this.m_faultTable.getDescription(f);
        sb.append(desc);
        sb.append(m_newline);
    }

    void appendFaultTitles(StringBuilder sb) {
        sb.append("Fault                         Stop    Print     Description" + m_newline);
        sb.append("-----                         ----    -----     -----------" + m_newline);
    }

    void doHandle() {
        if (!this.hasMoreTokens()) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("argumentRequired"));
        } else {
            String faultName = this.nextToken();
            Object[] names = new Object[]{faultName};
            if (faultName.equalsIgnoreCase("all")) {
                names = this.m_faultTable.names();
            }
            if (!this.m_faultTable.exists((String)names[0])) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("unrecognizedFault"));
            } else if (!this.hasMoreTokens()) {
                this.listFault((String)names[0]);
            } else {
                String action = null;
                try {
                    while (this.hasMoreTokens()) {
                        action = this.nextToken();
                        for (int i = 0; i < names.length; ++i) {
                            this.m_faultTable.action((String)names[i], action);
                        }
                    }
                }
                catch (IllegalArgumentException iae) {
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("action", action);
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("unrecognizedAction", args));
                }
            }
        }
    }

    void doCommands() throws IOException {
        try {
            int id = -1;
            id = this.hasMoreTokens() ? this.nextIntToken() : this.propertyGet(BPNUM);
            int at = this.breakpointIndexOf(id);
            BreakAction a = this.breakpointAt(at);
            a.clearCommands();
            a.setSilent(false);
            String line = null;
            boolean first = true;
            boolean isEnd = false;
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("breakpointNumber", Integer.toString(id));
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("typeCommandsForBreakpoint", args));
            do {
                this.displayCommandPrompt();
                line = this.readLine().trim();
                isEnd = line.equalsIgnoreCase("end");
                if (!isEnd) {
                    if (first && line.equalsIgnoreCase("silent")) {
                        a.setSilent(true);
                    } else {
                        a.addCommand(line);
                    }
                }
                first = false;
            } while (!isEnd);
        }
        catch (IndexOutOfBoundsException iob) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("breakpointNumber", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noBreakpointNumber", args));
        }
        catch (NumberFormatException nfe) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badBreakpointNumber", args));
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandFailed"));
        }
    }

    void doCondition() throws IOException {
        try {
            int id = this.nextIntToken();
            int at = this.breakpointIndexOf(id);
            BreakAction a = this.breakpointAt(at);
            if (this.hasMoreTokens()) {
                String line = this.restOfLine();
                ValueExp exp = this.parseExpression(line);
                if (exp.containsAssignment() && !this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("askExpressionContainsAssignment"))) {
                    throw new IllegalAccessException("=");
                }
                a.setCondition(exp, line);
            } else {
                a.clearCondition();
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("breakpointNumber", Integer.toString(id));
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNowUnconditional", args));
            }
        }
        catch (IllegalAccessException iae) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNotChanged"));
        }
        catch (IndexOutOfBoundsException iob) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("breakpointNumber", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noBreakpointNumber", args));
        }
        catch (NumberFormatException nfe) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badBreakpointNumber", args));
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandFailed"));
        }
    }

    void doWatch(boolean read, boolean write) throws PlayerDebugException {
        block15: {
            try {
                if (read) {
                    this.err("Only break-on-write watchpoints are supported.");
                    return;
                }
                StringBuilder sb = new StringBuilder();
                String s = this.restOfLine();
                int flags = 3;
                if (read && write) {
                    flags = 3;
                } else if (read) {
                    flags = 1;
                } else if (write) {
                    flags = 2;
                }
                IsolateSession workerSession = this.m_session.getWorkerSession(this.m_activeIsolate);
                Watch[] list = workerSession.getWatchList();
                ValueExp expr = this.parseExpression(s);
                VariableFacade result = (VariableFacade)this.evalExpression((ValueExp)expr, (int)this.m_activeIsolate).value;
                long varId = result.getContext();
                String memberName = result.getName();
                Value v = workerSession.getValue(varId);
                Watch w = this.m_session.setWatch(v, memberName, flags);
                if (w == null) {
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("expression", s);
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("watchpointCouldNotBeSet", args));
                    break block15;
                }
                Watch[] newList = workerSession.getWatchList();
                if (newList.length == list.length) {
                    int at = this.missingWatchpointIndexOf(newList);
                    WatchAction a = null;
                    try {
                        a = this.watchpointAt(at);
                    }
                    catch (ArrayIndexOutOfBoundsException aio) {
                        a = new WatchAction(w);
                    }
                    int id = a.getId();
                    a.resetWatch(w);
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("watchpointNumber", Integer.toString(id));
                    args.put("expression", s);
                    args.put("watchpointMode", this.getWatchpointModeString(a.getKind()));
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("changedWatchpointMode", args));
                } else {
                    WatchAction a = new WatchAction(w);
                    this.watchpointAdd(a);
                    int which = a.getId();
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("watchpointNumber", Integer.toString(which));
                    args.put("expression", s);
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("createdWatchpoint", args));
                }
                this.out(sb.toString());
            }
            catch (ArrayIndexOutOfBoundsException aio) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badWatchpointNumber"));
            }
            catch (NullPointerException npe) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotEvaluate"));
            }
            catch (ClassCastException cce) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotResolveExpression"));
            }
        }
    }

    WatchAction watchpointAt(int at) {
        return this.m_watchpoints.get(at);
    }

    boolean watchpointAdd(WatchAction a) {
        return this.m_watchpoints.add(a);
    }

    int watchpointCount() {
        return this.m_watchpoints.size();
    }

    int watchpointIndexOf(int id) {
        int size = this.watchpointCount();
        for (int i = 0; i < size; ++i) {
            WatchAction b = this.watchpointAt(i);
            if (b.getId() != id) continue;
            return i;
        }
        return -1;
    }

    void removeAllWatchpoints() throws NotConnectedException {
        while (this.watchpointCount() > 0) {
            this.removeWatchpointAt(0);
        }
    }

    void removeWatchpointAt(int at) throws NotConnectedException {
        WatchAction b = this.watchpointAt(at);
        boolean worked = false;
        try {
            worked = this.m_session.clearWatch(b.getWatch()) != null;
        }
        catch (NoResponseException noResponseException) {
            // empty catch block
        }
        if (!worked) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("variable", b.getExpr());
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotFindWatchpoint", args));
        }
        this.m_watchpoints.remove(at);
    }

    String getWatchpointModeString(int flags) {
        switch (flags) {
            case 1: {
                return DebugCLI.getLocalizationManager().getLocalizedTextString("watchpointMode_read");
            }
            case 2: {
                return DebugCLI.getLocalizationManager().getLocalizedTextString("watchpointMode_write");
            }
            case 3: {
                return DebugCLI.getLocalizationManager().getLocalizedTextString("watchpointMode_readWrite");
            }
        }
        return "";
    }

    int missingWatchpointIndexOf(Watch[] a) {
        int size = this.watchpointCount();
        int at = -1;
        for (int i = 0; i < size && at < 0; ++i) {
            WatchAction action = this.watchpointAt(i);
            Watch w = action.getWatch();
            int hit = -1;
            for (int j = 0; j < a.length && hit < 0; ++j) {
                if (w != a[j]) continue;
                hit = j;
            }
            if (hit >= 0) continue;
            at = i;
        }
        return at;
    }

    void doDisplay() {
        try {
            if (!this.hasMoreTokens()) {
                this.doInfoDisplay();
            } else {
                String s = this.restOfLine();
                ValueExp expr = this.parseExpression(s);
                if (expr.containsAssignment()) {
                    throw new IllegalAccessException();
                }
                DisplayAction b = new DisplayAction(expr, s, this.m_activeIsolate);
                b.setEnabled(true);
                this.displayAdd(b);
            }
        }
        catch (IllegalAccessException iae) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSideEffectsAllowed"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void doUnDisplay() throws IOException {
        try {
            if (!this.hasMoreTokens()) {
                if (this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("askDeleteAllAutoDisplay"))) {
                    int count = this.displayCount();
                    for (int i = count - 1; i > -1; --i) {
                        this.displayRemoveAt(i);
                    }
                }
            } else {
                while (this.hasMoreTokens()) {
                    int id = this.nextIntToken();
                    int at = this.displayIndexOf(id);
                    this.displayRemoveAt(at);
                }
            }
        }
        catch (IndexOutOfBoundsException iob) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("displayNumber", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noDisplayNumber", args));
        }
        catch (NumberFormatException nfe) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badDisplayNumber", args));
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandFailed"));
        }
    }

    void doDisable() throws AmbiguousException, NotConnectedException {
        this.waitTilHalted(this.m_activeIsolate);
        try {
            if (!this.hasMoreTokens()) {
                this.disableAllBreakpoints();
            } else {
                String arg = this.nextToken();
                int cmd = this.disableCommandFor(arg);
                int id = -1;
                if (cmd == 25) {
                    this.doDisableDisplay();
                } else if (cmd == 6 && !this.hasMoreTokens()) {
                    this.disableAllBreakpoints();
                } else {
                    id = cmd == 6 ? this.nextIntToken() : Integer.parseInt(arg);
                    do {
                        int at = this.breakpointIndexOf(id);
                        this.disableBreakpointAt(at);
                    } while ((id = this.hasMoreTokens() ? this.nextIntToken() : -1) > -1);
                }
            }
        }
        catch (IndexOutOfBoundsException iob) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("breakpointNumber", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noBreakpointNumber", args));
        }
        catch (NumberFormatException nfe) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badBreakpointNumber", args));
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandFailed"));
        }
    }

    void disableAllBreakpoints() throws NotConnectedException {
        int count = this.breakpointCount();
        for (int i = 0; i < count; ++i) {
            this.disableBreakpointAt(i);
        }
    }

    void disableBreakpointAt(int at) throws NotConnectedException {
        BreakAction a = this.breakpointAt(at);
        a.setEnabled(false);
        this.breakDisableRequest(a.getLocations());
    }

    void doDisableDisplay() {
        this.doEnableDisableDisplay(false);
    }

    void doEnableDisableDisplay(boolean enable) {
        try {
            if (!this.hasMoreTokens()) {
                int size = this.displayCount();
                for (int i = 0; i < size; ++i) {
                    this.displayAt(i).setEnabled(enable);
                }
            } else {
                while (this.hasMoreTokens()) {
                    int id = this.nextIntToken();
                    int at = this.displayIndexOf(id);
                    DisplayAction a = this.displayAt(at);
                    a.setEnabled(enable);
                }
            }
        }
        catch (IndexOutOfBoundsException iob) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("displayNumber", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noDisplayNumber", args));
        }
        catch (NumberFormatException nfe) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badDisplayNumber", args));
        }
    }

    void doEnable() throws AmbiguousException, NotConnectedException {
        this.waitTilHalted(this.m_activeIsolate);
        try {
            if (!this.hasMoreTokens()) {
                this.enableAllBreakpoints();
            } else {
                String arg = this.nextToken();
                int cmd = this.enableCommandFor(arg);
                int id = -1;
                boolean autoDelete = false;
                boolean autoDisable = false;
                if (cmd == 25) {
                    this.doEnableDisplay();
                } else if (cmd == 6 && !this.hasMoreTokens()) {
                    this.enableAllBreakpoints();
                } else {
                    if (cmd == 6) {
                        id = this.nextIntToken();
                    } else if (cmd == 15) {
                        autoDelete = true;
                        id = this.nextIntToken();
                    } else if (cmd == 301) {
                        autoDisable = true;
                        id = this.nextIntToken();
                    } else {
                        id = Integer.parseInt(arg);
                    }
                    boolean worked = true;
                    do {
                        int at = this.breakpointIndexOf(id);
                        worked = this.enableBreakpointAt(at, autoDisable, autoDelete);
                        id = this.hasMoreTokens() ? this.nextIntToken() : -1;
                    } while (worked && id > -1);
                    if (!worked) {
                        HashMap<String, String> args = new HashMap<String, String>();
                        args.put("breakpointNumber", Integer.toString(id));
                        this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointLocationNoLongerExists", args));
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException iob) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("breakpointNumber", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noBreakpointNumber", args));
        }
        catch (NumberFormatException nfe) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badBreakpointNumber", args));
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandFailed"));
        }
    }

    void enableAllBreakpoints() throws NotConnectedException {
        int count = this.breakpointCount();
        int tally = 0;
        for (int i = 0; i < count; ++i) {
            tally += this.enableBreakpointAt(i) ? 1 : 0;
        }
        if (tally != count) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("notAllBreakpointsEnabled"));
        }
    }

    boolean enableBreakpointAt(int at) throws NotConnectedException {
        return this.enableBreakpointAt(at, false, false);
    }

    boolean enableBreakpointAt(int at, boolean autoDisable, boolean autoDelete) throws NotConnectedException {
        return this.enableBreakpoint(this.breakpointAt(at), autoDisable, autoDelete);
    }

    boolean enableBreakpoint(BreakAction a, boolean autoDisable, boolean autoDelete) throws NotConnectedException {
        boolean retval = false;
        LocationCollection locations = a.getLocations();
        Iterator<Location> iterator = locations.iterator();
        while (iterator.hasNext()) {
            LocationCollection col;
            Location l = iterator.next();
            if (l == null || (col = this.enableBreak(l.getFile(), l.getLine(), l.getIsolateId())).isEmpty()) continue;
            a.setEnabled(true);
            a.setAutoDisable(autoDisable);
            a.setAutoDelete(autoDelete);
            a.setSingleSwf(false);
            a.setStatus(1);
            retval |= true;
        }
        return retval;
    }

    void doEnableDisplay() {
        this.doEnableDisableDisplay(true);
    }

    void doPWD() {
        this.out(System.getProperty("user.dir"));
    }

    void doCF() {
        try {
            int module = this.propertyGet(LIST_MODULE);
            int currentLine = this.propertyGet(LIST_LINE);
            int worker = this.propertyGet(LIST_WORKER);
            if (this.hasMoreTokens()) {
                String arg = this.nextToken();
                module = this.parseFileArg(worker, module, arg);
                currentLine = 1;
                this.setListingPosition(module, currentLine, worker);
            }
            SourceFile sourceFile = this.m_fileInfo.getFile(module, worker);
            StringBuilder sb = new StringBuilder();
            sb.append(sourceFile.getName());
            sb.append('#');
            sb.append(sourceFile.getId());
            sb.append(':');
            sb.append(currentLine);
            this.out(sb.toString());
        }
        catch (NullPointerException npe) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noFilesFound"));
        }
        catch (ParseException pe) {
            this.err(pe.getMessage());
        }
        catch (AmbiguousException ae) {
            this.err(ae.getMessage());
        }
        catch (NoMatchException nme) {
            this.err(nme.getMessage());
        }
    }

    void doKill() throws IOException {
        if (this.m_session == null) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("programNotBeingRun"));
        } else if (this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("askKillProgram"))) {
            this.exitSession();
        }
    }

    boolean doQuit() throws IOException {
        boolean quit = false;
        if (this.m_session == null) {
            quit = true;
        } else {
            quit = this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("askProgramIsRunningExitAnyway"));
            if (quit) {
                this.exitSession();
            }
        }
        return quit;
    }

    @Override
    public InputStream locateSource(String path, String pkg, String name) {
        File f = null;
        boolean exists = false;
        String pkgPlusName = pkg != null && pkg.length() > 0 ? pkg + File.separator + name : null;
        for (String dir : this.m_sourceDirectories) {
            if (dir.equals("")) {
                dir = ".";
            }
            if (pkgPlusName != null) {
                f = new File(dir, pkgPlusName);
                exists = f.exists();
            }
            if (!exists) {
                f = new File(dir, name);
                exists = f.exists();
            }
            if (!exists) continue;
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public int getChangeCount() {
        return this.m_sourceDirectoriesChangeCount;
    }

    private void doDirectory() throws IOException {
        if (this.hasMoreTokens()) {
            StringTokenizer dirs = new StringTokenizer(this.restOfLine(), File.pathSeparator);
            int insertPos = 0;
            while (dirs.hasMoreTokens()) {
                String dir = dirs.nextToken();
                if (dir.length() > 2 && dir.charAt(0) == '\"' && dir.charAt(dir.length() - 1) == '\"') {
                    dir = dir.substring(1, dir.length() - 1);
                }
                if ((dir = dir.trim()).length() <= 0) continue;
                if (!System.getProperty("os.name").toLowerCase().startsWith("windows") && dir.matches("^.*[~$].*$")) {
                    try {
                        Process p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "echo " + dir});
                        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String line = r.readLine();
                        if (line != null && (line = line.trim()).length() > 0) {
                            dir = line;
                        }
                    }
                    catch (IOException p) {
                        // empty catch block
                    }
                }
                try {
                    dir = new File(dir).getCanonicalPath();
                    this.m_sourceDirectories.add(insertPos++, dir);
                }
                catch (IOException e) {
                    this.err(e.getMessage());
                }
            }
            ++this.m_sourceDirectoriesChangeCount;
        } else if (this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("askReinitSourcePath"))) {
            this.initSourceDirectoriesList();
        }
        this.doShowDirectories();
    }

    public void initSourceDirectoriesList() {
        this.m_sourceDirectories.clear();
        File flexHome = this.getFlexHomeDirectory();
        if (flexHome != null) {
            try {
                File projectsDir = new File(flexHome, "frameworks/projects");
                File[] files = projectsDir.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        File srcDir;
                        if (!files[i].isDirectory() || !(srcDir = new File(files[i], "src")).isDirectory()) continue;
                        this.m_sourceDirectories.add(srcDir.getCanonicalPath());
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ++this.m_sourceDirectoriesChangeCount;
    }

    protected File getFlexHomeDirectory() {
        if (!this.m_initializedFlexHomeDirectory) {
            this.m_initializedFlexHomeDirectory = true;
            this.m_flexHomeDirectory = new File(".");
            String flexHome = System.getProperty("application.home");
            if (flexHome != null && flexHome.length() > 0) {
                try {
                    this.m_flexHomeDirectory = new File(flexHome).getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.m_flexHomeDirectory;
    }

    protected String getenv(String var) {
        String[] cmd = System.getProperty("os.name").toLowerCase().startsWith("windows") ? new String[]{"cmd.exe", "/c", "echo", "%" + var + "%"} : new String[]{"/bin/sh", "-c", "echo $" + var};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = r.readLine();
            if (line != null && line.length() > 0) {
                return line;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void doCatch() throws NotConnectedException, NotSuspendedException, NoResponseException {
        CatchAction c;
        this.waitTilHalted(this.m_activeIsolate);
        String typeToCatch = null;
        if (!this.hasMoreTokens()) {
            this.err("Catch requires an exception name.");
            return;
        }
        typeToCatch = this.nextToken();
        if (typeToCatch == null || typeToCatch.length() == 0) {
            this.err("Illegal argument");
            return;
        }
        Value type = null;
        if (typeToCatch.equals("*")) {
            typeToCatch = null;
        } else {
            type = this.getSession().getWorkerSession(this.m_activeIsolate).getGlobal(typeToCatch);
            if (type == null) {
                this.err("Type not found.");
                return;
            }
            String typeName = type.getTypeName();
            int at = typeName.indexOf(64);
            if (at != -1) {
                typeName = typeName.substring(0, at);
            }
            if (!typeName.endsWith("$")) {
                this.err("Not a type: " + type);
                return;
            }
        }
        try {
            c = this.addCatch(typeToCatch);
        }
        catch (NotSupportedException e) {
            e.printStackTrace();
            return;
        }
        HashMap<String, Integer> args = new HashMap<String, Integer>();
        args.put("id", c.getId());
        c.getId();
    }

    private CatchAction addCatch(String typeToCatch) throws NotSupportedException, NoResponseException {
        CatchAction c = new CatchAction(typeToCatch);
        this.catchpointAdd(c);
        return c;
    }

    CatchAction catchpointAt(int at) {
        return this.m_catchpoints.get(at);
    }

    int catchpointCount() {
        return this.m_catchpoints.size();
    }

    boolean catchpointAdd(CatchAction a) throws NotSupportedException, NoResponseException {
        if (this.catchpointCount() == 0) {
            this.getSession().getWorkerSession(this.m_activeIsolate).breakOnCaughtExceptions(true);
        }
        return this.m_catchpoints.add(a);
    }

    int catchpointIndexOf(int id) {
        int size = this.catchpointCount();
        for (int i = 0; i < size; ++i) {
            CatchAction c = this.catchpointAt(i);
            if (c.getId() != id) continue;
            return i;
        }
        return -1;
    }

    void removeAllCatchpoints() throws NotConnectedException {
        while (this.catchpointCount() > 0) {
            this.removeCatchpointAt(0);
        }
    }

    void removeCatchpointAt(int at) throws NotConnectedException {
        this.m_catchpoints.remove(at);
        if (this.catchpointCount() == 0) {
            try {
                this.getSession().getWorkerSession(this.m_activeIsolate).breakOnCaughtExceptions(false);
            }
            catch (NotSupportedException notSupportedException) {
            }
            catch (NoResponseException noResponseException) {
                // empty catch block
            }
        }
    }

    void doUnknown(String s) {
        this.doUnknown("", s);
    }

    void doUnknown(String what, String s) {
        String formatString;
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("command", s);
        if (what == null || what.equals("")) {
            formatString = "unknownCommand";
            args.put("commandCategory", what);
        } else {
            formatString = "unknownSubcommand";
        }
        this.err(DebugCLI.getLocalizationManager().getLocalizedTextString(formatString, args));
    }

    void processEvents() throws NotConnectedException {
        boolean requestResume = false;
        int breakIsolate = 1;
        boolean requestHalt = this.getIsolateState((int)breakIsolate).m_requestHalt;
        while (this.m_session != null && this.m_session.getEventCount() > 0) {
            DebugEvent e = this.m_session.nextEvent();
            if (e instanceof TraceEvent) {
                this.dumpTraceLine(e.information);
                continue;
            }
            if (e instanceof SwfLoadedEvent) {
                this.handleSwfLoadedEvent((SwfLoadedEvent)e);
                continue;
            }
            if (e instanceof SwfUnloadedEvent) {
                this.handleSwfUnloadedEvent((SwfUnloadedEvent)e);
                continue;
            }
            if (e instanceof IsolateCreateEvent) {
                this.handleIsolateCreateEvent((IsolateCreateEvent)e);
                continue;
            }
            if (e instanceof IsolateExitEvent) {
                this.handleIsolateExitEvent((IsolateExitEvent)e);
                continue;
            }
            if (e instanceof BreakEvent) {
                breakIsolate = ((BreakEvent)e).isolateId;
                this.m_breakIsolates.add(breakIsolate);
                int reason = 0;
                try {
                    reason = this.m_session.getWorkerSession(breakIsolate).suspendReason();
                }
                catch (PlayerDebugException playerDebugException) {
                    // empty catch block
                }
                if (reason != 7) break;
                this.setPromptState(InitialPromptState.NEVER_SHOWN, breakIsolate);
                break;
            }
            if (e instanceof FileListModifiedEvent || e instanceof FunctionMetaDataAvailableEvent) continue;
            if (e instanceof FaultEvent) {
                breakIsolate = ((FaultEvent)e).isolateId;
                this.m_breakIsolates.add(breakIsolate);
                if (this.handleFault((FaultEvent)e)) {
                    requestResume = true;
                    break;
                }
                requestHalt = true;
                break;
            }
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("type", e);
            args.put("info", e.information);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("unknownEvent", args));
        }
        IsolateSession workerSession = null;
        if (this.m_session != null) {
            workerSession = this.m_session.getWorkerSession(breakIsolate);
        }
        if (requestResume && !requestHalt && workerSession != null && workerSession.isSuspended() && workerSession.suspendReason() == 3) {
            this.getIsolateState((int)breakIsolate).m_requestResume = true;
        }
    }

    private void handleIsolateExitEvent(IsolateExitEvent e) {
        this.dumpIsolateExitLine(e);
    }

    private void handleIsolateCreateEvent(IsolateCreateEvent e) {
        this.dumpIsolateCreatedLine(e);
    }

    void dumpIsolateCreatedLine(IsolateCreateEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("linePrefixWhenWorkerCreated"));
        sb.append(' ');
        sb.append(e.isolate.getId() - 1);
        this.out(sb.toString());
    }

    void dumpIsolateExitLine(IsolateExitEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("linePrefixWhenWorkerExit"));
        sb.append(' ');
        sb.append(e.isolate.getId() - 1);
        this.out(sb.toString());
    }

    boolean processBreak(boolean postStep, StringBuilder sb, int isolateId) throws NotConnectedException, SuspendedException, IOException, NotSupportedException, NotSuspendedException, NoResponseException {
        int i;
        Location l = this.getCurrentLocationIsolate(isolateId);
        if (l == null || l.getFile() == null) {
            return false;
        }
        int fileId = l.getFile().getId();
        int line = l.getLine();
        boolean isSilent = false;
        boolean bpHit = false;
        boolean stoppedDueToBp = false;
        int count = this.breakpointCount();
        boolean[] markedForRemoval = new boolean[count];
        DebugCLIIsolateState state = this.getIsolateState(isolateId);
        boolean previousResume = state.m_requestResume;
        IsolateSession workerSession = this.m_session.getWorkerSession(isolateId);
        for (i = 0; i < count; ++i) {
            BreakAction a = this.breakpointAt(i);
            if (!a.locationMatches(fileId, line, isolateId)) continue;
            boolean bl = stoppedDueToBp = workerSession.suspendReason() == 1;
            if (!this.shouldBreak(a, fileId, line, isolateId)) continue;
            bpHit = true;
            a.hit();
            boolean bl2 = isSilent = isSilent ? true : a.isSilent();
            if (a.isAutoDisable()) {
                this.disableBreakpointAt(i);
            }
            if (a.isAutoDelete()) {
                markedForRemoval[i] = true;
            }
            int n = a.getCommandCount();
            for (int j = 0; j < n; ++j) {
                this.issueCommand(a.commandAt(j), sb);
            }
        }
        for (i = markedForRemoval.length - 1; i > -1; --i) {
            if (!markedForRemoval[i]) continue;
            this.removeBreakpointAt(i);
        }
        if (stoppedDueToBp && !bpHit) {
            state.m_requestResume = true;
            state.m_stepResume = postStep;
            isSilent = true;
        } else if (stoppedDueToBp && bpHit && state.m_requestResume && !previousResume) {
            state.m_requestResume = true;
            state.m_stepResume = postStep;
            this.processDisplay(sb);
        }
        if (!state.m_requestResume) {
            this.processDisplay(sb);
        }
        return isSilent;
    }

    void processDisplay(StringBuilder sb) {
        int count = this.displayCount();
        for (int i = 0; i < count; ++i) {
            HashMap<String, String> args;
            DisplayAction a = this.displayAt(i);
            if (!a.isEnabled()) continue;
            try {
                sb.append(a.getId());
                sb.append(": ");
                sb.append(a.getContent());
                sb.append(" = ");
                Object result = this.m_exprCache.evaluate((ValueExp)a.getExpression(), (int)a.getIsolateId()).value;
                if (result instanceof Variable) {
                    this.m_exprCache.appendVariableValue(sb, ((Variable)result).getValue(), a.getIsolateId());
                } else if (result instanceof Value) {
                    this.m_exprCache.appendVariableValue(sb, (Value)result, a.getIsolateId());
                } else if (result instanceof InternalProperty) {
                    sb.append(((InternalProperty)result).valueOf());
                } else {
                    sb.append(result);
                }
                sb.append(m_newline);
                continue;
            }
            catch (NoSuchVariableException nsv) {
                args = new HashMap<String, String>();
                args.put("variable", nsv.getMessage());
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("variableUnknown", args));
                sb.append(m_newline);
                continue;
            }
            catch (NumberFormatException nfe) {
                args = new HashMap();
                args.put("value", nfe.getMessage());
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotConvertToNumber", args));
                sb.append(m_newline);
                continue;
            }
            catch (PlayerFaultException pfe) {
                sb.append(pfe.getMessage() + m_newline);
                continue;
            }
            catch (PlayerDebugException e) {
                sb.append(e.getMessage() + m_newline);
                continue;
            }
            catch (NullPointerException npe) {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotEvaluate"));
            }
        }
    }

    boolean shouldBreak(BreakAction a, int fileId, int line, int isolateId) {
        boolean should = a.isEnabled();
        ValueExp exp = a.getCondition();
        if (should && exp != null && !this.getRequestHalt(isolateId)) {
            try {
                ExpressionCache.EvaluationResult result = this.evalExpression(exp, false, isolateId);
                if (result != null) {
                    should = ECMA.toBoolean(result.context.toValue(result.value));
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return should;
    }

    void issueCommand(String cmd, StringBuilder output) {
        PrintStream oldErr;
        PrintStream oldOut;
        PrintStream ps;
        ByteArrayOutputStream ba;
        block7: {
            ba = new ByteArrayOutputStream();
            ps = new PrintStream(ba);
            oldOut = this.m_out;
            oldErr = this.m_err;
            this.m_out = ps;
            this.m_err = ps;
            try {
                this.setCurrentLine(cmd);
                this.processLine();
            }
            catch (AmbiguousException ambiguousException) {
            }
            catch (IllegalStateException ise) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("illegalStateException"));
            }
            catch (IllegalMonitorStateException ime) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandNotValidUntilPlayerSuspended"));
            }
            catch (NoSuchElementException nse) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSuchElementException"));
            }
            catch (SocketException se) {
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("socketErrorMessage", se.getMessage());
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("problemWithConnection", args));
            }
            catch (Exception e) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("unexpectedErrorWithStackTrace"));
                if (!Trace.error) break block7;
                e.printStackTrace();
            }
        }
        ps.flush();
        output.append(ba.toString());
        this.m_err = oldErr;
        this.m_out = oldOut;
    }

    boolean handleFault(FaultEvent e) {
        ExceptionFault ef;
        Value thrownValue;
        boolean print;
        boolean stop;
        boolean requestResume;
        block13: {
            requestResume = false;
            String name = e.name();
            stop = true;
            print = true;
            try {
                print = this.m_faultTable.is(name, "print");
                stop = this.m_faultTable.is(name, "stop");
            }
            catch (NullPointerException npe) {
                if (!Trace.error) break block13;
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("faultName", name);
                Trace.trace((String)DebugCLI.getLocalizationManager().getLocalizedTextString("faultHasNoTableEntry", args));
                npe.printStackTrace();
            }
        }
        if (e instanceof ExceptionFault && (thrownValue = (ef = (ExceptionFault)e).getThrownValue()) != null) {
            if (!ef.willExceptionBeCaught()) {
                stop = true;
            } else {
                stop = false;
                String typeName = thrownValue.getTypeName();
                int at = typeName.indexOf(64);
                if (at != -1) {
                    typeName = typeName.substring(0, at);
                }
                for (int i = 0; i < this.catchpointCount(); ++i) {
                    CatchAction c = this.catchpointAt(i);
                    String typeToCatch = c.getTypeToCatch();
                    try {
                        if (typeToCatch != null && !this.getSession().getWorkerSession(e.isolateId).evalIs(thrownValue, typeToCatch)) continue;
                        stop = true;
                        break;
                    }
                    catch (PlayerDebugException e1) {
                        e1.printStackTrace();
                        stop = true;
                        continue;
                    }
                    catch (PlayerFaultException e1) {
                        e1.printStackTrace();
                        stop = true;
                    }
                }
                if (!stop) {
                    print = false;
                }
            }
        }
        if (!stop) {
            requestResume = true;
        }
        if (print) {
            this.dumpFaultLine(e);
        }
        return requestResume;
    }

    void waitTilHalted(int isolateId) throws NotConnectedException {
        boolean wait;
        if (!this.haveConnection()) {
            throw new IllegalStateException();
        }
        int timeout = this.propertyGet(HALT_TIMEOUT);
        int update = this.propertyGet(UPDATE_DELAY);
        boolean bl = wait = this.propertyGet(NO_WAITING) != 1;
        if (wait) {
            this.waitForSuspend(timeout, update, isolateId);
            if (!this.m_session.getWorkerSession(isolateId).isSuspended()) {
                throw new IllegalMonitorStateException();
            }
        }
    }

    void waitForSuspend(int timeout, int period) throws NotConnectedException {
        this.waitForSuspend(timeout, period, 1);
    }

    void waitForSuspend(int timeout, int period, int isolateId) throws NotConnectedException {
        IsolateSession workerSession = this.m_session.getWorkerSession(isolateId);
        while (timeout > 0) {
            this.processEvents();
            if (workerSession.isSuspended()) break;
            try {
                Thread.sleep(period);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timeout -= period;
        }
    }

    void exitSession() {
        this.m_displays.clear();
        this.m_watchpoints.clear();
        if (this.m_fileInfo != null) {
            this.m_fileInfo.unbind();
        }
        if (this.m_session != null) {
            this.m_session.terminate();
        }
        this.m_session = null;
        this.m_fileInfo = null;
    }

    void initSession(Session s) {
        s.setSourceLocator(this);
        this.m_fileInfo = new FileInfoCache();
        this.m_exprCache.clear();
        this.m_fileInfo.bind(s);
        this.m_exprCache.bind(s);
        boolean correctVersion = true;
        try {
            s.bind();
        }
        catch (VersionException ve) {
            correctVersion = false;
        }
        this.propertyPut(LIST_LINE, 1);
        this.propertyPut(LIST_MODULE, 1);
        this.propertyPut(BPNUM, 0);
        this.propertyPut(LAST_FRAME_DEPTH, 0);
        this.propertyPut(CURRENT_FRAME_DEPTH, 0);
        this.propertyPut(DISPLAY_FRAME_NUMBER, 0);
        this.propertyPut(PLAYER_FULL_SUPPORT, correctVersion ? 1 : 0);
        String previousURI = this.m_mruURI;
        this.m_mruURI = this.m_session.getURI();
        if (previousURI != null && this.m_mruURI != null && previousURI.equalsIgnoreCase(this.m_mruURI)) {
            this.reapplyBreakpoints();
        } else {
            while (this.m_breakpoints.size() > 0) {
                this.m_breakpoints.removeElementAt(0);
            }
        }
        this.m_mainState.m_requestResume = false;
        this.m_mainState.m_stepResume = false;
        this.initIsolateState();
    }

    private void initIsolateState() {
        this.m_activeIsolate = 1;
        this.m_breakIsolates = new Vector();
        this.m_isolateState = new HashMap();
        this.m_isolateState.put(1, this.m_mainState);
    }

    void reapplyBreakpoints() {
        int count = this.breakpointCount();
        for (int i = 0; i < count; ++i) {
            BreakAction a = this.breakpointAt(i);
            a.clearHits();
            a.setStatus(2);
        }
        StringBuilder sb = new StringBuilder();
        this.resolveBreakpoints(sb);
        this.out(sb.toString());
    }

    public boolean processLine() throws IOException, AmbiguousException, PlayerDebugException {
        if (!this.hasMoreTokens()) {
            return false;
        }
        String command = this.nextToken();
        boolean quit = false;
        int cmdID = this.commandFor(command);
        this.m_repeatLine = null;
        switch (cmdID) {
            case 1: {
                quit = this.doQuit();
                break;
            }
            case 2: {
                this.doContinue();
                break;
            }
            case 12: {
                this.doHome();
                break;
            }
            case 19: {
                this.doHelp();
                break;
            }
            case 20: {
                this.doShow();
                break;
            }
            case 3: {
                this.doStep();
                break;
            }
            case 4: {
                this.doNext();
                break;
            }
            case 5: {
                this.doFinish();
                break;
            }
            case 6: {
                this.doBreak();
                break;
            }
            case 18: {
                this.doClear();
                break;
            }
            case 7: {
                this.doSet();
                break;
            }
            case 8: {
                this.doList();
                break;
            }
            case 9: {
                this.doPrint();
                break;
            }
            case 10: {
                this.doTutorial();
                break;
            }
            case 11: {
                this.doInfo();
                break;
            }
            case 14: {
                this.doFile();
                break;
            }
            case 15: {
                this.doDelete();
                break;
            }
            case 13: {
                this.doRun();
                break;
            }
            case 16: {
                this.doSource();
                break;
            }
            case 21: {
                this.doKill();
                break;
            }
            case 22: {
                this.doHandle();
                break;
            }
            case 23: {
                this.doEnable();
                break;
            }
            case 24: {
                this.doDisable();
                break;
            }
            case 25: {
                this.doDisplay();
                break;
            }
            case 26: {
                this.doUnDisplay();
                break;
            }
            case 27: {
                this.doCommands();
                break;
            }
            case 28: {
                this.doPWD();
                break;
            }
            case 29: {
                this.doCF();
                break;
            }
            case 32: {
                this.doWatch(false, true);
                break;
            }
            case 30: {
                this.doCondition();
                break;
            }
            case 34: {
                this.doWhat();
                break;
            }
            case 35: {
                this.doDisassemble();
                break;
            }
            case 36: {
                this.doHalt();
                break;
            }
            case 37: {
                this.doMcTree();
                break;
            }
            case 38: {
                this.doViewSwf();
                break;
            }
            case 39: {
                this.doDown();
                break;
            }
            case 40: {
                this.doUp();
                break;
            }
            case 41: {
                this.doFrame();
                break;
            }
            case 17: {
                break;
            }
            case 109: {
                this.doInfoStack();
                break;
            }
            case 42: {
                this.doDirectory();
                break;
            }
            case 43: {
                this.doCatch();
                break;
            }
            case 44: {
                this.doConnect();
                break;
            }
            case 45: {
                this.doWorker();
                break;
            }
            default: {
                this.doUnknown(command);
            }
        }
        return quit;
    }

    void doWorker() throws IOException, NotSupportedException, NotSuspendedException, NoResponseException, NotConnectedException {
        String workerId;
        if (this.hasMoreTokens() && (workerId = this.nextToken()) != null && workerId.length() > 0) {
            int id = Integer.parseInt(workerId);
            this.doWorker(++id, true);
        }
    }

    void doWorker(int id, boolean doOutput) throws IOException, NotSupportedException, NotSuspendedException, NoResponseException, NotConnectedException {
        try {
            boolean found = false;
            for (Isolate isolate : this.m_session.getWorkers()) {
                if (isolate.getId() != id) continue;
                found = true;
                break;
            }
            StringBuilder sb = new StringBuilder();
            if (found) {
                this.m_activeIsolate = id;
                this.propertyPut(LIST_WORKER, id);
                this.propertyPut(LIST_LINE, 1);
                this.propertyPut(LIST_MODULE, 1);
                this.propertyPut(BPNUM, 0);
                this.propertyPut(LAST_FRAME_DEPTH, 0);
                this.propertyPut(CURRENT_FRAME_DEPTH, 0);
                this.propertyPut(DISPLAY_FRAME_NUMBER, 0);
                if (doOutput) {
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("workerChanged") + " ");
                    if (id == 1) {
                        sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("mainThread"));
                    } else {
                        sb.append(id - 1);
                    }
                    sb.append(m_newline);
                }
            } else if (doOutput) {
                sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("workerNotFound") + " " + (id - 1));
                sb.append(m_newline);
            }
            if (doOutput) {
                this.out(sb.toString());
            }
        }
        catch (NumberFormatException e) {
            this.err(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getHelpTopic(String topic) {
        InputStream helpStream = Help.getResourceAsStream();
        if (helpStream == null) {
            return DebugCLI.getLocalizationManager().getLocalizedTextString("noHelpFileFound");
        }
        topic = "[" + (String)topic + "]";
        Vector<String> lines = new Vector<String>();
        BufferedReader r = null;
        try {
            String line;
            r = new BufferedReader(new InputStreamReader(helpStream, "UTF-8"));
            while ((line = r.readLine()) != null && !line.startsWith((String)topic)) {
            }
            while ((line = r.readLine()) != null) {
                if (line.startsWith("[")) {
                    break;
                }
                lines.add(line);
            }
        }
        catch (FileNotFoundException fnf) {
            this.err(fnf.getLocalizedMessage());
        }
        catch (IOException e) {
            this.err(e.getLocalizedMessage());
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        StringBuilder helpText = new StringBuilder();
        int n = lines.size();
        for (int i = 1; i < n - 1; ++i) {
            String line = (String)lines.get(i);
            helpText.append(line);
            if (i == n - 2) continue;
            helpText.append(m_newline);
        }
        return helpText.toString();
    }

    void doHelp() throws AmbiguousException {
        Object topic = "help";
        if (this.hasMoreTokens()) {
            int cmd = this.commandFor(this.nextToken());
            String commandName = this.commandNumberToCommandName(g_commandArray, cmd);
            topic = commandName;
            if (cmd == 11 && this.hasMoreTokens()) {
                cmd = this.infoCommandFor(this.nextToken());
                commandName = this.commandNumberToCommandName(g_infoCommandArray, cmd);
                topic = (String)topic + " " + commandName;
            } else if (cmd == 20 && this.hasMoreTokens()) {
                cmd = this.showCommandFor(this.nextToken());
                commandName = this.commandNumberToCommandName(g_showCommandArray, cmd);
                topic = (String)topic + " " + commandName;
            }
        }
        this.out(this.getHelpTopic((String)topic));
    }

    void doTutorial() {
        this.out(this.getHelpTopic("Tutorial"));
    }

    int commandFor(String s) throws AmbiguousException {
        return this.determineCommand(g_commandArray, s, 0);
    }

    int showCommandFor(String s) throws AmbiguousException {
        return this.determineCommand(g_showCommandArray, s, 200);
    }

    int infoCommandFor(String s) throws AmbiguousException {
        return this.determineCommand(g_infoCommandArray, s, 100);
    }

    int enableCommandFor(String s) throws AmbiguousException {
        return this.determineCommand(g_enableCommandArray, s, 0);
    }

    int disableCommandFor(String s) throws AmbiguousException {
        return this.determineCommand(g_disableCommandArray, s, 0);
    }

    int determineCommand(StringIntArray cmdList, String input, int defCmd) throws AmbiguousException {
        int cmd = defCmd;
        if (input.charAt(0) == '#') {
            cmd = 17;
        } else {
            ArrayList<Integer> ar = cmdList.elementsStartingWith(input);
            int size = ar.size();
            if (size != 0) {
                if (size == 1 || input.length() == 1 || cmdList.getString(ar.get(0)).compareTo(input) == 0) {
                    cmd = cmdList.getInteger(ar.get(0));
                } else {
                    StringBuilder sb = new StringBuilder();
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("input", input);
                    sb.append(DebugCLI.getLocalizationManager().getLocalizedTextString("ambiguousCommand", args));
                    sb.append(' ');
                    sb.append(input);
                    for (int i = 0; i < size; ++i) {
                        String s = cmdList.getString(ar.get(i));
                        sb.append(s);
                        if (i + 1 >= size) continue;
                        sb.append(", ");
                    }
                    sb.append('.');
                    this.err(sb.toString());
                    throw new AmbiguousException();
                }
            }
        }
        return cmd;
    }

    String commandNumberToCommandName(StringIntArray cmdList, int cmdNumber) {
        for (int i = 0; i < cmdList.size(); ++i) {
            if (cmdList.getInt(i) != cmdNumber) continue;
            return cmdList.getString(i);
        }
        return "?";
    }

    void appendBreakInfo(StringBuilder sb, int isolateId) throws NotConnectedException {
        Extensions.appendBreakInfo(this, sb, false, isolateId);
    }

    void doShowStats() {
        Extensions.doShowStats(this);
    }

    void doShowFuncs() {
        Extensions.doShowFuncs(this);
    }

    void doShowProperties() {
        Extensions.doShowProperties(this);
    }

    void doShowVariable() throws PlayerDebugException {
        Extensions.doShowVariable(this);
    }

    void doShowBreak() throws NotConnectedException {
        Extensions.doShowBreak(this);
    }

    void doDisassemble() throws PlayerDebugException {
        Extensions.doDisassemble(this);
    }

    static {
        m_localizationManager.addLocalizer((ILocalizer)new DebuggerLocalizer("flex.tools.debugger.cli.fdb."));
        FRAMEWORK_FILE_PACKAGES = new String[]{"mx", "flex", "text"};
        g_commandArray = new StringIntArray((Object[])new Object[][]{{"awatch", 31}, {"break", 6}, {"bt", 109}, {"continue", 2}, {"catch", 43}, {"cf", 29}, {"clear", 18}, {"commands", 27}, {"condition", 30}, {"connect", 44}, {"delete", 15}, {"disable", 24}, {"disassemble", 35}, {"display", 25}, {"directory", 42}, {"down", 39}, {"enable", 23}, {"finish", 5}, {"file", 14}, {"frame", 41}, {"help", 19}, {"halt", 36}, {"handle", 22}, {"home", 12}, {"info", 11}, {"kill", 21}, {"list", 8}, {"next", 4}, {"nexti", 4}, {"mctree", 37}, {"print", 9}, {"pwd", 28}, {"quit", 1}, {"run", 13}, {"rwatch", 33}, {"step", 3}, {"stepi", 3}, {"set", 7}, {"show", 20}, {"source", 16}, {"tutorial", 10}, {"undisplay", 26}, {"up", 40}, {"where", 109}, {"watch", 32}, {"what", 34}, {"viewswf", 38}, {"worker", 45}});
        g_infoCommandArray = new StringIntArray((Object[])new Object[][]{{"arguments", 101}, {"breakpoints", 102}, {"display", 111}, {"files", 103}, {"functions", 105}, {"handle", 104}, {"locals", 106}, {"stack", 109}, {"scopechain", 107}, {"sources", 108}, {"swfs", 113}, {"targets", 112}, {"variables", 110}, {"workers", 114}});
        g_showCommandArray = new StringIntArray((Object[])new Object[][]{{"break", 206}, {"directories", 210}, {"files", 205}, {"functions", 202}, {"locations", 209}, {"memory", 208}, {"net", 201}, {"properties", 204}, {"uri", 203}, {"variable", 207}});
        g_enableCommandArray = new StringIntArray((Object[])new Object[][]{{"breakpoints", 6}, {"display", 25}, {"delete", 15}, {"once", 301}});
        g_disableCommandArray = new StringIntArray((Object[])new Object[][]{{"display", 25}, {"breakpoints", 6}});
    }

    class DebugCLIIsolateState {
        public boolean m_requestResume;
        public boolean m_requestHalt;
        public boolean m_stepResume;
        public InitialPromptState m_promptState;

        public DebugCLIIsolateState(DebugCLI debugcli) {
            DebugCLI.this.m_faultTable = faultActionsBuilder.build();
        }
    }

    public static enum InitialPromptState {
        NEVER_SHOWN,
        SHOWN_ONCE,
        DONE;

    }

    private static interface AnyKindOfStep {
        public void step() throws PlayerDebugException;
    }

    private static class ModuleFunctionPair
    implements Comparable<ModuleFunctionPair> {
        public int moduleId;
        public String functionName;

        public ModuleFunctionPair(int moduleId, String functionName) {
            this.moduleId = moduleId;
            this.functionName = functionName;
        }

        @Override
        public int compareTo(ModuleFunctionPair other) {
            return this.functionName.compareTo(other.functionName);
        }
    }
}

