/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLHelper {
    private static Pattern URL_PATTERN = Pattern.compile("^(.*?)(\\?.*?)?(#.*)?$");
    private String m_everythingBeforeQuery;
    private String m_query;
    private String m_fragment;

    public URLHelper(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url);
        }
        if (matcher.matches()) {
            this.m_everythingBeforeQuery = matcher.group(1);
            this.m_query = matcher.group(2);
            if (this.m_query == null) {
                this.m_query = "";
            }
            this.m_fragment = matcher.group(3);
            if (this.m_fragment == null) {
                this.m_fragment = "";
            }
        }
    }

    public String getEverythingBeforeQuery() {
        return this.m_everythingBeforeQuery;
    }

    public void setEverythingBeforeQuery(String everythingBeforeQuery) {
        URLHelper.assertValidArguments(everythingBeforeQuery, this.getQuery(), this.getFragment());
        this.m_everythingBeforeQuery = everythingBeforeQuery;
    }

    public String getQuery() {
        return this.m_query;
    }

    public void setQuery(String query) {
        if (((String)query).length() > 0 && ((String)query).charAt(0) != '?') {
            query = "?" + (String)query;
        }
        URLHelper.assertValidArguments(this.getEverythingBeforeQuery(), (String)query, this.getFragment());
        this.m_query = query;
    }

    public String getFragment() {
        return this.m_fragment;
    }

    public void setFragment(String fragment) {
        if (((String)fragment).length() > 0 && ((String)fragment).charAt(0) != '#') {
            fragment = "#" + (String)fragment;
        }
        URLHelper.assertValidArguments(this.getEverythingBeforeQuery(), this.getQuery(), (String)fragment);
        this.m_fragment = fragment;
    }

    private static void assertValidArguments(String everythingBeforeQuery, String query, String fragment) {
        assert (URLHelper.areArgumentsValid(everythingBeforeQuery, query, fragment));
    }

    private static boolean areArgumentsValid(String everythingBeforeQuery, String query, String fragment) {
        if (everythingBeforeQuery == null || query == null || fragment == null) {
            return false;
        }
        URLHelper newHelper = new URLHelper(everythingBeforeQuery + query + fragment);
        return newHelper.getEverythingBeforeQuery().equals(everythingBeforeQuery) && newHelper.getQuery().equals(query) && newHelper.getFragment().equals(fragment);
    }

    public String getURL() {
        return this.m_everythingBeforeQuery + this.m_query + this.m_fragment;
    }

    public LinkedHashMap<String, String> getParameterMap() {
        StringTokenizer tokens = new StringTokenizer(this.getQuery(), "?&");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(tokens.countTokens() * 2);
        while (tokens.hasMoreElements()) {
            String nameValuePair;
            String name = nameValuePair = tokens.nextToken();
            String value = "";
            int equalsIndex = nameValuePair.indexOf(61);
            if (equalsIndex != -1 && (name = nameValuePair.substring(0, equalsIndex)).length() > 0) {
                value = nameValuePair.substring(equalsIndex + 1);
            }
            map.put(name, value);
        }
        return map;
    }

    public void setParameterMap(Map<String, String> parameterMap) {
        if (parameterMap != null && !parameterMap.isEmpty()) {
            StringBuilder queryString = new StringBuilder();
            Iterator<Map.Entry<String, String>> it = parameterMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                String name = entry.getKey();
                String value = String.valueOf(entry.getValue());
                queryString.append(name);
                if (value != null && !value.equals("")) {
                    queryString.append('=');
                    queryString.append(value);
                }
                if (!it.hasNext()) continue;
                queryString.append('&');
            }
            this.setQuery(queryString.toString());
        } else {
            this.setQuery("");
        }
    }

    public static String escapeSpace(String uri) {
        return URLHelper.escapeCharacter(uri, ' ', "%20");
    }

    public static String escapeCharacter(String uri, char c, String to) {
        int i;
        StringBuilder sb = new StringBuilder();
        int size = uri.length();
        int at = uri.indexOf(58);
        int lastAt = 0;
        if (at > -1) {
            for (i = 0; i <= at; ++i) {
                sb.append(uri.charAt(i));
            }
            lastAt = ++at;
        }
        while ((at = uri.indexOf(c, at)) > -1) {
            for (i = lastAt; i < at; ++i) {
                sb.append(uri.charAt(i));
            }
            sb.append(to);
            lastAt = ++at;
        }
        if (lastAt < size) {
            for (i = lastAt; i < size; ++i) {
                sb.append(uri.charAt(i));
            }
        }
        return sb.toString();
    }
}

