/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.threadsafe;

import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.events.FaultEvent;
import flash.tools.debugger.threadsafe.ThreadSafeDebuggerObject;
import flash.tools.debugger.threadsafe.ThreadSafeSession;
import flash.tools.debugger.threadsafe.ThreadSafeValue;

public class ThreadSafeVariable
extends ThreadSafeDebuggerObject
implements Variable {
    private Variable fVar;

    private ThreadSafeVariable(Object syncObj, Variable var) {
        super(syncObj);
        this.fVar = var;
    }

    public static ThreadSafeVariable wrap(Object syncObj, Variable variable) {
        if (variable != null) {
            return new ThreadSafeVariable(syncObj, variable);
        }
        return null;
    }

    public static ThreadSafeVariable[] wrapArray(Object syncObj, Variable[] variables) {
        ThreadSafeVariable[] threadSafeVariables = new ThreadSafeVariable[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            threadSafeVariables[i] = ThreadSafeVariable.wrap(syncObj, variables[i]);
        }
        return threadSafeVariables;
    }

    public static Variable getRaw(Variable v) {
        if (v instanceof ThreadSafeVariable) {
            return ((ThreadSafeVariable)v).fVar;
        }
        return v;
    }

    public static Object getSyncObject(Variable v) {
        return ((ThreadSafeVariable)v).getSyncObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVar.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAttributes() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVar.getAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAttributeSet(int variableAttribute) {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVar.isAttributeSet(variableAttribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value getValue() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeValue.wrap(this.getSyncObject(), this.fVar.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasValueChanged(Session s) {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVar.hasValueChanged(ThreadSafeSession.getRaw(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needsToInvokeGetter() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVar.needsToInvokeGetter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeGetter(Session s) throws NotSuspendedException, NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            this.fVar.invokeGetter(ThreadSafeSession.getRaw(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getQualifiedName() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVar.getQualifiedName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNamespace() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVar.getNamespace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScope() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVar.getScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FaultEvent setValue(Session s, int type, String value) throws NotSuspendedException, NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVar.setValue(ThreadSafeSession.getRaw(s), type, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefiningClass() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVar.getDefiningClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLevel() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVar.getLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVar.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIsolateId() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVar.getIsolateId();
        }
    }
}

