/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.AIRLaunchInfo;
import flash.tools.debugger.Frame;
import flash.tools.debugger.IDebuggerCallbacks;
import flash.tools.debugger.ILauncher;
import flash.tools.debugger.InProgressException;
import flash.tools.debugger.Isolate;
import flash.tools.debugger.IsolateController;
import flash.tools.debugger.IsolateSession;
import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSupportedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SessionManager;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SourceLocator;
import flash.tools.debugger.SuspendedException;
import flash.tools.debugger.SwfInfo;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.VersionException;
import flash.tools.debugger.Watch;
import flash.tools.debugger.concrete.BinaryOp;
import flash.tools.debugger.concrete.DIsolate;
import flash.tools.debugger.concrete.DLocation;
import flash.tools.debugger.concrete.DManager;
import flash.tools.debugger.concrete.DMessage;
import flash.tools.debugger.concrete.DMessageCache;
import flash.tools.debugger.concrete.DMessageCounter;
import flash.tools.debugger.concrete.DProtocol;
import flash.tools.debugger.concrete.DProtocolNotifierIF;
import flash.tools.debugger.concrete.DStackContext;
import flash.tools.debugger.concrete.DSuspendInfo;
import flash.tools.debugger.concrete.DSwfInfo;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.concrete.DVariable;
import flash.tools.debugger.concrete.DWatch;
import flash.tools.debugger.concrete.IsolatePlayerSession;
import flash.tools.debugger.concrete.PlayerSessionIsolateStatus;
import flash.tools.debugger.concrete.PlayerSessionManager;
import flash.tools.debugger.events.DebugEvent;
import flash.tools.debugger.events.ExceptionFault;
import flash.tools.debugger.events.FaultEvent;
import flash.tools.debugger.expression.ECMA;
import flash.tools.debugger.expression.PlayerFaultException;
import flash.util.Trace;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlayerSession
implements Session,
DProtocolNotifierIF,
Runnable,
IsolateController {
    public static final int MAX_STACK_DEPTH = 256;
    public static final long MAX_TERMINATE_WAIT_MILLIS = 10000L;
    private Socket m_socket;
    private DProtocol m_protocol;
    private DManager m_manager;
    private IDebuggerCallbacks m_debuggerCallbacks;
    private Process m_process;
    private Map<String, Object> m_prefs;
    private static final String s_newline = System.getProperty("line.separator");
    private volatile boolean m_isConnected = false;
    private volatile boolean m_isHalted = false;
    private volatile boolean m_incoming;
    private volatile boolean m_lastResponse;
    private volatile HashMap<Integer, PlayerSessionIsolateStatus> m_isolateStatus = new HashMap();
    private int m_watchTransactionTag;
    private Boolean m_playerCanCallFunctions;
    private Boolean m_playerSupportsWatchpoints;
    private Boolean m_playerCanBreakOnAllExceptions;
    private Boolean m_playerSupportsConcurrency;
    private Boolean m_playerSupportsWideLine;
    private ILauncher launcher;
    private String m_launchUrl;
    private AIRLaunchInfo m_airLaunchInfo;
    static volatile boolean m_debugMsgOn;
    volatile int m_debugMsgSize;
    static volatile boolean m_debugMsgFileOn;
    volatile int m_debugMsgFileSize;
    private Map<String, Boolean> m_evalIsAndInstanceofCache = new HashMap<String, Boolean>();
    private volatile int m_lastPreIsolate = 1;
    private final Map<Integer, IsolateSession> m_isolateSessions;
    private static final String DEBUG_MESSAGES = "$debug_messages";
    private static final String DEBUG_MESSAGE_SIZE = "$debug_message_size";
    private static final String DEBUG_MESSAGE_FILE = "$debug_message_file";
    private static final String DEBUG_MESSAGE_FILE_SIZE = "$debug_message_file_size";
    private static final String CONSOLE_ERRORS = "$console_errors";
    private static final String FLASH_PREFIX = "$flash_";
    Writer m_trace;

    PlayerSession(Socket s, DProtocol proto, DManager manager, IDebuggerCallbacks debuggerCallbacks) {
        this.m_socket = s;
        this.m_protocol = proto;
        this.m_manager = manager;
        this.m_prefs = Collections.synchronizedMap(new HashMap());
        this.m_incoming = false;
        m_debugMsgOn = false;
        this.m_debugMsgSize = 16;
        m_debugMsgFileOn = false;
        this.m_debugMsgFileSize = 128;
        this.m_watchTransactionTag = 1;
        this.m_playerCanCallFunctions = null;
        this.m_debuggerCallbacks = debuggerCallbacks;
        this.m_isolateSessions = Collections.synchronizedMap(new HashMap());
    }

    private static PlayerSession createFromSocketHelper(Socket s, IDebuggerCallbacks debuggerCallbacks, DProtocol proto) throws IOException {
        DManager manager = new DManager();
        PlayerSession session = new PlayerSession(s, proto, manager, debuggerCallbacks);
        return session;
    }

    public static PlayerSession createFromSocket(Socket s, IDebuggerCallbacks debuggerCallbacks) throws IOException {
        DProtocol proto = DProtocol.createFromSocket(s);
        return PlayerSession.createFromSocketHelper(s, debuggerCallbacks, proto);
    }

    public static PlayerSession createFromSocketWithOptions(Socket s, IDebuggerCallbacks debuggerCallbacks, SessionManager sessionManager) throws IOException {
        DProtocol proto = DProtocol.createFromSocket(s, sessionManager);
        return PlayerSession.createFromSocketHelper(s, debuggerCallbacks, proto);
    }

    public DMessageCounter getMessageCounter() {
        return this.m_protocol.getMessageCounter();
    }

    @Override
    public String getURI() {
        return this.m_manager.getURI();
    }

    public boolean playerSupportsGet() {
        return this.m_manager.isGetSupported();
    }

    public int playerVersion() {
        return this.m_manager.getVersion();
    }

    @Override
    public SourceLocator getSourceLocator() {
        return this.m_manager.getSourceLocator();
    }

    @Override
    public void setSourceLocator(SourceLocator sourceLocator) {
        this.m_manager.setSourceLocator(sourceLocator);
    }

    void setProcess(Process proc) {
        this.m_process = proc;
    }

    @Override
    public Process getLaunchProcess() {
        return this.m_process;
    }

    public void setPreferences(Map<String, ? extends Object> map) {
        this.m_prefs.putAll(map);
        this.mapBack();
    }

    public Set<String> keySet() {
        return this.m_prefs.keySet();
    }

    public Object getPreferenceAsObject(String pref) {
        return this.m_prefs.get(pref);
    }

    @Override
    public void setPreference(String pref, int value) {
        this.m_prefs.put(pref, value);
        this.mapBack();
        if (pref.equals(CONSOLE_ERRORS)) {
            this.sendConsoleErrorsAsTrace(value == 1);
        }
        if (pref.startsWith(FLASH_PREFIX)) {
            this.sendOptionMessage(pref.substring(FLASH_PREFIX.length()), Integer.toString(value));
        }
    }

    private int mapBackOnePreference(String preferenceName, int defaultValue) {
        Object prefValue = this.getPreferenceAsObject(preferenceName);
        if (prefValue != null) {
            return (Integer)prefValue;
        }
        return defaultValue;
    }

    private boolean mapBackOnePreference(String preferenceName, boolean defaultValue) {
        Object prefValue = this.getPreferenceAsObject(preferenceName);
        if (prefValue != null) {
            return (Integer)prefValue != 0;
        }
        return defaultValue;
    }

    private void mapBack() {
        m_debugMsgOn = this.mapBackOnePreference(DEBUG_MESSAGES, m_debugMsgOn);
        this.m_debugMsgSize = this.mapBackOnePreference(DEBUG_MESSAGE_SIZE, this.m_debugMsgSize);
        m_debugMsgFileOn = this.mapBackOnePreference(DEBUG_MESSAGE_FILE, m_debugMsgFileOn);
        this.m_debugMsgFileSize = this.mapBackOnePreference(DEBUG_MESSAGE_FILE_SIZE, this.m_debugMsgFileSize);
    }

    @Override
    public int getPreference(String pref) {
        int val = 0;
        Integer i = (Integer)this.m_prefs.get(pref);
        if (i == null) {
            throw new NullPointerException();
        }
        val = i;
        return val;
    }

    @Override
    public boolean isConnected() {
        return this.m_isConnected;
    }

    @Override
    public boolean isSuspended() throws NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.m_isHalted;
    }

    @Override
    public boolean isWorkerSuspended(int isolateId) throws NotConnectedException {
        if (isolateId == 1) {
            return this.isSuspended();
        }
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.m_isolateStatus.containsKey(isolateId)) {
            return this.m_isolateStatus.get((Object)Integer.valueOf((int)isolateId)).m_isHalted;
        }
        return false;
    }

    @Override
    public boolean bind() throws VersionException {
        boolean bound = false;
        if (this.m_isConnected) {
            return false;
        }
        this.m_isConnected = true;
        this.m_protocol.addListener(DProtocol.ListenerIndex.PlayerSession, this);
        bound = this.m_protocol.bind();
        this.sendStopWarning();
        this.sendStopOnFault();
        this.sendEnumerateOverride();
        this.sendFailureNotify();
        this.sendInvokeSetters();
        this.sendSwfloadNotify();
        this.sendGetterTimeout();
        this.sendSetterTimeout();
        boolean responded = this.sendSquelch(true, 1);
        this.setPreference("$playersupportsget", this.playerSupportsGet() ? 1 : 0);
        if (this.supportsConcurrency()) {
            this.sendConcurrentDebugger();
        }
        if (this.supportsWideLineNumbers()) {
            this.sendWideLineDebugger();
        }
        Thread t = new Thread((Runnable)this, "SWF/SWD reader");
        t.setDaemon(true);
        t.start();
        if (!responded) {
            throw new VersionException();
        }
        return bound;
    }

    @Override
    public void unbind() {
        this.unbind(false);
    }

    private boolean unbind(boolean requestTerminate) {
        requestTerminate = requestTerminate && this.playerCanTerminate();
        DMessage dm = DMessageCache.alloc(1);
        dm.setType(13);
        dm.putByte((byte)(requestTerminate ? 1 : 0));
        this.sendMessage(dm);
        this.m_protocol.unbind();
        try {
            this.m_socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_isConnected = false;
        this.m_isHalted = false;
        return requestTerminate;
    }

    private String executeAppleScript(String[] appleScript, String[] argv) {
        StringBuilder retval = new StringBuilder();
        try {
            int ch;
            LinkedList<String> execArgs = new LinkedList<String>();
            execArgs.add("/usr/bin/osascript");
            execArgs.add("-");
            if (argv != null) {
                for (int i = 0; i < argv.length; ++i) {
                    execArgs.add(argv[i]);
                }
            }
            Process osascript = Runtime.getRuntime().exec(execArgs.toArray(new String[execArgs.size()]));
            OutputStream outputStream = osascript.getOutputStream();
            PrintWriter writer = new PrintWriter(outputStream, true);
            writer.println("on run argv");
            for (int i = 0; i < appleScript.length; ++i) {
                writer.println(appleScript[i]);
            }
            writer.println("end run");
            writer.close();
            InputStreamReader reader = new InputStreamReader(osascript.getInputStream());
            while ((ch = reader.read()) != -1) {
                retval.append((char)ch);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retval.toString().replaceAll("\n$", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeAppleScript(String appleScriptFilename, String[] argv) throws IOException {
        try (InputStream stm = null;){
            String line;
            stm = PlayerSession.class.getResourceAsStream(appleScriptFilename);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stm));
            ArrayList<String> appleScriptLines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                appleScriptLines.add(line);
            }
            String[] lines = appleScriptLines.toArray(new String[appleScriptLines.size()]);
            String string = this.executeAppleScript(lines, argv);
            return string;
        }
    }

    private Set<String> runningApplications() {
        String running = this.executeAppleScript(new String[]{"tell application \"System Events\"", "\tname of processes", "end tell"}, null);
        String[] apps = running.split(", ");
        HashSet<String> retval = new HashSet<String>();
        for (int i = 0; i < apps.length; ++i) {
            retval.add(apps[i]);
        }
        return retval;
    }

    @Override
    public void terminate() {
        block25: {
            boolean playerWillTerminateItself = false;
            try {
                playerWillTerminateItself = this.unbind(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!playerWillTerminateItself) {
                if (System.getProperty("os.name").toLowerCase().startsWith("mac os x") && this.m_airLaunchInfo == null && this.m_launchUrl != null && this.m_launchUrl.length() > 0) {
                    String url2;
                    boolean closedAnyWindows = false;
                    Set<String> runningApps = this.runningApplications();
                    if (runningApps.contains("Safari")) {
                        try {
                            url2 = this.m_launchUrl.replaceAll(" ", "%20");
                            String safariClosedAnyWindows = this.executeAppleScript("appleScriptCloseSafariWindow.txt", new String[]{url2});
                            if ("true".equals(safariClosedAnyWindows)) {
                                closedAnyWindows = true;
                            } else if ("appquit".equals(safariClosedAnyWindows)) {
                                closedAnyWindows = true;
                                runningApps = this.waitForMacAppQuit("Safari");
                            }
                        }
                        catch (IOException url2) {
                            // empty catch block
                        }
                    }
                    if (!closedAnyWindows && runningApps.contains("Camino")) {
                        url2 = this.m_launchUrl.replaceFirst("^file:///", "file://localhost/");
                        try {
                            String caminoClosedAnyWindows = this.executeAppleScript("appleScriptCloseCaminoWindow.txt", new String[]{url2});
                            if ("true".equals(caminoClosedAnyWindows)) {
                                closedAnyWindows = true;
                            } else if ("appquit".equals(caminoClosedAnyWindows)) {
                                closedAnyWindows = true;
                                runningApps = this.waitForMacAppQuit("Camino");
                            }
                        }
                        catch (IOException caminoClosedAnyWindows) {
                            // empty catch block
                        }
                    }
                    String[] macStandalonePlayerNames = new String[]{"Flash Player Debugger", "Flash Player", "SAFlashPlayer", "standalone"};
                    for (int i = 0; !closedAnyWindows && i < macStandalonePlayerNames.length; ++i) {
                        if (!runningApps.contains(macStandalonePlayerNames[i])) continue;
                        this.executeAppleScript(new String[]{"tell application \"" + macStandalonePlayerNames[i] + "\" to quit"}, null);
                        this.waitForMacAppQuit(macStandalonePlayerNames[i]);
                        closedAnyWindows = true;
                    }
                }
                if (this.m_process != null) {
                    try {
                        if (null != this.launcher) {
                            this.m_debuggerCallbacks.terminateDebugTarget(this.m_process, this.launcher);
                            break block25;
                        }
                        this.m_debuggerCallbacks.terminateDebugTarget(this.m_process);
                    }
                    catch (IOException iOException) {}
                }
            } else if (this.m_process != null) {
                try {
                    this.m_process.waitFor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.m_isConnected = false;
        this.m_isHalted = false;
    }

    private Set<String> waitForMacAppQuit(String browser) {
        Set<String> runningApps;
        boolean appClosed = true;
        long startMillis = System.currentTimeMillis();
        long waitMillis = 100L;
        do {
            if ((runningApps = this.runningApplications()).contains(browser)) {
                appClosed = false;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    return runningApps;
                }
                long currentMillis = System.currentTimeMillis();
                if (currentMillis - startMillis < 10000L) continue;
                break;
            }
            appClosed = true;
        } while (!appClosed);
        return runningApps;
    }

    @Override
    public void resume() throws NotSuspendedException, NotConnectedException, NoResponseException {
        this.resumeWorker(1);
    }

    @Override
    public void suspend() throws SuspendedException, NotConnectedException, NoResponseException {
        this.suspendWorker(1);
    }

    public DSuspendInfo getSuspendInfo() {
        return this.getSuspendInfoIsolate(1);
    }

    @Override
    public int suspendReason() {
        DSuspendInfo info = this.getSuspendInfo();
        return info.getReason();
    }

    public int getSuspendOffset() {
        DSuspendInfo info = this.getSuspendInfo();
        return info.getOffset();
    }

    public int getSuspendActionIndex() {
        DSuspendInfo info = this.getSuspendInfo();
        return info.getActionIndex();
    }

    @Override
    public SwfInfo[] getSwfs() throws NoResponseException {
        return this.getSwfsWorker(1);
    }

    public void requestSwfInfo(int at, int isolateId) throws NoResponseException {
        DMessage dm = DMessageCache.alloc(4);
        dm.setType(38);
        dm.setTargetIsolate(isolateId);
        dm.putWord(at);
        dm.putWord(0);
        int to = this.getPreference("$contextresponsetimeout");
        if (!this.simpleRequestResponseMessage(dm, 42, to)) {
            throw new NoResponseException(to);
        }
    }

    public byte[] getActions(int which, int at, int len) throws NoResponseException {
        byte[] actions = null;
        DMessage dm = DMessageCache.alloc(12);
        dm.setType(36);
        dm.putWord(which);
        dm.putWord(0);
        dm.putDWord(at);
        dm.putDWord(len);
        int to = this.getPreference("$contextresponsetimeout");
        if (!this.simpleRequestResponseMessage(dm, 41, to)) {
            throw new NoResponseException(to);
        }
        actions = this.m_manager.getActions();
        return actions;
    }

    @Override
    public void stepInto() throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.stepIntoWorker(1);
    }

    @Override
    public void stepOut() throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.stepOutWorker(1);
    }

    @Override
    public void stepOver() throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.stepOverWorker(1);
    }

    @Override
    public void stepContinue() throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (!this.isSuspended()) {
            throw new NotSuspendedException();
        }
        if (!this.simpleRequestResponseMessage(31, 17)) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
    }

    public void requestFunctionNames(int moduleId, int lineNbr, int isolateId) throws VersionException, NoResponseException {
        if (this.m_manager.getVersion() >= 9) {
            DMessage dm = DMessageCache.alloc(8);
            dm.setType(40);
            dm.setTargetIsolate(isolateId);
            dm.putDWord(moduleId);
            dm.putDWord(lineNbr);
            if (!this.simpleRequestResponseMessage(dm, 45)) {
                throw new NoResponseException(0);
            }
        } else {
            throw new VersionException();
        }
    }

    public SourceFile getFile(int fileId, int isolateId) {
        return this.m_manager.getSource(fileId, isolateId);
    }

    @Override
    public Location[] getBreakpointList() {
        return this.m_manager.getBreakpoints(1);
    }

    @Override
    public Location setBreakpoint(int fileId, int lineNum) throws NoResponseException, NotConnectedException {
        return this.setBreakpointWorker(fileId, lineNum, 1);
    }

    @Override
    public Location clearBreakpoint(Location local) {
        SourceFile source = local.getFile();
        int fileId = source.getId();
        int lineNum = local.getLine();
        int bp = DLocation.encodeId(fileId, lineNum);
        int isolateId = local.getIsolateId();
        DLocation l = null;
        l = this.m_manager.getBreakpoint(bp, isolateId);
        if (l != null) {
            int wideLineSize = 0;
            if (this.supportsWideLineNumbers()) {
                wideLineSize = 4;
            }
            DMessage dm = DMessageCache.alloc(8 + wideLineSize);
            dm.setType(18);
            dm.setTargetIsolate(isolateId);
            dm.putDWord(1);
            if (!this.supportsWideLineNumbers()) {
                dm.putDWord(bp);
            } else {
                dm.putDWord(fileId);
                dm.putDWord(lineNum);
            }
            this.sendMessage(dm);
            this.m_manager.removeBreakpoint(bp, isolateId);
        }
        return l;
    }

    @Override
    public Watch[] getWatchList() throws NoResponseException, NotConnectedException {
        return this.getWatchListWorker(1);
    }

    @Override
    public Watch[] getWatchListWorker(int isolateId) throws NoResponseException, NotConnectedException {
        return this.m_manager.getWatchpoints(isolateId);
    }

    private Watch setWatch(long varId, String memberName, int kind, int isolateId) throws NoResponseException, NotConnectedException, NotSupportedException {
        DWatch lastWatch;
        int count;
        int tag;
        DWatch w = null;
        if (this.addWatch(varId, memberName, kind, tag = this.m_watchTransactionTag++, isolateId) && (count = this.m_manager.getWatchpointCount(isolateId)) > 0 && (lastWatch = this.m_manager.getWatchpoint(count - 1, isolateId)).getTag() == tag) {
            w = lastWatch;
        }
        return w;
    }

    @Override
    public Watch setWatch(Value v, String memberName, int kind) throws NoResponseException, NotConnectedException, NotSupportedException {
        return this.setWatch(v.getId(), memberName, kind, v.getIsolateId());
    }

    @Override
    public Watch setWatch(Watch watch) throws NoResponseException, NotConnectedException, NotSupportedException {
        return this.setWatch(watch.getValueId(), watch.getMemberName(), watch.getKind(), watch.getIsolateId());
    }

    @Override
    public Watch clearWatch(Watch watch) throws NoResponseException, NotConnectedException {
        Watch[] list = this.getWatchListWorker(watch.getIsolateId());
        Watch w = null;
        if (this.removeWatch(watch.getValueId(), watch.getMemberName(), watch.getIsolateId()) && this.m_manager.getWatchpointCount(watch.getIsolateId()) < list.length) {
            Watch[] newList = this.getWatchListWorker(watch.getIsolateId());
            for (int i = 0; i < newList.length; ++i) {
                if (list[i] == newList[i]) continue;
                w = list[i];
                break;
            }
            if (w == null) {
                w = list[list.length - 1];
            }
        }
        return w;
    }

    @Override
    public Variable[] getVariableList() throws NotSuspendedException, NoResponseException, NotConnectedException, VersionException {
        return this.getVariableListWorker(1);
    }

    @Override
    public Variable[] getVariableListWorker(int isolateId) throws NotSuspendedException, NoResponseException, NotConnectedException, VersionException {
        if (!this.isWorkerSuspended(isolateId)) {
            throw new NotSuspendedException();
        }
        this.requestFrame(0, isolateId);
        this.getValueWorker(-2L, isolateId);
        this.getValueWorker(-3L, isolateId);
        this.getValueWorker(-4L, isolateId);
        int i = 0;
        Value v = null;
        do {
            v = this.getValueWorker(-300L - (long)i, isolateId);
        } while (i++ < 128 && v != null);
        v = this.m_manager.getValue(-100L, isolateId);
        if (v == null) {
            throw new VersionException();
        }
        return v.getMembers(this);
    }

    @Override
    public Frame[] getFrames() throws NotConnectedException {
        return this.m_manager.getFrames(1);
    }

    public void requestFrame(int depth, int isolateId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (this.playerSupportsGet()) {
            if (!this.isWorkerSuspended(isolateId)) {
                throw new NotSuspendedException();
            }
            int timeout = this.getPreference("$contextresponsetimeout");
            DMessage dm = DMessageCache.alloc(4);
            dm.setType(26);
            dm.setTargetIsolate(isolateId);
            dm.putDWord(depth);
            if (!this.simpleRequestResponseMessage(dm, 31, timeout)) {
                throw new NoResponseException(timeout);
            }
            this.pullUpActivationObjectVariables(depth, isolateId);
        }
    }

    private void pullUpActivationObjectVariables(int depth, int isolateId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        int i;
        DValue frame = this.m_manager.getValue(-100L - (long)depth, isolateId);
        if (frame == null) {
            return;
        }
        DStackContext context = this.m_manager.getFrame(depth, isolateId);
        DVariable[] frameVars = (DVariable[])frame.getMembers(this);
        LinkedHashMap<String, DVariable> varmap = new LinkedHashMap<String, DVariable>(frameVars.length);
        ArrayList<DVariable> activationObjects = new ArrayList<DVariable>();
        Pattern activationObjectNamePattern = Pattern.compile("^.*\\$\\d+$");
        for (i = 0; i < frameVars.length; ++i) {
            DVariable member = frameVars[i];
            Matcher matcher = activationObjectNamePattern.matcher(member.getName());
            if (matcher.matches()) {
                activationObjects.add(member);
                continue;
            }
            varmap.put(member.getName(), member);
        }
        if (activationObjects.size() == 0) {
            return;
        }
        for (i = 0; i < activationObjects.size(); ++i) {
            DVariable activationObject = (DVariable)activationObjects.get(i);
            DVariable[] activationMembers = (DVariable[])activationObject.getValue().getMembers(this);
            for (int j = 0; j < activationMembers.length; ++j) {
                DVariable member = activationMembers[j];
                int attributes = member.getAttributes();
                if ((attributes & 0x200000) != 0) continue;
                attributes &= 0xFC7FFFFF;
                member.setAttributes(attributes |= 0);
                String name = member.getName();
                DVariable oldvar = (DVariable)varmap.get(name);
                int vartype = oldvar != null ? oldvar.getAttributes() & 0x10020 : 32;
                member.setAttributes(member.getAttributes() | vartype);
                varmap.put(name, member);
            }
            context.convertLocalToActivationObject(activationObject);
        }
        for (DVariable var : varmap.values()) {
            frame.addMember(var);
            if (var.isAttributeSet(32)) {
                context.addLocal(var);
                continue;
            }
            if (!var.isAttributeSet(65536)) continue;
            if (var.getName().equals("this")) {
                context.setThis(var);
                continue;
            }
            context.addArgument(var);
        }
    }

    @Override
    public Value getValue(long valueId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        return this.getValueWorker(valueId, 1);
    }

    @Override
    public Value getValueWorker(long valueId, int isolateId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        DValue val = null;
        if (!this.isWorkerSuspended(isolateId)) {
            throw new NotSuspendedException();
        }
        val = this.m_manager.getValue(valueId, isolateId);
        if (val == null) {
            if (valueId < -1L) {
                this.requestFrame(0, isolateId);
            } else if (valueId > -1L) {
                this.requestVariable(valueId, null, isolateId);
            }
            val = this.m_manager.getValue(valueId, isolateId);
        }
        return val;
    }

    public Value getRawValue(long valueId, int isolateId) {
        return this.m_manager.getValue(valueId, isolateId);
    }

    public Value getPreviousValue(long valueId, int isolateId) {
        return this.m_manager.getPreviousValue(valueId, isolateId);
    }

    void obtainMembers(long valueId, int isolateId) throws NoResponseException, NotConnectedException, NotSuspendedException {
        if (!this.isWorkerSuspended(isolateId)) {
            throw new NotSuspendedException();
        }
        DValue v = this.m_manager.getValue(valueId, isolateId);
        if (v != null && !v.membersObtained()) {
            this.requestVariable(valueId, null, false, true, isolateId);
        }
    }

    @Override
    public Value getGlobal(String name) throws NotSuspendedException, NoResponseException, NotConnectedException {
        return this.getGlobalWorker(name, 1);
    }

    @Override
    public Value getGlobalWorker(String name, int isolateId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        Value v = this.getValue(0L, name, isolateId);
        if (v == null || v.getType() == 7) {
            return null;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value getValue(long varId, String name, int isolateId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        void var5_9;
        Object var5_4 = null;
        if (!this.isWorkerSuspended(isolateId)) throw new NotSuspendedException();
        int fireGetter = this.getPreference("$invokegetters");
        this.m_manager.clearLastVariable(isolateId);
        this.m_manager.enableChildAttach(false, isolateId);
        try {
            this.requestVariable(varId, name, fireGetter != 0, false, isolateId);
            DVariable lastVariable = this.m_manager.lastVariable(isolateId);
            if (lastVariable != null) {
                Value value = lastVariable.getValue();
                return var5_9;
            } else {
                DValue dValue = DValue.forPrimitive(Value.UNDEFINED, isolateId);
            }
            return var5_9;
        }
        catch (NoResponseException e) {
            if (fireGetter == 0) throw e;
            DValue dValue = new DValue(2, "String", "String", 262144, e.getLocalizedMessage(), isolateId);
            if (varId == 0L) return var5_9;
            DVariable var = new DVariable(name, dValue, isolateId);
            this.m_manager.enableChildAttach(true, isolateId);
            this.m_manager.addVariableMember(varId, var, isolateId);
            return var5_9;
        }
        finally {
            this.m_manager.enableChildAttach(true, isolateId);
        }
    }

    private void requestVariable(long id, String name, int isolateId) throws NoResponseException, NotConnectedException, NotSuspendedException {
        this.requestVariable(id, name, false, false, isolateId);
    }

    private Value callFunction(Value thisValue, boolean isConstructor, String funcname, Value[] args, int isolateId) throws PlayerDebugException {
        if (!this.isWorkerSuspended(isolateId)) {
            throw new NotSuspendedException();
        }
        if (!this.playerCanCallFunctions(isolateId)) {
            throw new NotSupportedException(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("functionCallsNotSupported"));
        }
        this.m_manager.clearLastFunctionCall(isolateId);
        DMessage dm = this.buildCallFunctionMessage(isConstructor, thisValue, funcname, args);
        dm.setTargetIsolate(isolateId);
        this.m_manager.beginPlayerCodeExecution(isolateId);
        int timeout = this.getPreference("$getvarresponsetimeout");
        boolean result = this.simpleRequestResponseMessage(dm, 54, timeout += 500);
        this.m_manager.endPlayerCodeExecution(isolateId);
        if (!result) {
            throw new NoResponseException(timeout);
        }
        DVariable lastFunctionCall = this.m_manager.lastFunctionCall(isolateId);
        if (lastFunctionCall != null) {
            return lastFunctionCall.getValue();
        }
        return DValue.forPrimitive(Value.UNDEFINED, isolateId);
    }

    @Override
    public Value callFunction(Value thisValue, String funcname, Value[] args) throws PlayerDebugException {
        return this.callFunctionWorker(thisValue, funcname, args, 1);
    }

    @Override
    public Value callFunctionWorker(Value thisValue, String funcname, Value[] args, int isolateId) throws PlayerDebugException {
        Value retval = this.callPseudoFunction(thisValue, funcname, args, isolateId);
        if (retval != null) {
            return retval;
        }
        return this.callFunction(thisValue, false, funcname, args, isolateId);
    }

    private Value callPseudoFunction(Value thisValue, String funcname, Value[] args, int isolateId) throws PlayerDebugException {
        if ((thisValue.getType() == 7 || thisValue.getType() == 6) && "$obj".equals(funcname)) {
            return this.callObjPseudoFunction(args, isolateId);
        }
        return null;
    }

    private Value callObjPseudoFunction(Value[] args, int isolateId) throws PlayerDebugException {
        if (args.length != 1) {
            return DValue.forPrimitive(DValue.UNDEFINED, isolateId);
        }
        double arg = ECMA.toNumber(this, args[0]);
        long id = (long)arg;
        if ((double)id != arg) {
            return DValue.forPrimitive(DValue.UNDEFINED, isolateId);
        }
        DValue value = this.m_manager.getValue(id, isolateId);
        if (value == null) {
            return DValue.forPrimitive(DValue.UNDEFINED, isolateId);
        }
        return value;
    }

    @Override
    public Value callConstructor(String funcname, Value[] args) throws PlayerDebugException {
        return this.callConstructorWorker(funcname, args, 1);
    }

    @Override
    public Value callConstructorWorker(String funcname, Value[] args, int isolateId) throws PlayerDebugException {
        return this.callFunction(DValue.forPrimitive(null, isolateId), true, funcname, args, isolateId);
    }

    private DMessage buildCallFunctionMessage(boolean isConstructor, Value thisValue, String funcname, Value[] args) {
        funcname = funcname == null ? "" : funcname;
        int messageSize = 8;
        String thisType = DVariable.typeNameFor(thisValue.getType());
        String thisValueString = thisValue.getValueAsString();
        messageSize += DMessage.getStringLength(thisType) + 1;
        messageSize += DMessage.getStringLength(thisValueString) + 1;
        messageSize += DMessage.getStringLength(funcname) + 1;
        messageSize += 4;
        String[] argTypes = new String[args.length];
        String[] argValues = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = DVariable.typeNameFor(args[i].getType());
            argValues[i] = args[i].getValueAsString();
            messageSize += DMessage.getStringLength(argValues[i]) + 1;
            messageSize += DMessage.getStringLength(argTypes[i]) + 1;
        }
        DMessage dm = DMessageCache.alloc(messageSize);
        dm.setType(48);
        try {
            dm.putDWord(isConstructor ? 1 : 0);
            dm.putDWord(0);
            dm.putString(thisType);
            dm.putString(thisValueString);
            dm.putString(funcname);
            dm.putDWord(args.length);
            for (int i = 0; i < args.length; ++i) {
                dm.putString(argTypes[i]);
                dm.putString(argValues[i]);
            }
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        return dm;
    }

    private void requestVariable(long id, String name, boolean fireGetter, boolean alsoGetChildren, int isolateId) throws NoResponseException, NotConnectedException, NotSuspendedException {
        if (!this.isWorkerSuspended(isolateId)) {
            throw new NotSuspendedException();
        }
        name = this.getRawMemberName(id, name, isolateId);
        DMessage dm = this.buildOutGetMessage(id, name, fireGetter, alsoGetChildren);
        dm.setTargetIsolate(isolateId);
        this.m_manager.beginPlayerCodeExecution(isolateId);
        int timeout = this.getPreference("$getvarresponsetimeout");
        boolean result = this.simpleRequestResponseMessage(dm, 30, timeout += 500);
        this.m_manager.endPlayerCodeExecution(isolateId);
        if (!result) {
            throw new NoResponseException(timeout);
        }
    }

    private DMessage buildOutGetMessage(long id, String name, boolean fireGetter, boolean alsoGetChildren) {
        int FLAGS_SIZE = 4;
        name = name == null ? "" : name;
        DMessage dm = DMessageCache.alloc(DMessage.getSizeofPtr() + DMessage.getStringLength(name) + 1 + 4);
        dm.setType(!fireGetter ? 25 : 34);
        dm.putPtr(id);
        try {
            dm.putString(name);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        int flags = 4;
        if (fireGetter) {
            flags |= 1;
        }
        if (alsoGetChildren) {
            flags |= 0xA;
        }
        dm.putDWord(flags);
        return dm;
    }

    public FaultEvent setScalarMember(long varId, String memberName, int type, String value, int isolateId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        int depth;
        DStackContext context;
        DVariable activationObject;
        if (!this.isWorkerSuspended(isolateId)) {
            throw new NotSuspendedException();
        }
        if (varId <= -100L && varId > -300L && (activationObject = (context = this.m_manager.getFrame(depth = (int)(-100L - varId), isolateId)).getActivationObject()) != null) {
            varId = activationObject.getValue().getId();
        }
        memberName = this.getRawMemberName(varId, memberName, isolateId);
        FaultEvent faultEvent = this.requestSetVariable(this.isPseudoVarId(varId) ? 0L : varId, memberName, type, value, isolateId);
        if (this.isPseudoVarId(varId) && this.m_manager.getFrameCount(isolateId) > 0) {
            this.m_manager.getFrame(0, isolateId).markStale();
        } else {
            DValue parent = this.m_manager.getValue(varId, isolateId);
            if (parent != null) {
                parent.removeAllMembers();
            }
        }
        return faultEvent;
    }

    private boolean isPseudoVarId(long varId) {
        return varId < 0L && varId > -65535L;
    }

    private String getRawMemberName(long parentValueId, String memberName, int isolateId) {
        int doubleColon;
        String shortName;
        DVariable member;
        DValue parent;
        if (memberName != null && (parent = this.m_manager.getValue(parentValueId, isolateId)) != null && (member = parent.findMember(shortName = (doubleColon = memberName.indexOf("::")) == -1 ? memberName : memberName.substring(doubleColon + 2))) != null) {
            memberName = member.getRawName();
        }
        return memberName;
    }

    private FaultEvent requestSetVariable(long id, String name, int t, String value, int isolateId) throws NoResponseException {
        String type = DVariable.typeNameFor(t);
        DMessage dm = this.buildOutSetMessage(id, name, type, value);
        dm.setTargetIsolate(isolateId);
        FaultEvent faultEvent = null;
        this.m_manager.beginPlayerCodeExecution(isolateId);
        this.sendSquelch(false, isolateId);
        int timeout = this.getPreference("$getvarresponsetimeout");
        if (!this.simpleRequestResponseMessage(dm, t == 2 ? 10 : 28, timeout)) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
        this.sendSquelch(true, isolateId);
        faultEvent = this.m_manager.endPlayerCodeExecution(isolateId);
        this.m_manager.freeValueCache(isolateId);
        return faultEvent;
    }

    private DMessage buildOutSetMessage(long id, String name, String type, String v) {
        DMessage dm = DMessageCache.alloc(DMessage.getSizeofPtr() + DMessage.getStringLength(name) + DMessage.getStringLength(type) + DMessage.getStringLength(v) + 3);
        dm.setType(11);
        dm.putPtr(id);
        try {
            dm.putString(name);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        try {
            dm.putString(type);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        try {
            dm.putString(v);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        return dm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForEvent() throws NotConnectedException, InterruptedException {
        Object eventNotifier;
        Object object = eventNotifier = this.m_manager.getEventNotifier();
        synchronized (object) {
            while (this.getEventCount() == 0 && this.isConnected()) {
                eventNotifier.wait();
            }
        }
        if (this.getEventCount() == 0 && !this.isConnected()) {
            throw new NotConnectedException();
        }
    }

    @Override
    public int getEventCount() {
        return this.m_manager.getEventCount();
    }

    @Override
    public DebugEvent nextEvent() {
        return this.m_manager.nextEvent();
    }

    public boolean addWatch(long varId, String varName, int type, int tag, int isolateId) throws NoResponseException, NotConnectedException, NotSupportedException {
        if (!this.supportsWatchpoints(isolateId)) {
            throw new NotSupportedException(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("watchpointsNotSupported"));
        }
        varName = this.getRawMemberName(varId, varName, isolateId);
        DMessage dm = DMessageCache.alloc(4 + DMessage.getSizeofPtr() + DMessage.getStringLength(varName) + 1);
        dm.setType(49);
        dm.setTargetIsolate(isolateId);
        dm.putPtr(varId);
        try {
            dm.putString(varName);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        dm.putWord(type);
        dm.putWord(tag);
        int timeout = this.getPreference("$getvarresponsetimeout");
        boolean result = this.simpleRequestResponseMessage(dm, 55, timeout);
        return result;
    }

    public boolean removeWatch(long varId, String memberName, int isolateId) throws NoResponseException, NotConnectedException {
        memberName = this.getRawMemberName(varId, memberName, isolateId);
        DMessage dm = DMessageCache.alloc(DMessage.getSizeofPtr() + DMessage.getStringLength(memberName) + 1);
        dm.setType(50);
        dm.putPtr(varId);
        try {
            dm.putString(memberName);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        int timeout = this.getPreference("$getvarresponsetimeout");
        boolean result = this.simpleRequestResponseMessage(dm, 55, timeout);
        return result;
    }

    void sendMessage(int message) {
        DMessage dm = DMessageCache.alloc(0);
        dm.setType(message);
        this.sendMessage(dm);
    }

    void sendMessageIsolate(int message, int isolateId) {
        DMessage dm = DMessageCache.alloc(0);
        dm.setTargetIsolate(isolateId);
        dm.setType(message);
        this.sendMessage(dm);
    }

    synchronized void sendMessage(DMessage dm) {
        block4: {
            try {
                int isolate;
                if (dm.getType() != 54 && (isolate = dm.getTargetIsolate()) != this.getActiveIsolate().getId()) {
                    DMessage dm1 = DMessageCache.alloc(4);
                    dm1.setTargetIsolate(isolate);
                    dm1.setType(54);
                    dm1.putDWord(isolate);
                    this.sendMessage(dm1);
                    this.m_manager.setActiveIsolate(this.m_manager.getIsolate(isolate));
                }
                this.m_protocol.txMessage(dm);
                if (m_debugMsgOn || m_debugMsgFileOn) {
                    this.trace(dm, false);
                }
            }
            catch (IOException io) {
                if (!Trace.error) break block4;
                Trace.trace((String)("Attempt to send message " + dm.outToString() + " failed"));
                io.printStackTrace();
            }
        }
        DMessageCache.free(dm);
    }

    boolean sendSquelch(boolean on, int isolateId) {
        DMessage dm = DMessageCache.alloc(4);
        dm.setType(24);
        dm.setTargetIsolate(isolateId);
        dm.putDWord(on ? 1 : 0);
        boolean responded = this.simpleRequestResponseMessage(dm, 29);
        return responded;
    }

    void sendStopWarning() {
        String option = "disable_script_stuck_dialog";
        String value = "on";
        this.sendOptionMessage(option, value);
        option = "disable_script_stuck";
        value = "on";
        this.sendOptionMessage(option, value);
    }

    void sendStopOnFault() {
        String option = "break_on_fault";
        String value = "on";
        this.sendOptionMessage(option, value);
    }

    void sendEnumerateOverride() {
        String option = "enumerate_override";
        String value = "on";
        this.sendOptionMessage(option, value);
    }

    void sendFailureNotify() {
        String option = "notify_on_failure";
        String value = "on";
        this.sendOptionMessage(option, value);
    }

    void sendInvokeSetters() {
        String option = "invoke_setters";
        String value = "on";
        this.sendOptionMessage(option, value);
    }

    void sendSwfloadNotify() {
        String option = "swf_load_messages";
        String value = "on";
        this.sendOptionMessage(option, value);
    }

    void sendConsoleErrorsAsTrace(boolean on) {
        String option = "console_errors";
        String value = on ? "on" : "off";
        this.sendOptionMessage(option, value);
    }

    void sendGetterTimeout() {
        String option = "getter_timeout";
        String value = "" + this.getPreference("$getvarresponsetimeout");
        this.sendOptionMessage(option, value);
    }

    void sendSetterTimeout() {
        String option = "setter_timeout";
        String value = "" + this.getPreference("$setvarresponsetimeout");
        this.sendOptionMessage(option, value);
    }

    void sendConcurrentDebugger() {
        String option = "concurrent_debugger";
        String value = "on";
        this.sendOptionMessage(option, value);
    }

    void sendWideLineDebugger() {
        String option = "wide_line_debugger";
        String value = "on";
        this.sendOptionMessage(option, value);
        this.m_manager.setWideLines(true);
    }

    void sendOptionMessage(String option, String value) {
        int msgSize = DMessage.getStringLength(option) + DMessage.getStringLength(value) + 2;
        DMessage dm = DMessageCache.alloc(msgSize);
        dm.setType(28);
        try {
            dm.putString(option);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        try {
            dm.putString(value);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        this.simpleRequestResponseMessage(dm, 32);
    }

    @Override
    public boolean supportsWatchpoints() {
        return this.supportsWatchpoints(1);
    }

    @Override
    public boolean supportsWatchpoints(int isolateId) {
        if (this.m_playerSupportsWatchpoints == null) {
            this.m_playerSupportsWatchpoints = this.getOption("can_set_watchpoints", false, isolateId);
        }
        return this.m_playerSupportsWatchpoints;
    }

    public boolean playerCanBreakOnAllExceptions() {
        return this.playerCanBreakOnAllExceptions(1);
    }

    @Override
    public boolean playerCanBreakOnAllExceptions(int isolateId) {
        if (this.m_playerCanBreakOnAllExceptions == null) {
            this.m_playerCanBreakOnAllExceptions = this.getOption("can_break_on_all_exceptions", false, isolateId);
        }
        return this.m_playerCanBreakOnAllExceptions;
    }

    public boolean supportsConcurrency(int isolateId) {
        if (this.m_playerSupportsConcurrency == null) {
            this.m_playerSupportsConcurrency = this.getOption("concurrent_player", false, isolateId);
        }
        return this.m_playerSupportsConcurrency;
    }

    @Override
    public boolean supportsConcurrency() {
        return this.supportsConcurrency(1);
    }

    public boolean supportsWideLineNumbers() {
        return this.supportsWideLineNumbers(1);
    }

    @Override
    public boolean supportsWideLineNumbers(int isolateId) {
        if (this.m_playerSupportsWideLine == null) {
            this.m_playerSupportsWideLine = this.getOption("wide_line_player", false, isolateId);
        }
        return this.m_playerSupportsWideLine;
    }

    public boolean playerCanTerminate() {
        return this.getOption("can_terminate", false, 1);
    }

    public boolean playerCanCallFunctions() {
        return this.playerCanCallFunctions(1);
    }

    @Override
    public boolean playerCanCallFunctions(int isolateId) {
        if (this.m_playerCanCallFunctions == null) {
            this.m_playerCanCallFunctions = this.getOption("can_call_functions", false, isolateId);
        }
        return this.m_playerCanCallFunctions;
    }

    public boolean getOption(String optionName, boolean defaultValue, int isolateId) {
        boolean retval = defaultValue;
        String optionValue = this.getOption(optionName, null, isolateId);
        if (optionValue != null) {
            retval = Boolean.valueOf(optionValue);
        }
        return retval;
    }

    public String getOption(String optionName, String defaultValue, int isolateId) {
        String optionValue = defaultValue;
        int msgSize = DMessage.getStringLength(optionName) + 1;
        DMessage dm = DMessageCache.alloc(msgSize);
        dm.setTargetIsolate(isolateId);
        dm.setType(27);
        try {
            dm.putString(optionName);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        if (this.simpleRequestResponseMessage(dm, 32)) {
            optionValue = this.m_manager.getOption(optionName);
        }
        return optionValue;
    }

    long getMessageInCount(DMessageCounter counter, long isolate, int msgType) {
        if (isolate == 1L) {
            return counter.getInCount(msgType);
        }
        return counter.getIsolateInCount(isolate, msgType);
    }

    Object getMessageInLock(DMessageCounter counter, long isolate) {
        if (isolate == 1L) {
            return counter.getInLock();
        }
        return counter.getIsolateInLock(isolate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean simpleRequestResponseMessage(DMessage msg, int msgType, int timeout) {
        boolean response = false;
        timeout = timeout > 0 ? timeout : this.getPreference("$responsetimeout");
        DMessageCounter msgCounter = this.getMessageCounter();
        int isolate = msg.getTargetIsolate();
        long num = this.getMessageInCount(msgCounter, isolate, msgType);
        long expect = num + 1L;
        this.sendMessage(msg);
        long startTime = System.currentTimeMillis();
        this.m_incoming = false;
        Object object = this.getMessageInLock(msgCounter, isolate);
        synchronized (object) {
            while (expect > this.getMessageInCount(msgCounter, isolate, msgType) && System.currentTimeMillis() < startTime + (long)timeout && this.isConnected()) {
                try {
                    this.getMessageInLock(msgCounter, isolate).wait(timeout);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                PlayerSession playerSession = this;
                synchronized (playerSession) {
                    if (this.m_incoming) {
                        startTime = System.currentTimeMillis();
                        this.m_incoming = false;
                    }
                }
            }
        }
        if (this.getMessageInCount(msgCounter, isolate, msgType) >= expect) {
            response = true;
        } else if (timeout <= 0 && Trace.error) {
            Trace.trace((String)("Timed-out waiting for " + DMessage.inTypeName(msgType) + " response to message " + msg.outToString()));
        }
        this.m_lastResponse = response;
        return response;
    }

    boolean simpleRequestResponseMessage(DMessage msg, int msgType) {
        return this.simpleRequestResponseMessage(msg, msgType, -1);
    }

    boolean simpleRequestResponseMessageIsolate(DMessage msg, int msgType, int isolateId) {
        return this.simpleRequestResponseMessageIsolate(msg, msgType, -1, isolateId);
    }

    boolean simpleRequestResponseMessageIsolate(DMessage msg, int msgType, int timeout, int isolateId) {
        msg.setTargetIsolate(isolateId);
        return this.simpleRequestResponseMessage(msg, msgType, timeout);
    }

    boolean simpleRequestResponseMessage(int msg, int msgType) {
        return this.simpleRequestResponseMessage(msg, msgType, -1);
    }

    boolean simpleRequestResponseMessageIsolate(int msg, int msgType, int isolateId) {
        return this.simpleRequestResponseMessageIsolate(msg, msgType, -1, isolateId);
    }

    boolean simpleRequestResponseMessageIsolate(int msg, int msgType, int timeout, int isolateId) {
        DMessage dm = DMessageCache.alloc(0);
        dm.setType(msg);
        dm.setTargetIsolate(isolateId);
        return this.simpleRequestResponseMessage(dm, msgType, timeout);
    }

    boolean simpleRequestResponseMessage(int msg, int msgType, int timeout) {
        DMessage dm = DMessageCache.alloc(0);
        dm.setType(msg);
        return this.simpleRequestResponseMessage(dm, msgType, timeout);
    }

    @Override
    public void disconnected() {
        this.m_isHalted = false;
        this.m_isConnected = false;
        this.m_manager.disconnected();
    }

    @Override
    public void messageArrived(DMessage msg, DProtocol which) {
        this.preMessageArrived(msg, which);
        msg.reset();
        this.m_manager.messageArrived(msg, which);
        msg.reset();
        this.postMessageArrived(msg, which);
    }

    private void preMessageArrived(DMessage msg, DProtocol which) {
        switch (msg.getType()) {
            case 62: {
                this.m_lastPreIsolate = (int)msg.getDWord();
                break;
            }
            case 15: 
            case 16: 
            case 27: {
                if (this.m_lastPreIsolate == 1) {
                    this.m_isHalted = true;
                    break;
                }
                this.updateHaltIsolateStatus(this.m_lastPreIsolate, true);
            }
        }
    }

    private void postMessageArrived(DMessage msg, DProtocol which) {
        if (m_debugMsgOn || m_debugMsgFileOn) {
            this.trace(msg, true);
        }
        int type = msg.getType();
        switch (type) {
            case 2: {
                this.m_isConnected = false;
                break;
            }
            case 25: {
                this.sendMessageIsolate(23, msg.getTargetIsolate());
                break;
            }
            case 17: {
                if (msg.getTargetIsolate() == 1) {
                    this.m_isHalted = false;
                    break;
                }
                this.updateHaltIsolateStatus(msg.getTargetIsolate(), false);
                break;
            }
            case 32: {
                if (msg.getTargetIsolate() != 1) break;
                String s = msg.getString();
                String v = msg.getString();
                this.m_prefs.put(s, v);
                break;
            }
            case 14: 
            case 21: 
            case 42: {
                this.m_evalIsAndInstanceofCache.clear();
                this.m_incoming = true;
                break;
            }
            default: {
                this.m_incoming = true;
            }
        }
        this.m_lastResponse = true;
    }

    private void updateHaltIsolateStatus(int targetIsolate, boolean value) {
        if (!this.m_isolateStatus.containsKey(targetIsolate)) {
            PlayerSessionIsolateStatus status = new PlayerSessionIsolateStatus();
            status.m_isHalted = value;
            this.m_isolateStatus.put(targetIsolate, status);
        } else {
            this.m_isolateStatus.get((Object)Integer.valueOf((int)targetIsolate)).m_isHalted = value;
        }
    }

    @Override
    public void run() {
        long last = 0L;
        while (this.isConnected()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                long current = this.m_protocol.messagesReceived();
                long delta = last - current;
                last = current;
                if (!this.m_lastResponse || !this.isSuspended() && delta > 5L) {
                    throw new NotSuspendedException();
                }
                for (DIsolate isolate : this.m_manager.getIsolates()) {
                    int isolateId = isolate.getId();
                    if (isolateId != 1 && !this.isWorkerSuspended(isolateId) && delta > 5L) {
                        throw new NotSuspendedException();
                    }
                    int count = this.m_manager.getSwfInfoCount(isolateId);
                    for (int i = 0; i < count; ++i) {
                        DSwfInfo info = this.m_manager.getSwfInfo(i, isolateId);
                        if (info == null || info.isUnloaded() || info.isPopulated() || info.getVmVersion() > 0) continue;
                        info.getSwdSize(this);
                        if (info.getVmVersion() > 0) {
                            info.setPopulated();
                            continue;
                        }
                        if (info.isSwdLoading() || info.isUnloaded()) continue;
                        if (info.getSwf() == null && !info.isUnloaded()) {
                            info.setSwf(this.requestSwf(i));
                        }
                        if (info.getSwd() == null && !info.isUnloaded()) {
                            info.setSwd(this.requestSwd(i));
                        }
                        try {
                            if (info.isUnloaded()) continue;
                            info.parseSwfSwd(this.m_manager);
                            continue;
                        }
                        catch (Exception e) {
                            if (Trace.error) {
                                Trace.trace((String)("Error while parsing swf/swd '" + info.getUrl() + "'. Giving up and marking it processed"));
                                e.printStackTrace();
                            }
                            info.setPopulated();
                        }
                    }
                }
            }
            catch (InProgressException current) {
            }
            catch (NoResponseException current) {
            }
            catch (NotSuspendedException current) {
            }
            catch (Exception e) {
                if (!Trace.error) continue;
                Trace.trace((String)"Exception in background swf/swd processing thread");
                e.printStackTrace();
            }
        }
    }

    byte[] requestSwf(int index) throws NoResponseException {
        int to = this.getPreference("$swfswdloadtimeout");
        byte[] swf = null;
        DMessage dm = DMessageCache.alloc(2);
        dm.setType(32);
        dm.putWord(index);
        if (!this.simpleRequestResponseMessage(dm, 34, to)) {
            throw new NoResponseException(to);
        }
        swf = this.m_manager.getSWF();
        return swf;
    }

    byte[] requestSwd(int index) throws NoResponseException {
        int to = this.getPreference("$swfswdloadtimeout");
        byte[] swd = null;
        DMessage dm = DMessageCache.alloc(2);
        dm.setType(33);
        dm.putWord(index);
        if (!this.simpleRequestResponseMessage(dm, 35, to)) {
            throw new NoResponseException(to);
        }
        swd = this.m_manager.getSWD();
        return swd;
    }

    synchronized void trace(DMessage dm, boolean in) {
        try {
            if (m_debugMsgOn) {
                System.out.println(in ? dm.inToString(this.m_debugMsgSize) : dm.outToString(this.m_debugMsgSize));
            }
            if (m_debugMsgFileOn) {
                this.traceFile().write(in ? dm.inToString(this.m_debugMsgFileSize) : dm.outToString(this.m_debugMsgFileSize));
                this.m_trace.write(s_newline);
                this.m_trace.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Writer traceFile() throws IOException {
        if (this.m_trace == null) {
            block6: {
                this.m_trace = new FileWriter("mm_debug_api_trace.txt");
                try {
                    this.m_trace.write(new Date().toString());
                }
                catch (Exception e) {
                    this.m_trace.write("Date unknown");
                }
                try {
                    this.m_trace.write(s_newline);
                    Properties props = System.getProperties();
                    props.list(new PrintWriter(this.m_trace));
                    this.m_trace.write(s_newline);
                    for (String key : this.m_prefs.keySet()) {
                        Object value = this.m_prefs.get(key);
                        this.m_trace.write(key);
                        this.m_trace.write(" = ");
                        this.m_trace.write(value.toString());
                        this.m_trace.write(s_newline);
                    }
                }
                catch (Exception e) {
                    if (!Trace.error) break block6;
                    e.printStackTrace();
                }
            }
            this.m_trace.write(s_newline);
        }
        return this.m_trace;
    }

    public void setLaunchUrl(String url) {
        if (((String)url).startsWith("/")) {
            url = "file://" + (String)url;
        }
        this.m_launchUrl = url;
    }

    public void setAIRLaunchInfo(AIRLaunchInfo airLaunchInfo) {
        this.m_airLaunchInfo = airLaunchInfo;
    }

    @Override
    public void breakOnCaughtExceptions(boolean b) throws NotSupportedException, NoResponseException {
        this.breakOnCaughtExceptions(b, 1);
    }

    @Override
    public void breakOnCaughtExceptions(boolean b, int isolateId) throws NotSupportedException, NoResponseException {
        if (!this.playerCanBreakOnAllExceptions(isolateId)) {
            throw new NotSupportedException(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("exceptionBreakpointsNotSupported"));
        }
        DMessage dm = DMessageCache.alloc(1);
        dm.setType(51);
        dm.putByte((byte)(b ? 1 : 0));
        dm.setTargetIsolate(isolateId);
        if (!this.simpleRequestResponseMessage(dm, 56)) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
    }

    @Override
    public boolean evalIs(Value value, Value type) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Is, value, type, 1);
    }

    @Override
    public boolean evalIs(Value value, String type) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Is, value, type, 1);
    }

    @Override
    public boolean evalInstanceof(Value value, Value type) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Instanceof, value, type, 1);
    }

    @Override
    public boolean evalInstanceof(Value value, String type) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Instanceof, value, type, 1);
    }

    @Override
    public boolean evalIsWorker(Value value, Value type, int isolateId) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Is, value, type, isolateId);
    }

    @Override
    public boolean evalIsWorker(Value value, String type, int isolateId) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Is, value, type, isolateId);
    }

    @Override
    public boolean evalInstanceofWorker(Value value, Value type, int isolateId) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Instanceof, value, type, isolateId);
    }

    @Override
    public boolean evalInstanceofWorker(Value value, String type, int isolateId) throws PlayerDebugException, PlayerFaultException {
        return this.evalIsOrInstanceof(BinaryOp.Instanceof, value, type, isolateId);
    }

    private boolean evalIsOrInstanceof(BinaryOp op, Value value, Value type, int isolateId) throws PlayerDebugException, PlayerFaultException {
        String key = value.getTypeName() + " " + op + " " + type.getTypeName() + " " + String.valueOf(isolateId);
        Boolean retval = this.m_evalIsAndInstanceofCache.get(key);
        if (retval == null) {
            retval = ECMA.toBoolean(this.evalBinaryOp(op, value, type, isolateId));
            this.m_evalIsAndInstanceofCache.put(key, retval);
        }
        return retval;
    }

    private boolean evalIsOrInstanceof(BinaryOp op, Value value, String type, int isolateId) throws PlayerDebugException, PlayerFaultException {
        String key = value.getTypeName() + " " + op + " " + type + " " + String.valueOf(isolateId);
        Boolean retval = this.m_evalIsAndInstanceofCache.get(key);
        if (retval == null) {
            Value typeval = this.getGlobalWorker(type, isolateId);
            retval = typeval == null ? Boolean.FALSE : Boolean.valueOf(ECMA.toBoolean(this.evalBinaryOp(op, value, typeval, isolateId)));
            this.m_evalIsAndInstanceofCache.put(key, retval);
        }
        return retval;
    }

    @Override
    public boolean evalIn(Value property, Value object) throws PlayerDebugException, PlayerFaultException {
        return ECMA.toBoolean(this.evalBinaryOp(BinaryOp.In, property, object, 1));
    }

    @Override
    public Value evalAs(Value value, Value type) throws PlayerDebugException, PlayerFaultException {
        return this.evalBinaryOp(BinaryOp.As, value, type, 1);
    }

    private Value evalBinaryOp(BinaryOp op, Value lhs, Value rhs, int isolateId) throws PlayerDebugException, PlayerFaultException {
        if (!this.isWorkerSuspended(isolateId)) {
            throw new NotSuspendedException();
        }
        if (!this.playerCanCallFunctions(isolateId)) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("operator", op.getName());
            String message = PlayerSessionManager.getLocalizationManager().getLocalizedTextString("operatorNotSupported", parameters);
            throw new NotSupportedException(message);
        }
        int id = (int)(Math.random() * 65536.0);
        DMessage dm = this.buildBinaryOpMessage(id, op, lhs, rhs);
        dm.setTargetIsolate(isolateId);
        this.m_manager.clearLastBinaryOp(isolateId);
        this.m_manager.beginPlayerCodeExecution(isolateId);
        int timeout = this.getPreference("$getvarresponsetimeout");
        boolean result = this.simpleRequestResponseMessage(dm, 57, timeout += 500);
        this.m_manager.endPlayerCodeExecution(isolateId);
        if (!result) {
            throw new NoResponseException(timeout);
        }
        DVariable lastBinaryOp = this.m_manager.lastBinaryOp(isolateId);
        Value v = lastBinaryOp != null ? lastBinaryOp.getValue() : DValue.forPrimitive(Value.UNDEFINED, isolateId);
        if (v.isAttributeSet(262144)) {
            throw new PlayerFaultException(new ExceptionFault(v.getValueAsString(), false, v, isolateId));
        }
        return v;
    }

    private DMessage buildBinaryOpMessage(int id, BinaryOp op, Value lhs, Value rhs) {
        int messageSize = 5;
        String lhsType = DVariable.typeNameFor(lhs.getType());
        String lhsValueString = lhs.getValueAsString();
        String rhsType = DVariable.typeNameFor(rhs.getType());
        String rhsValueString = rhs.getValueAsString();
        messageSize += DMessage.getStringLength(lhsType) + 1;
        messageSize += DMessage.getStringLength(lhsValueString) + 1;
        messageSize += DMessage.getStringLength(rhsType) + 1;
        DMessage dm = DMessageCache.alloc(messageSize += DMessage.getStringLength(rhsValueString) + 1);
        dm.setType(52);
        try {
            dm.putDWord(id);
            dm.putByte((byte)op.getValue());
            dm.putString(lhsType);
            dm.putString(lhsValueString);
            dm.putString(rhsType);
            dm.putString(rhsValueString);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        return dm;
    }

    @Override
    public Exception getDisconnectCause() {
        if (this.m_protocol != null) {
            return this.m_protocol.getDisconnectCause();
        }
        return null;
    }

    @Override
    public Isolate[] refreshWorkers() throws NotSupportedException, NotSuspendedException, NoResponseException, NotConnectedException {
        if (!this.supportsConcurrency()) {
            throw new NotSupportedException(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("concurrencyNotSupported"));
        }
        if (!this.isSuspended()) {
            throw new NotSuspendedException();
        }
        boolean response = this.simpleRequestResponseMessage(53, 60);
        if (response) {
            return this.m_manager.getIsolates();
        }
        return null;
    }

    private Isolate getActiveIsolate() {
        return this.m_manager.getActiveIsolate();
    }

    @Override
    public Isolate[] getWorkers() {
        return this.m_manager.getIsolates();
    }

    @Override
    public void resumeWorker(int isolateId) throws NotSuspendedException, NotConnectedException, NoResponseException {
        if (!this.isWorkerSuspended(isolateId)) {
            throw new NotSuspendedException();
        }
        if (!this.simpleRequestResponseMessageIsolate(15, 17, isolateId)) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
    }

    @Override
    public int suspendReasonWorker(int isolateId) throws NotConnectedException {
        DSuspendInfo info = this.getSuspendInfoIsolate(isolateId);
        return info.getReason();
    }

    public DSuspendInfo getSuspendInfoIsolate(int isolateId) {
        DSuspendInfo info = this.m_manager.getSuspendInfo(isolateId);
        if (info == null) {
            if (this.simpleRequestResponseMessageIsolate(35, 40, isolateId)) {
                info = this.m_manager.getSuspendInfo(isolateId);
            }
            if (info == null) {
                info = new DSuspendInfo();
            }
        }
        return info;
    }

    @Override
    public void stepContinueWorker(int isolateId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (!this.isWorkerSuspended(isolateId)) {
            throw new NotSuspendedException();
        }
        if (!this.simpleRequestResponseMessageIsolate(31, 17, isolateId)) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
    }

    @Override
    public Location setBreakpointWorker(int fileId, int lineNum, int isolateId) throws NoResponseException, NotConnectedException {
        DLocation l = null;
        int bp = DLocation.encodeId(fileId, lineNum);
        int wideLineSize = 0;
        if (this.supportsWideLineNumbers()) {
            wideLineSize = 4;
        }
        DMessage dm = DMessageCache.alloc(8 + wideLineSize);
        dm.setType(17);
        dm.putDWord(1);
        if (!this.supportsWideLineNumbers()) {
            dm.putDWord(bp);
        } else {
            dm.putDWord(fileId);
            dm.putDWord(lineNum);
        }
        boolean gotResponse = this.simpleRequestResponseMessageIsolate(dm, 19, isolateId);
        if (!gotResponse) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
        l = this.m_manager.getBreakpoint(bp, isolateId);
        return l;
    }

    @Override
    public Frame[] getFramesWorker(int isolateId) throws NotConnectedException {
        return this.m_manager.getFrames(isolateId);
    }

    @Override
    public SwfInfo[] getSwfsWorker(int isolateId) throws NoResponseException {
        int swfCount = 0;
        swfCount = this.m_manager.getSwfInfoCount(isolateId);
        if (swfCount == 0) {
            this.requestSwfInfo(0, isolateId);
        }
        ArrayList<DSwfInfo> swfList = new ArrayList<DSwfInfo>();
        for (DSwfInfo info : this.m_manager.getSwfInfos(isolateId)) {
            swfList.add(info);
        }
        return swfList.toArray(new SwfInfo[0]);
    }

    @Override
    public void stepIntoWorker(int isolateId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (this.isWorkerSuspended(isolateId)) {
            if (!this.simpleRequestResponseMessageIsolate(21, 17, isolateId)) {
                throw new NoResponseException(this.getPreference("$responsetimeout"));
            }
        } else {
            throw new NotSuspendedException();
        }
    }

    @Override
    public void stepOutWorker(int isolateId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (this.isWorkerSuspended(isolateId)) {
            if (!this.simpleRequestResponseMessageIsolate(22, 17, isolateId)) {
                throw new NoResponseException(this.getPreference("$responsetimeout"));
            }
        } else {
            throw new NotSuspendedException();
        }
    }

    @Override
    public void stepOverWorker(int isolateId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (this.isWorkerSuspended(isolateId)) {
            if (!this.simpleRequestResponseMessageIsolate(20, 17, isolateId)) {
                throw new NoResponseException(this.getPreference("$responsetimeout"));
            }
        } else {
            throw new NotSuspendedException();
        }
    }

    @Override
    public boolean evalInWorker(Value property, Value object, int isolateId) throws PlayerDebugException, PlayerFaultException {
        return ECMA.toBoolean(this.evalBinaryOp(BinaryOp.In, property, object, isolateId));
    }

    @Override
    public Value evalAsWorker(Value value, Value type, int isolateId) throws PlayerDebugException, PlayerFaultException {
        return this.evalBinaryOp(BinaryOp.As, value, type, isolateId);
    }

    @Override
    public void suspendWorker(int isolateId) throws SuspendedException, NotConnectedException, NoResponseException {
        int wait;
        int every = 50;
        if (this.isWorkerSuspended(isolateId)) {
            throw new SuspendedException();
        }
        for (wait = this.getPreference("$suspendwait"); !this.isWorkerSuspended(isolateId) && wait > 0; wait -= every) {
            this.simpleRequestResponseMessageIsolate(16, 27, every, isolateId);
        }
        if (!this.isWorkerSuspended(isolateId)) {
            throw new NoResponseException(wait);
        }
    }

    @Override
    public IsolateSession getWorkerSession(int isolateId) {
        if (this.m_isolateSessions.containsKey(isolateId)) {
            return this.m_isolateSessions.get(isolateId);
        }
        IsolatePlayerSession workerSession = new IsolatePlayerSession(isolateId, this);
        this.m_isolateSessions.put(isolateId, workerSession);
        return workerSession;
    }

    @Override
    public boolean setExceptionBreakpoint(String exceptionClass) throws NoResponseException, NotConnectedException {
        return this.setExceptionBreakpointWorker(exceptionClass, 1);
    }

    @Override
    public boolean setExceptionBreakpointWorker(String exceptionClass, int isolateId) throws NoResponseException, NotConnectedException {
        int messageSize = DMessage.getStringLength(exceptionClass) + 1;
        DMessage dm = DMessageCache.alloc(messageSize);
        dm.setType(55);
        dm.setTargetIsolate(isolateId);
        try {
            dm.putString(exceptionClass);
        }
        catch (UnsupportedEncodingException e) {
            dm.putByte((byte)0);
        }
        boolean gotResponse = this.simpleRequestResponseMessageIsolate(dm, 63, isolateId);
        if (gotResponse) {
            return true;
        }
        throw new NoResponseException(this.getPreference("$responsetimeout"));
    }

    @Override
    public boolean clearExceptionBreakpoint(String exceptionClass) throws NoResponseException, NotConnectedException {
        return this.clearExceptionBreakpointWorker(exceptionClass, 1);
    }

    @Override
    public boolean clearExceptionBreakpointWorker(String exceptionClass, int isolateId) throws NoResponseException, NotConnectedException {
        int messageSize = DMessage.getStringLength(exceptionClass) + 1;
        DMessage dm = DMessageCache.alloc(messageSize);
        dm.setType(56);
        dm.setTargetIsolate(isolateId);
        try {
            dm.putString(exceptionClass);
        }
        catch (UnsupportedEncodingException e) {
            dm.putByte((byte)0);
        }
        boolean gotResponse = this.simpleRequestResponseMessageIsolate(dm, 64, isolateId);
        if (gotResponse) {
            return true;
        }
        throw new NoResponseException(this.getPreference("$responsetimeout"));
    }

    @Override
    public void setLauncher(ILauncher launcher) {
        this.launcher = launcher;
    }
}

