/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.concrete.PlayerSession;
import flash.util.FieldFormat;
import flash.util.Trace;
import java.io.UnsupportedEncodingException;

public class DMessage {
    public static final int InUnknown = -1;
    public static final int InSetMenuState = 0;
    public static final int InSetProperty = 1;
    public static final int InExit = 2;
    public static final int InNewObject = 3;
    public static final int InRemoveObject = 4;
    public static final int InTrace = 5;
    public static final int InErrorTarget = 6;
    public static final int InErrorExecLimit = 7;
    public static final int InErrorWith = 8;
    public static final int InErrorProtoLimit = 9;
    public static final int InSetVariable = 10;
    public static final int InDeleteVariable = 11;
    public static final int InParam = 12;
    public static final int InPlaceObject = 13;
    public static final int InScript = 14;
    public static final int InAskBreakpoints = 15;
    public static final int InBreakAt = 16;
    public static final int InContinue = 17;
    public static final int InSetLocalVariables = 18;
    public static final int InSetBreakpoint = 19;
    public static final int InNumScript = 20;
    public static final int InRemoveScript = 21;
    public static final int InRemoveBreakpoint = 22;
    public static final int InNotSynced = 23;
    public static final int InErrorURLOpen = 24;
    public static final int InProcessTag = 25;
    public static final int InVersion = 26;
    public static final int InBreakAtExt = 27;
    public static final int InSetVariable2 = 28;
    public static final int InSquelch = 29;
    public static final int InGetVariable = 30;
    public static final int InFrame = 31;
    public static final int InOption = 32;
    public static final int InWatch = 33;
    public static final int InGetSwf = 34;
    public static final int InGetSwd = 35;
    public static final int InErrorException = 36;
    public static final int InErrorStackUnderflow = 37;
    public static final int InErrorZeroDivide = 38;
    public static final int InErrorScriptStuck = 39;
    public static final int InBreakReason = 40;
    public static final int InGetActions = 41;
    public static final int InSwfInfo = 42;
    public static final int InConstantPool = 43;
    public static final int InErrorConsole = 44;
    public static final int InGetFncNames = 45;
    public static final int InCallFunction = 54;
    public static final int InWatch2 = 55;
    public static final int InPassAllExceptionsToDebugger = 56;
    public static final int InBinaryOp = 57;
    public static final int InIsolateCreate = 58;
    public static final int InIsolateExit = 59;
    public static final int InIsolateEnumerate = 60;
    public static final int InSetActiveIsolate = 61;
    public static final int InIsolate = 62;
    public static final int InSetExceptionBreakpoint = 63;
    public static final int InRemoveExceptionBreakpoint = 64;
    public static final int InSIZE = 65;
    public static final int OutUnknown = -2;
    public static final int OutZoomIn = 0;
    public static final int OutZoomOut = 1;
    public static final int OutZoom100 = 2;
    public static final int OutHome = 3;
    public static final int OutSetQuality = 4;
    public static final int OutPlay = 5;
    public static final int OutLoop = 6;
    public static final int OutRewind = 7;
    public static final int OutForward = 8;
    public static final int OutBack = 9;
    public static final int OutPrint = 10;
    public static final int OutSetVariable = 11;
    public static final int OutSetProperty = 12;
    public static final int OutExit = 13;
    public static final int OutSetFocus = 14;
    public static final int OutContinue = 15;
    public static final int OutStopDebug = 16;
    public static final int OutSetBreakpoints = 17;
    public static final int OutRemoveBreakpoints = 18;
    public static final int OutRemoveAllBreakpoints = 19;
    public static final int OutStepOver = 20;
    public static final int OutStepInto = 21;
    public static final int OutStepOut = 22;
    public static final int OutProcessedTag = 23;
    public static final int OutSetSquelch = 24;
    public static final int OutGetVariable = 25;
    public static final int OutGetFrame = 26;
    public static final int OutGetOption = 27;
    public static final int OutSetOption = 28;
    public static final int OutAddWatch = 29;
    public static final int OutRemoveWatch = 30;
    public static final int OutStepContinue = 31;
    public static final int OutGetSwf = 32;
    public static final int OutGetSwd = 33;
    public static final int OutGetVariableWhichInvokesGetter = 34;
    public static final int OutGetBreakReason = 35;
    public static final int OutGetActions = 36;
    public static final int OutSetActions = 37;
    public static final int OutSwfInfo = 38;
    public static final int OutConstantPool = 39;
    public static final int OutGetFncNames = 40;
    public static final int OutCallFunction = 48;
    public static final int OutAddWatch2 = 49;
    public static final int OutRemoveWatch2 = 50;
    public static final int OutPassAllExceptionsToDebugger = 51;
    public static final int OutBinaryOp = 52;
    public static final int OutIsolateEnumerate = 53;
    public static final int OutSetActiveIsolate = 54;
    public static final int OutSetExceptionBreakpoint = 55;
    public static final int OutRemoveExceptionBreakpoint = 56;
    public static final int OutSIZE = 57;
    public static final int kNumberType = 0;
    public static final int kBooleanType = 1;
    public static final int kStringType = 2;
    public static final int kObjectType = 3;
    public static final int kMovieClipType = 4;
    public static final int kNullType = 5;
    public static final int kUndefinedType = 6;
    public static final int kReferenceType = 7;
    public static final int kArrayType = 8;
    public static final int kObjectEndType = 9;
    public static final int kStrictArrayType = 10;
    public static final int kDateType = 11;
    public static final int kLongStringType = 12;
    public static final int kUnsupportedType = 13;
    public static final int kRecordSetType = 14;
    public static final int kXMLType = 15;
    public static final int kTypedObjectType = 16;
    public static final int kAvmPlusObjectType = 17;
    public static final int kNamespaceType = 18;
    public static final int kTraitsType = 19;
    byte[] m_content;
    int m_index;
    int m_type;
    private static int m_sizeofPtr;
    private StringBuilder m_debugFormatted;
    private int m_debugFormattedThroughIndex;
    private int m_targetIsolate;

    public DMessage(int size) {
        this.m_content = new byte[size];
        this.m_debugFormatted = new StringBuilder();
        this.m_debugFormattedThroughIndex = 0;
        this.m_targetIsolate = 1;
        this.clear();
    }

    public int getType() {
        return this.m_type;
    }

    public String getInTypeName() {
        return DMessage.inTypeName(this.getType());
    }

    public String getOutTypeName() {
        return DMessage.outTypeName(this.getType());
    }

    public byte[] getData() {
        return this.m_content;
    }

    public int getSize() {
        return this.m_content == null ? 0 : this.m_content.length;
    }

    public int getRemaining() {
        return this.getSize() - this.m_index;
    }

    public int getPosition() {
        return this.m_index;
    }

    public int getTargetIsolate() {
        return this.m_targetIsolate;
    }

    public void setType(int t) {
        this.m_type = t;
    }

    public void setTargetIsolate(int id) {
        this.m_targetIsolate = id;
    }

    public static int getSizeofPtr() {
        assert (m_sizeofPtr != 0);
        return m_sizeofPtr;
    }

    public static void setSizeofPtr(int size) {
        assert (size != 0);
        m_sizeofPtr = size;
    }

    public void reset() {
        this.m_index = 0;
    }

    public void clear() {
        this.setType(-1);
        this.setTargetIsolate(1);
        this.m_debugFormatted.setLength(0);
        this.m_debugFormattedThroughIndex = 0;
        this.reset();
    }

    private long get(int bytes) throws ArrayIndexOutOfBoundsException {
        if (this.m_index + bytes > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(this.m_content.length - this.m_index + " < " + bytes);
        }
        long value = 0L;
        for (int i = 0; i < bytes; ++i) {
            long byteValue = this.m_content[this.m_index++] & 0xFF;
            long byteValueShifted = byteValue << 8 * i;
            value |= byteValueShifted;
        }
        this.debugAppendNumber(value, bytes);
        return value;
    }

    public int getByte() throws ArrayIndexOutOfBoundsException {
        return (int)this.get(1);
    }

    public int getWord() throws ArrayIndexOutOfBoundsException {
        return (int)this.get(2);
    }

    public long getDWord() throws ArrayIndexOutOfBoundsException {
        return this.get(4);
    }

    public long getLong() throws ArrayIndexOutOfBoundsException {
        return this.get(8);
    }

    public long getPtr() throws ArrayIndexOutOfBoundsException {
        return this.get(DMessage.getSizeofPtr());
    }

    public String getString() throws ArrayIndexOutOfBoundsException {
        String s;
        int startAt = this.m_index;
        boolean done = false;
        while (!done) {
            byte ch;
            if ((ch = this.m_content[this.m_index++]) == 0) {
                done = true;
                continue;
            }
            if (this.m_index <= this.m_content.length) continue;
            throw new ArrayIndexOutOfBoundsException("no string terminator found @" + this.m_index);
        }
        try {
            s = new String(this.m_content, startAt, this.m_index - startAt - 1, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            s = new String(this.m_content, startAt, this.m_index - startAt - 1);
        }
        this.debugAppendString(s);
        return s;
    }

    public void put(long val, int bytes) throws ArrayIndexOutOfBoundsException {
        if (this.m_index + bytes > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(this.m_content.length - this.m_index + " < " + bytes);
        }
        for (int i = 0; i < bytes; ++i) {
            this.m_content[this.m_index++] = (byte)(val >> 8 * i);
        }
        this.debugAppendNumber(val, bytes);
    }

    public void putByte(byte val) throws ArrayIndexOutOfBoundsException {
        this.put(val, 1);
    }

    public void putWord(int val) throws ArrayIndexOutOfBoundsException {
        this.put(val, 2);
    }

    public void putDWord(int val) throws ArrayIndexOutOfBoundsException {
        this.put(val, 4);
    }

    public void putLong(long val) throws ArrayIndexOutOfBoundsException {
        this.put(val, 8);
    }

    public void putPtr(long val) throws ArrayIndexOutOfBoundsException {
        this.put(val, DMessage.getSizeofPtr());
    }

    public static int getStringLength(String s) {
        try {
            return s.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            if (Trace.error) {
                Trace.trace((String)e.toString());
            }
            return 0;
        }
    }

    public void putString(String s) throws ArrayIndexOutOfBoundsException, UnsupportedEncodingException {
        byte[] bytes = s.getBytes("UTF-8");
        int length = bytes.length;
        int endAt = this.m_index + length + 1;
        if (endAt > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(endAt + " > " + this.m_content.length);
        }
        System.arraycopy(bytes, 0, this.m_content, this.m_index, length);
        this.m_index += length;
        this.m_content[this.m_index++] = 0;
        this.debugAppendString(s);
    }

    private void debugAppendNumber(long value, int numBytes) {
        if (PlayerSession.m_debugMsgOn || PlayerSession.m_debugMsgFileOn) {
            StringBuilder sb = new StringBuilder();
            sb.append("0x");
            FieldFormat.formatLongToHex((StringBuilder)sb, (long)value, (int)(numBytes * 2), (boolean)true);
            this.debugAppend(sb.toString());
        }
    }

    private void debugAppendString(String s) {
        if (PlayerSession.m_debugMsgOn || PlayerSession.m_debugMsgFileOn) {
            this.debugAppend("\"" + s + "\"");
        }
    }

    private void debugAppend(String s) {
        if ((PlayerSession.m_debugMsgOn || PlayerSession.m_debugMsgFileOn) && this.m_index > this.m_debugFormattedThroughIndex) {
            this.m_debugFormattedThroughIndex = this.m_index;
            if (this.m_debugFormatted.length() > 0) {
                this.m_debugFormatted.append(' ');
            }
            this.m_debugFormatted.append(s);
        }
    }

    public String inToString() {
        return this.inToString(16);
    }

    public String inToString(int maxContentBytes) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getInTypeName());
        sb.append('[');
        sb.append(this.getSize());
        sb.append("] ");
        if (this.getSize() > 0) {
            this.appendContent(sb, maxContentBytes);
        }
        return sb.toString();
    }

    public String outToString() {
        return this.outToString(16);
    }

    public String outToString(int maxContentBytes) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getOutTypeName());
        sb.append('[');
        sb.append(this.getSize());
        sb.append("] ");
        if (this.getSize() > 0) {
            this.appendContent(sb, maxContentBytes);
        }
        return sb.toString();
    }

    public StringBuilder appendContent(StringBuilder sb, int max) {
        int size = this.getSize();
        byte[] data = this.getData();
        int i = 0;
        sb.append((CharSequence)this.m_debugFormatted);
        for (i = 0; i < max && i + this.m_debugFormattedThroughIndex < size; ++i) {
            int v = data[i + this.m_debugFormattedThroughIndex] & 0xFF;
            sb.append(" 0x");
            FieldFormat.formatLongToHex((StringBuilder)sb, (long)v, (int)2, (boolean)true);
        }
        if (i + this.m_debugFormattedThroughIndex < size) {
            sb.append(" ...");
        }
        return sb;
    }

    public static String inTypeName(int type) {
        Object s = "InUnknown(" + type + ")";
        switch (type) {
            case 0: {
                s = "InSetMenuState";
                break;
            }
            case 1: {
                s = "InSetProperty";
                break;
            }
            case 2: {
                s = "InExit";
                break;
            }
            case 3: {
                s = "InNewObject";
                break;
            }
            case 4: {
                s = "InRemoveObject";
                break;
            }
            case 5: {
                s = "InTrace";
                break;
            }
            case 6: {
                s = "InErrorTarget";
                break;
            }
            case 7: {
                s = "InErrorExecLimit";
                break;
            }
            case 8: {
                s = "InErrorWith";
                break;
            }
            case 9: {
                s = "InErrorProtoLimit";
                break;
            }
            case 10: {
                s = "InSetVariable";
                break;
            }
            case 11: {
                s = "InDeleteVariable";
                break;
            }
            case 12: {
                s = "InParam";
                break;
            }
            case 13: {
                s = "InPlaceObject";
                break;
            }
            case 14: {
                s = "InScript";
                break;
            }
            case 15: {
                s = "InAskBreakpoints";
                break;
            }
            case 16: {
                s = "InBreakAt";
                break;
            }
            case 17: {
                s = "InContinue";
                break;
            }
            case 18: {
                s = "InSetLocalVariables";
                break;
            }
            case 19: {
                s = "InSetBreakpoint";
                break;
            }
            case 20: {
                s = "InNumScript";
                break;
            }
            case 21: {
                s = "InRemoveScript";
                break;
            }
            case 22: {
                s = "InRemoveBreakpoint";
                break;
            }
            case 23: {
                s = "InNotSynced";
                break;
            }
            case 24: {
                s = "InErrorURLOpen";
                break;
            }
            case 25: {
                s = "InProcessTag";
                break;
            }
            case 26: {
                s = "InVersion";
                break;
            }
            case 27: {
                s = "InBreakAtExt";
                break;
            }
            case 28: {
                s = "InSetVariable2";
                break;
            }
            case 29: {
                s = "InSquelch";
                break;
            }
            case 30: {
                s = "InGetVariable";
                break;
            }
            case 31: {
                s = "InFrame";
                break;
            }
            case 32: {
                s = "InOption";
                break;
            }
            case 33: {
                s = "InWatch";
                break;
            }
            case 34: {
                s = "InGetSwf";
                break;
            }
            case 35: {
                s = "InGetSwd";
                break;
            }
            case 36: {
                s = "InErrorException";
                break;
            }
            case 37: {
                s = "InErrorStackUnderflow";
                break;
            }
            case 38: {
                s = "InErrorZeroDivide";
                break;
            }
            case 39: {
                s = "InErrorScriptStuck";
                break;
            }
            case 40: {
                s = "InBreakReason";
                break;
            }
            case 41: {
                s = "InGetActions";
                break;
            }
            case 42: {
                s = "InSwfInfo";
                break;
            }
            case 43: {
                s = "InConstantPool";
                break;
            }
            case 44: {
                s = "InErrorConsole";
                break;
            }
            case 45: {
                s = "InGetFncNames";
                break;
            }
            case 54: {
                s = "InCallFunction";
                break;
            }
            case 55: {
                s = "InWatch2";
                break;
            }
            case 56: {
                s = "InPassAllExceptionsToDebugger";
                break;
            }
            case 57: {
                s = "InBinaryOp";
                break;
            }
            case 58: {
                s = "InIsolateCreate";
                break;
            }
            case 59: {
                s = "InIsolateExit";
                break;
            }
            case 60: {
                s = "InIsolateEnumerate";
                break;
            }
            case 61: {
                s = "InSetActiveIsolate";
                break;
            }
            case 62: {
                s = "InIsolate";
                break;
            }
            case 63: {
                s = "InSetExceptionBreakpoint";
                break;
            }
            case 64: {
                s = "InRemoveExceptionBreakpoint";
            }
        }
        return s;
    }

    public static String outTypeName(int type) {
        Object s = "OutUnknown(" + type + ")";
        switch (type) {
            case 0: {
                s = "OutZoomIn";
                break;
            }
            case 1: {
                s = "OutZoomOut";
                break;
            }
            case 2: {
                s = "OutZoom100";
                break;
            }
            case 3: {
                s = "OutHome";
                break;
            }
            case 4: {
                s = "OutSetQuality";
                break;
            }
            case 5: {
                s = "OutPlay";
                break;
            }
            case 6: {
                s = "OutLoop";
                break;
            }
            case 7: {
                s = "OutRewind";
                break;
            }
            case 8: {
                s = "OutForward";
                break;
            }
            case 9: {
                s = "OutBack";
                break;
            }
            case 10: {
                s = "OutPrint";
                break;
            }
            case 11: {
                s = "OutSetVariable";
                break;
            }
            case 12: {
                s = "OutSetProperty";
                break;
            }
            case 13: {
                s = "OutExit";
                break;
            }
            case 14: {
                s = "OutSetFocus";
                break;
            }
            case 15: {
                s = "OutContinue";
                break;
            }
            case 16: {
                s = "OutStopDebug";
                break;
            }
            case 17: {
                s = "OutSetBreakpoints";
                break;
            }
            case 18: {
                s = "OutRemoveBreakpoints";
                break;
            }
            case 19: {
                s = "OutRemoveAllBreakpoints";
                break;
            }
            case 20: {
                s = "OutStepOver";
                break;
            }
            case 21: {
                s = "OutStepInto";
                break;
            }
            case 22: {
                s = "OutStepOut";
                break;
            }
            case 23: {
                s = "OutProcessedTag";
                break;
            }
            case 24: {
                s = "OutSetSquelch";
                break;
            }
            case 25: {
                s = "OutGetVariable";
                break;
            }
            case 26: {
                s = "OutGetFrame";
                break;
            }
            case 27: {
                s = "OutGetOption";
                break;
            }
            case 28: {
                s = "OutSetOption";
                break;
            }
            case 29: {
                s = "OutAddWatch";
                break;
            }
            case 30: {
                s = "OutRemoveWatch";
                break;
            }
            case 31: {
                s = "OutStepContinue";
                break;
            }
            case 32: {
                s = "OutGetSwf";
                break;
            }
            case 33: {
                s = "OutGetSwd";
                break;
            }
            case 34: {
                s = "OutGetVariableWhichInvokesGetter";
                break;
            }
            case 35: {
                s = "OutGetBreakReason";
                break;
            }
            case 36: {
                s = "OutGetActions";
                break;
            }
            case 37: {
                s = "OutSetActions";
                break;
            }
            case 38: {
                s = "OutSwfInfo";
                break;
            }
            case 39: {
                s = "OutConstantPool";
                break;
            }
            case 40: {
                s = "OutGetFncNames";
                break;
            }
            case 48: {
                s = "OutCallFunction";
                break;
            }
            case 49: {
                s = "OutAddWatch2";
                break;
            }
            case 50: {
                s = "OutRemoveWatch2";
                break;
            }
            case 51: {
                s = "OutPassAllExceptionsToDebugger";
                break;
            }
            case 52: {
                s = "OutBinaryOp";
                break;
            }
            case 53: {
                s = "OutIsolateEnumerate";
                break;
            }
            case 54: {
                s = "OutSetActiveIsolate";
                break;
            }
            case 55: {
                s = "OutSetExceptionBreakpoint";
                break;
            }
            case 56: {
                s = "OutRemoveExceptionBreakpoint";
            }
        }
        return s;
    }
}

