/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.localization.LocalizationManager;
import flash.tools.debugger.Bootstrap;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.expression.ASTBuilder;
import flash.tools.debugger.expression.IASTBuilder;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;
import flash.tools.debugger.expression.ValueExp;
import flex.tools.debugger.cli.DebugCLI;
import flex.tools.debugger.cli.ExpressionContext;
import flex.tools.debugger.cli.IntProperties;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public class ExpressionCache {
    Session m_session;
    IASTBuilder m_builder = new ASTBuilder(true);
    Vector<Object> m_expressions = new Vector();
    IntProperties m_props = new IntProperties();
    DebugCLI m_cli;

    public ExpressionCache(DebugCLI cli) {
        this.m_cli = cli;
    }

    public void clear() {
        this.m_expressions.clear();
    }

    public void unbind() {
        this.m_session = null;
    }

    public int size() {
        return this.m_expressions.size();
    }

    public Object at(int i) {
        return this.m_expressions.elementAt(i);
    }

    void setSession(Session s) {
        this.m_session = s;
    }

    public Session getSession() {
        return this.m_session;
    }

    public String getPackageName(int id) {
        return this.m_cli.module2ClassName(id);
    }

    public void bind(Session s) {
        this.setSession(s);
        try {
            ((PlayerSession)s).setPreferences(this.m_props.map());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EvaluationResult evaluate(ValueExp e, int isolateId) throws NumberFormatException, NoSuchVariableException, PlayerFaultException, PlayerDebugException {
        EvaluationResult result = new EvaluationResult();
        result.context = new ExpressionContext(this);
        result.context.setIsolateId(isolateId);
        result.value = e.evaluate(result.context);
        return result;
    }

    public ValueExp parse(String s) throws IOException, ParseException {
        return this.m_builder.parse(new StringReader(s));
    }

    public int add(Object e) {
        int at = this.m_expressions.size();
        this.m_expressions.add(e);
        return at + 1;
    }

    public boolean propertyEnabled(String which) {
        boolean enabled = false;
        try {
            Number number = (Number)this.get(which);
            if (number != null) {
                enabled = number.intValue() != 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return enabled;
    }

    public void put(String s, int value) {
        this.m_props.put(s, value);
        this.setSessionProperty(s, value);
    }

    public Set<String> keySet() {
        return this.m_props.keySet();
    }

    void setSessionProperty(String s, int value) {
        Session sess = this.getSession();
        if (sess != null) {
            sess.setPreference(s, value);
        }
        Bootstrap.sessionManager().setPreference(s, value);
    }

    public Object get(String s) throws NumberFormatException, ArrayIndexOutOfBoundsException, NoSuchElementException {
        Object exp = null;
        if (s.charAt(0) != '$') {
            throw new NoSuchElementException(s);
        }
        String num = s.substring(1);
        if (num == null || num.length() == 0) {
            exp = this.at(this.size() - 1);
        } else if (num.equals("$")) {
            exp = this.at(this.size() - 2);
        } else {
            try {
                int index = Integer.parseInt(num);
                exp = this.at(index - 1);
            }
            catch (NumberFormatException nfe) {
                exp = this.m_props.getInteger(s);
            }
        }
        return exp;
    }

    public void appendVariable(StringBuilder sb, Variable v, int isolateId) {
        String name = v.getName();
        sb.append(name);
        sb.append(" = ");
        this.appendVariableValue(sb, v.getValue(), name, isolateId);
    }

    public void appendVariableValue(StringBuilder sb, final Object o, final int isolateId) {
        Value v = o instanceof Value ? (Value)o : new Value(){

            @Override
            public int getAttributes() {
                return 0;
            }

            @Override
            public String[] getClassHierarchy(boolean allLevels) {
                return new String[0];
            }

            @Override
            public String getClassName() {
                return "";
            }

            @Override
            public long getId() {
                return -1L;
            }

            @Override
            public int getMemberCount(Session s) throws NotSuspendedException, NoResponseException, NotConnectedException {
                return 0;
            }

            @Override
            public Variable getMemberNamed(Session s, String name) throws NotSuspendedException, NoResponseException, NotConnectedException {
                return null;
            }

            @Override
            public Variable[] getMembers(Session s) throws NotSuspendedException, NoResponseException, NotConnectedException {
                return new Variable[0];
            }

            @Override
            public int getType() {
                if (o instanceof Number) {
                    return 0;
                }
                if (o instanceof Boolean) {
                    return 1;
                }
                if (o instanceof String) {
                    return 2;
                }
                if (o == Value.UNDEFINED) {
                    return 7;
                }
                if (o == null) {
                    return 6;
                }
                assert (false);
                return 8;
            }

            @Override
            public String getTypeName() {
                return "";
            }

            @Override
            public Object getValueAsObject() {
                return o;
            }

            @Override
            public String getValueAsString() {
                return DValue.getValueAsString(o);
            }

            @Override
            public boolean isAttributeSet(int variableAttribute) {
                return false;
            }

            @Override
            public Variable[] getPrivateInheritedMembers() {
                return new Variable[0];
            }

            @Override
            public Variable[] getPrivateInheritedMemberNamed(String name) {
                return new Variable[0];
            }

            @Override
            public int getIsolateId() {
                return isolateId;
            }
        };
        this.appendVariableValue(sb, v, isolateId);
    }

    public void appendVariableValue(StringBuilder sb, Value val, int isolateId) {
        this.appendVariableValue(sb, val, "", isolateId);
    }

    public void appendVariableValue(StringBuilder sb, Value val, String variableName, int isolateId) {
        int type = val.getType();
        String typeName = val.getTypeName();
        String className = val.getClassName();
        if (typeName != null && typeName.length() == 0) {
            typeName = null;
        }
        switch (type) {
            case 0: {
                double value = ((Number)val.getValueAsObject()).doubleValue();
                long longValue = (long)value;
                if ((double)longValue == value) {
                    sb.append(longValue);
                    sb.append(" (0x");
                    sb.append(Long.toHexString(longValue));
                    sb.append(")");
                    break;
                }
                sb.append(value);
                break;
            }
            case 1: {
                Boolean b = (Boolean)val.getValueAsObject();
                if (b.booleanValue()) {
                    sb.append("true");
                    break;
                }
                sb.append("false");
                break;
            }
            case 2: {
                char end;
                char start;
                String s = val.getValueAsString();
                if (val.isAttributeSet(262144)) {
                    start = '<';
                    end = '>';
                } else if (s.indexOf(34) != -1 && s.indexOf(39) == -1) {
                    end = '\'';
                    start = '\'';
                } else {
                    end = '\"';
                    start = '\"';
                }
                sb.append(start);
                sb.append(this.escapeIfIde(s));
                sb.append(end);
                break;
            }
            case 3: {
                sb.append("[");
                sb.append(className);
                if (System.getProperty("fdbunit") == null) {
                    sb.append(" ");
                    sb.append(this.escapeIfIde(String.valueOf(val.getValueAsObject())));
                }
                if (typeName != null && !typeName.equals(className)) {
                    sb.append(", class='");
                    int at = typeName.indexOf(64);
                    if (at != -1) {
                        typeName = typeName.substring(0, at);
                    }
                    sb.append(typeName);
                    sb.append('\'');
                }
                sb.append(']');
                break;
            }
            case 4: {
                sb.append('[');
                if (val.isAttributeSet(524288)) {
                    sb.append(ExpressionCache.getLocalizationManager().getLocalizedTextString("getterFunction"));
                } else if (val.isAttributeSet(0x100000)) {
                    sb.append(ExpressionCache.getLocalizationManager().getLocalizedTextString("setterFunction"));
                } else {
                    sb.append(ExpressionCache.getLocalizationManager().getLocalizedTextString("function"));
                }
                sb.append(' ');
                sb.append(this.escapeIfIde(String.valueOf(val.getValueAsObject())));
                if (typeName != null && !typeName.equals(variableName)) {
                    sb.append(", name='");
                    sb.append(typeName);
                    sb.append('\'');
                }
                sb.append(']');
                break;
            }
            case 5: {
                sb.append("[");
                sb.append(className);
                sb.append(" ");
                sb.append(this.escapeIfIde(String.valueOf(val.getValueAsObject())));
                if (typeName != null && !typeName.equals(className)) {
                    sb.append(", named='");
                    sb.append(typeName);
                    sb.append('\'');
                }
                sb.append(']');
                break;
            }
            case 6: {
                sb.append("null");
                break;
            }
            case 7: {
                sb.append("undefined");
                break;
            }
            case 8: {
                sb.append(ExpressionCache.getLocalizationManager().getLocalizedTextString("unknownVariableType"));
            }
        }
    }

    private static LocalizationManager getLocalizationManager() {
        return DebugCLI.getLocalizationManager();
    }

    public static void appendVariableAttributes(StringBuilder sb, Variable v) {
        if (v.getAttributes() == 0) {
            return;
        }
        sb.append("  ");
        if (v.isAttributeSet(1)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_dontEnumerate"));
        }
        if (v.isAttributeSet(4)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_readOnly"));
        }
        if (v.isAttributeSet(32)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_localVariable"));
        }
        if (v.isAttributeSet(65536)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_functionArgument"));
        }
        if (v.isAttributeSet(524288)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_getterFunction"));
        }
        if (v.isAttributeSet(0x100000)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_setterFunction"));
        }
        if (v.isAttributeSet(131072)) {
            sb.append(", dynamic");
        }
        if (v.isAttributeSet(0x200000)) {
            sb.append(", static");
        }
        if (v.isAttributeSet(0x400000)) {
            sb.append(", const");
        }
        if (v.isAttributeSet(0x800000)) {
            sb.append(", private");
        }
        if (v.isAttributeSet(0)) {
            sb.append(", public");
        }
        if (v.isAttributeSet(0x1000000)) {
            sb.append(", protected");
        }
        if (v.isAttributeSet(0x1800000)) {
            sb.append(", internal");
        }
        if (v.isAttributeSet(0x2000000)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_hasNamespace"));
        }
    }

    private String escapeIfIde(String s) {
        return this.m_cli != null && this.m_cli.isIde() ? ExpressionCache.escape(s) : s;
    }

    public static String escape(String str) {
        StringBuilder buffer = new StringBuilder();
        block8: for (int idx = 0; idx < str.length(); ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    continue block8;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block8;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block8;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block8;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block8;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        String hexCode = Integer.toHexString(ch).toUpperCase();
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        continue block8;
                    }
                    buffer.append(ch);
                }
            }
        }
        return buffer.toString();
    }

    public static class EvaluationResult {
        public Object value;
        public ExpressionContext context;
    }
}

