/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.expression;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.tools.debugger.DebuggerLocalizer;
import flash.tools.debugger.expression.DebuggerExpression;
import flash.tools.debugger.expression.DebuggerUtil;
import flash.tools.debugger.expression.IASTBuilder;
import flash.tools.debugger.expression.ValueExp;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.as.IASNode;

public class ASTBuilder
implements IASTBuilder {
    private static LocalizationManager s_localizationManager = new LocalizationManager();
    private boolean m_isIndirectionOperatorAllowed = true;

    public ASTBuilder(boolean isIndirectionOperatorAllowed) {
        this.m_isIndirectionOperatorAllowed = isIndirectionOperatorAllowed;
    }

    public boolean isIndirectionOperatorAllowed() {
        return this.m_isIndirectionOperatorAllowed;
    }

    @Override
    public ValueExp parse(Reader in) throws IOException, ParseException {
        int ch;
        DebuggerExpression retval = new DebuggerExpression();
        StringBuilder sb = new StringBuilder();
        while ((ch = in.read()) != -1) {
            sb.append((char)ch);
        }
        String s = sb.toString();
        s = s.replaceFirst("^#([0-9]+)", "\\$obj($1)");
        if (this.isIndirectionOperatorAllowed()) {
            if (s.endsWith(".")) {
                retval.setLookupMembers(true);
                s = s.substring(0, s.length() - 1);
            } else if (s.startsWith("*")) {
                retval.setLookupMembers(true);
                s = s.substring(1);
            }
        }
        s = "(" + s + ")";
        ArrayList<ICompilerProblem> errors = new ArrayList<ICompilerProblem>();
        IASNode programNode = DebuggerUtil.parseExpression(s, errors);
        if (errors.size() > 0) {
            ICompilerProblem firstError = (ICompilerProblem)errors.get(0);
            throw new ParseException(firstError.toString(), firstError.getColumn());
        }
        retval.setProgramNode(programNode);
        return retval;
    }

    static LocalizationManager getLocalizationManager() {
        return s_localizationManager;
    }

    static {
        s_localizationManager.addLocalizer((ILocalizer)new DebuggerLocalizer("flash.tools.debugger.expression.expression."));
    }
}

