/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.expression;

import flash.tools.debugger.IsolateController;
import flash.tools.debugger.IsolateSession;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.expression.ASTBuilder;
import flash.tools.debugger.expression.Context;
import flash.tools.debugger.expression.DebuggerExpressionEvaluator;
import flash.tools.debugger.expression.DebuggerValue;
import flash.tools.debugger.expression.ECMA;
import flash.tools.debugger.expression.ExpressionEvaluatorException;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NumericLiteralNode;
import org.apache.royale.compiler.internal.tree.as.RegExpLiteralNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.INumericLiteralNode;

public class AS3DebuggerReducer {
    private final ContextStack contextStack;
    private final ICompilerProject project;
    static final int ERROR_TRAP = 0x10000000;
    private boolean hookallreducercalls = false;

    public AS3DebuggerReducer(Context context, ICompilerProject project) {
        this.contextStack = new ContextStack(context);
        this.project = project;
    }

    private void hookforreducercalls(String name) {
        System.out.println(name);
    }

    private Object callFunction(Context cx, boolean isConstructor, Object function, Object[] args) throws PlayerDebugException {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("callFunction");
        }
        Session session = cx.getSession();
        Value thisObject = cx.toValue();
        if (thisObject == null) {
            thisObject = DValue.forPrimitive(null, cx.getIsolateId());
        }
        Value[] valueArgs = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            Value tempValue = cx.toValue(args[i]);
            if (tempValue == null) {
                tempValue = DValue.forPrimitive(null, cx.getIsolateId());
            }
            valueArgs[i] = tempValue;
        }
        String functionName = function instanceof Variable ? ((Variable)function).getQualifiedName() : function.toString();
        IsolateSession workerSession = session.getWorkerSession(cx.getIsolateId());
        if (isConstructor) {
            return ((IsolateController)((Object)session)).callConstructorWorker(functionName, valueArgs, thisObject.getIsolateId());
        }
        return ((IsolateController)((Object)session)).callFunctionWorker(thisObject, functionName, valueArgs, thisObject.getIsolateId());
    }

    Object compoundBinaryAssignmentBracketExpr(IASNode iNode, Object stem, Object index, Object r, int opcode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("compoundBinaryAssignmentBracketExpr");
        }
        Object leftVariable = this.reduce_arrayIndexExpr(iNode, stem, false, index);
        DebuggerValue operationValue = (DebuggerValue)this.binaryOp(iNode, leftVariable, r, opcode);
        return this.reduce_assignToBracketExpr_to_expression(iNode, stem, index, operationValue, false);
    }

    Object compoundBinaryAssignmentMemberExpr(IASNode iNode, Object stem, Object member, Object r, int opcode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("compoundBinaryAssignmentMemberExpr");
        }
        Object leftVariable = this.reduce_memberAccessExpr(iNode, stem, member, -1);
        DebuggerValue operationValue = (DebuggerValue)this.binaryOp(iNode, leftVariable, r, opcode);
        return this.reduce_assignToMemberExpr_to_expression(iNode, stem, member, operationValue);
    }

    Object compoundBinaryAssignmentNameExpr(IASNode iNode, Object l, Object r, int opcode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("compoundBinaryAssignmentNameExpr");
        }
        Object leftVariable = this.transform_name_to_expression(iNode, l);
        DebuggerValue operationValue = (DebuggerValue)this.binaryOp(iNode, leftVariable, r, opcode);
        return this.reduce_assignToNameExpr_to_expression(iNode, l, operationValue);
    }

    Object binaryOp(IASNode iNode, Object l, Object r, int opcode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("binaryOp");
        }
        switch (opcode) {
            default: 
        }
        DebuggerValue lhs = (DebuggerValue)l;
        DebuggerValue rhs = (DebuggerValue)r;
        Context eeContext = this.contextStack.scope();
        Session session = eeContext.getSession();
        switch (opcode) {
            case 162: {
                double d1 = ECMA.toNumber(session, eeContext.toValue(lhs.debuggerValue));
                double d2 = ECMA.toNumber(session, eeContext.toValue(rhs.debuggerValue));
                return new DebuggerValue(new Double(d1 * d2));
            }
            case 163: {
                double d1 = ECMA.toNumber(session, eeContext.toValue(lhs.debuggerValue));
                double d2 = ECMA.toNumber(session, eeContext.toValue(rhs.debuggerValue));
                return new DebuggerValue(new Double(d1 / d2));
            }
            case 164: {
                double d1 = ECMA.toNumber(session, eeContext.toValue(lhs.debuggerValue));
                double d2 = ECMA.toNumber(session, eeContext.toValue(rhs.debuggerValue));
                return new DebuggerValue(new Double(d1 % d2));
            }
            case 160: {
                Value v1 = eeContext.toValue(lhs.debuggerValue);
                Value v2 = eeContext.toValue(rhs.debuggerValue);
                boolean isXMLConcat = false;
                if (v1.getType() == 3 && v2.getType() == 3) {
                    String type1 = v1.getTypeName();
                    String type2 = v2.getTypeName();
                    int at = type1.indexOf(64);
                    if (at != -1) {
                        type1 = type1.substring(0, at);
                    }
                    if ((at = type2.indexOf(64)) != -1) {
                        type2 = type2.substring(0, at);
                    }
                    if ((type1.equals("XML") || type1.equals("XMLList")) && (type2.equals("XML") || type2.equals("XMLList"))) {
                        isXMLConcat = true;
                    }
                }
                if (isXMLConcat) {
                    try {
                        IsolateSession workerSession = session.getWorkerSession(v1.getIsolateId());
                        Value xml1 = workerSession.callFunction(v1, "toXMLString", new Value[0]);
                        Value xml2 = session.getWorkerSession(v2.getIsolateId()).callFunction(v2, "toXMLString", new Value[0]);
                        String allXML = xml1.getValueAsString() + xml2.getValueAsString();
                        DValue allXMLValue = DValue.forPrimitive(allXML, v1.getIsolateId());
                        Value retval = workerSession.callConstructor("XMLList", new Value[]{allXMLValue});
                        return new DebuggerValue(retval);
                    }
                    catch (PlayerDebugException e) {
                        throw new ExpressionEvaluatorException(e);
                    }
                }
                v1 = ECMA.toPrimitive(session, v1, null, eeContext.getIsolateId());
                v2 = ECMA.toPrimitive(session, v2, null, eeContext.getIsolateId());
                if (v1.getType() == 2 || v2.getType() == 2) {
                    return new DebuggerValue(ECMA.toString(session, v1) + ECMA.toString(session, v2));
                }
                return new DebuggerValue(new Double(ECMA.toNumber(session, v1) + ECMA.toNumber(session, v2)));
            }
            case 161: {
                double d1 = ECMA.toNumber(session, eeContext.toValue(lhs.debuggerValue));
                double d2 = ECMA.toNumber(session, eeContext.toValue(rhs.debuggerValue));
                return new DebuggerValue(new Double(d1 - d2));
            }
            case 165: {
                int n1 = ECMA.toInt32(session, eeContext.toValue(lhs.debuggerValue));
                int n2 = (int)(ECMA.toUint32(session, eeContext.toValue(rhs.debuggerValue)) & 0x1FL);
                return new DebuggerValue(new Double(n1 << n2));
            }
            case 166: {
                int n1 = ECMA.toInt32(session, eeContext.toValue(lhs.debuggerValue));
                int n2 = (int)(ECMA.toUint32(session, eeContext.toValue(rhs.debuggerValue)) & 0x1FL);
                return new DebuggerValue(new Double(n1 >> n2));
            }
            case 167: {
                long n1 = ECMA.toUint32(session, eeContext.toValue(lhs.debuggerValue));
                long n2 = ECMA.toUint32(session, eeContext.toValue(rhs.debuggerValue)) & 0x1FL;
                return new DebuggerValue(new Double(n1 >>> (int)n2));
            }
            case 173: {
                Value lessThan = ECMA.lessThan(session, eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue));
                boolean result = lessThan.getType() == 7 ? false : ECMA.toBoolean(lessThan);
                return new DebuggerValue(result);
            }
            case 175: {
                Value greaterThan = ECMA.lessThan(session, eeContext.toValue(rhs.debuggerValue), eeContext.toValue(lhs.debuggerValue));
                boolean result = greaterThan.getType() == 7 ? false : ECMA.toBoolean(greaterThan);
                return new DebuggerValue(result);
            }
            case 174: {
                Value lessThan = ECMA.lessThan(session, eeContext.toValue(rhs.debuggerValue), eeContext.toValue(lhs.debuggerValue));
                boolean result = lessThan.getType() == 7 ? false : !ECMA.toBoolean(lessThan);
                return new DebuggerValue(result);
            }
            case 176: {
                Value lessThan = ECMA.lessThan(session, eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue));
                boolean result = lessThan.getType() == 7 ? false : !ECMA.toBoolean(lessThan);
                return new DebuggerValue(result);
            }
            case 177: {
                try {
                    return new DebuggerValue(session.getWorkerSession(eeContext.getIsolateId()).evalInstanceof(eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue)));
                }
                catch (PlayerDebugException e) {
                    throw new ExpressionEvaluatorException(e);
                }
                catch (PlayerFaultException e) {
                    throw new ExpressionEvaluatorException(e);
                }
            }
            case 180: {
                try {
                    return new DebuggerValue(session.getWorkerSession(eeContext.getIsolateId()).evalIn(eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue)));
                }
                catch (PlayerDebugException e) {
                    throw new ExpressionEvaluatorException(e);
                }
                catch (PlayerFaultException e) {
                    throw new ExpressionEvaluatorException(e);
                }
            }
            case 179: {
                try {
                    return new DebuggerValue(session.getWorkerSession(eeContext.getIsolateId()).evalIs(eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue)));
                }
                catch (PlayerDebugException e) {
                    throw new ExpressionEvaluatorException(e);
                }
                catch (PlayerFaultException e) {
                    throw new ExpressionEvaluatorException(e);
                }
            }
            case 135: {
                try {
                    return new DebuggerValue(session.getWorkerSession(eeContext.getIsolateId()).evalAs(eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue)));
                }
                catch (PlayerDebugException e) {
                    throw new ExpressionEvaluatorException(e);
                }
                catch (PlayerFaultException e) {
                    throw new ExpressionEvaluatorException(e);
                }
            }
            case 171: {
                return new DebuggerValue(new Boolean(ECMA.equals(session, eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue))));
            }
            case 172: {
                return new DebuggerValue(new Boolean(ECMA.strictEquals(eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue))));
            }
            case 168: {
                return new DebuggerValue(new Double(ECMA.toInt32(session, eeContext.toValue(lhs.debuggerValue)) & ECMA.toInt32(session, eeContext.toValue(rhs.debuggerValue))));
            }
            case 170: {
                return new DebuggerValue(new Double(ECMA.toInt32(session, eeContext.toValue(lhs.debuggerValue)) ^ ECMA.toInt32(session, eeContext.toValue(rhs.debuggerValue))));
            }
            case 169: {
                return new DebuggerValue(new Double(ECMA.toInt32(session, eeContext.toValue(lhs.debuggerValue)) | ECMA.toInt32(session, eeContext.toValue(rhs.debuggerValue))));
            }
        }
        return new DebuggerValue(null);
    }

    Object dottedName(IASNode iNode, String qualifiers, String base_name) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("dottedName");
        }
        return qualifiers + "." + base_name;
    }

    public Object error_namespaceAccess(IASNode iNode, IASNode raw_qualifier, Object qualified_name) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("error_namespaceAccess");
        }
        return null;
    }

    public Object error_reduce_Op_AssignId(IASNode iNode, Object non_lvalue, Object rvalue) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("error_reduce_Op_AssignId");
        }
        return null;
    }

    Double getDoubleContent(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("getDoubleContent");
        }
        return SemanticUtils.getDoubleContent((IASNode)iNode);
    }

    Float getFloatContent(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("getFloatContent");
        }
        return null;
    }

    String getIdentifierContent(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("getIdentifierContent");
        }
        return SemanticUtils.getIdentifierContent((IASNode)iNode);
    }

    Integer getIntegerContent(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("getIntegerContent");
        }
        return SemanticUtils.getIntegerContent((IASNode)iNode);
    }

    Integer getIntegerZeroContent(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("getIntegerZeroContent");
        }
        return 0;
    }

    Long getIntegerZeroContentAsLong(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("getIntegerZeroContentAsLong");
        }
        return 0L;
    }

    String getStringLiteralContent(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("getStringLiteralContent");
        }
        return SemanticUtils.getStringLiteralContent((IASNode)iNode);
    }

    Long getUintContent(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("getUintContent");
        }
        return SemanticUtils.getUintContent((IASNode)iNode);
    }

    public int isIntLiteral(IASNode iNode) {
        INumericLiteralNode.INumericValue numericVal;
        if (this.hookallreducercalls) {
            this.hookforreducercalls("isIntLiteral");
        }
        if (iNode.getNodeID() == ASTNodeID.LiteralNumberID && (numericVal = ((NumericLiteralNode)iNode).getNumericValue()).getAssumedType() == IASLanguageConstants.BuiltinType.INT) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    public int isUintLiteral(IASNode iNode) {
        INumericLiteralNode.INumericValue numericVal;
        if (this.hookallreducercalls) {
            this.hookforreducercalls("isUintLiteral");
        }
        if (iNode.getNodeID() == ASTNodeID.LiteralNumberID && (numericVal = ((NumericLiteralNode)iNode).getNumericValue()).getAssumedType() == IASLanguageConstants.BuiltinType.UINT) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    public int isDoubleLiteral(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("isDoubleLiteral");
        }
        if (iNode.getNodeID() == ASTNodeID.LiteralDoubleID) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }

    int isDottedName(IASNode n) {
        MemberAccessExpressionNode ma;
        if (this.hookallreducercalls) {
            this.hookforreducercalls("isDottedName");
        }
        int result = Integer.MAX_VALUE;
        if (n instanceof MemberAccessExpressionNode && (ma = (MemberAccessExpressionNode)n).stemIsPackage()) {
            result = 2;
        }
        return result;
    }

    int isPackageName(IASNode n) {
        MemberAccessExpressionNode ma;
        if (this.hookallreducercalls) {
            this.hookforreducercalls("isPackageName");
        }
        int result = Integer.MAX_VALUE;
        if (n instanceof MemberAccessExpressionNode && (ma = (MemberAccessExpressionNode)n).isPackageReference()) {
            result = 1;
        }
        return result;
    }

    int qualifierIsCompileTimeConstant(IASNode iNode) {
        IdentifierNode qualifier;
        IDefinition def;
        if (this.hookallreducercalls) {
            this.hookforreducercalls("qualifierIsCompileTimeConstant");
        }
        int result = (def = (qualifier = (IdentifierNode)SemanticUtils.getNthChild((IASNode)iNode, (int)0)).resolve(this.project)) instanceof NamespaceDefinition ? 1 : Integer.MAX_VALUE;
        return result;
    }

    int isCompileTimeConstant(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("isCompileTimeConstant");
        }
        if (SemanticUtils.transformNameToConstantValue((IASNode)iNode, (ICompilerProject)this.project) != null) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    int isCompileTimeConstantFunction(IASNode iNode) {
        IDefinition def;
        if (this.hookallreducercalls) {
            this.hookforreducercalls("isCompileTimeConstantFunction");
        }
        if (SemanticUtils.isConstDefinition((IDefinition)(def = ((IdentifierNode)iNode).resolve(this.project)))) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    int parameterTypeIsConstant(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("parameterTypeIsConstant");
        }
        return Math.max(this.isKnownType(SemanticUtils.getNthChild((IASNode)iNode, (int)0)), this.isKnownType(SemanticUtils.getNthChild((IASNode)iNode, (int)1)));
    }

    int isKnownType(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("isKnownType");
        }
        boolean isConstant = false;
        if (iNode instanceof IExpressionNode) {
            isConstant = ((IExpressionNode)iNode).resolve(this.project) instanceof ITypeDefinition;
        }
        return isConstant ? 1 : 0x10000000;
    }

    public Object transform_constant_function_to_value(IASNode iNode, Object method, Vector<Object> constant_args) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_constant_function_to_value");
        }
        return null;
    }

    int isFloatBinOp(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("isFloatBinOp");
        }
        return 0;
    }

    int isEmptyArrayConstructor(IASNode iNode) {
        IIdentifierNode identifierNode;
        if (this.hookallreducercalls) {
            this.hookforreducercalls("isEmptyArrayConstructor");
        }
        if ((identifierNode = (IIdentifierNode)SemanticUtils.getNthChild((IASNode)iNode, (int)1)).resolve(this.project) == this.project.getBuiltinType(IASLanguageConstants.BuiltinType.ARRAY)) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    int isEmptyObjectConstructor(IASNode iNode) {
        IIdentifierNode identifierNode;
        if (this.hookallreducercalls) {
            this.hookforreducercalls("isEmptyObjectConstructor");
        }
        if ((identifierNode = (IIdentifierNode)SemanticUtils.getNthChild((IASNode)iNode, (int)1)).resolve(this.project) == this.project.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT)) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    public Object reduce_arrayIndexExpr(IASNode iNode, Object stem, boolean is_super, Object index) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_arrayIndexExpr");
        }
        return this.reduce_memberAccessExpr(iNode, stem, index, -1);
    }

    public Object reduce_arrayLiteral(IASNode iNode, Vector<Object> elements) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_arrayLiteral");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object reduce_assignToBracketExpr_to_expression(IASNode iNode, Object stem, Object index, Object r, boolean is_super) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_assignToBracketExpr_to_expression");
        }
        Context eeContext = this.contextStack.scope();
        Context newContext = eeContext.createContext(((DebuggerValue)stem).debuggerValue);
        this.contextStack.pushScope(newContext);
        try {
            Object object = this.reduce_assignToNameExpr_to_expression(iNode, index, r);
            return object;
        }
        finally {
            this.contextStack.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object reduce_assignToMemberExpr_to_expression(IASNode iNode, Object stem, Object member, Object r) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_assignToMemberExpr_to_expression");
        }
        Context eeContext = this.contextStack.scope();
        Context newContext = eeContext.createContext(((DebuggerValue)stem).debuggerValue);
        this.contextStack.pushScope(newContext);
        try {
            Object object = this.reduce_assignToNameExpr_to_expression(iNode, member, r);
            return object;
        }
        finally {
            this.contextStack.popScope();
        }
    }

    public Object reduce_assignToDescendantsExpr(IASNode iNode, Object stem, Object member, Object r, boolean need_value) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_assignToDescendantsExpr");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_assignToNameExpr_to_expression(IASNode iNode, Object lvalue, Object r) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_assignToNameExpr_to_expression");
        }
        Context eeContext = this.contextStack.scope();
        DebuggerValue lhs = (DebuggerValue)lvalue;
        String variableToAssignTo = ECMA.toString(eeContext.getSession(), eeContext.toValue(lhs.debuggerValue));
        DebuggerValue newValue = (DebuggerValue)r;
        try {
            eeContext.assign(variableToAssignTo, eeContext.toValue(newValue.debuggerValue));
        }
        catch (NoSuchVariableException e) {
            throw new ExpressionEvaluatorException(e);
        }
        catch (PlayerFaultException e) {
            throw new ExpressionEvaluatorException(e);
        }
        return newValue;
    }

    public Object reduce_assignToQualifiedMemberExpr(IASNode iNode, Object stem, Object qualifier, Object member, Object rhs, boolean need_value) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_assignToQualifiedMemberExpr");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_assignToQualifiedRuntimeMemberExpr(IASNode iNode, Object stem, Object qualifier, Object runtime_member_selector, Object rhs, boolean need_value) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_assignToQualifiedRuntimeMemberExpr");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_assignToQualifiedAttributeExpr(IASNode iNode, Object stem, Object qualifier, Object member, Object rhs, boolean need_value) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_assignToQualifiedAttributeExpr");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_assignToRuntimeNameExpr(IASNode iNode, Object lval, Object r, boolean need_value) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_assignToRuntimeNameExpr");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_assignToUnqualifiedRuntimeAttributeExpr(IASNode iNode, Object stem, Object rt_attr, Object rhs, boolean need_value) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_assignToUnqualifiedRuntimeAttributeExpr");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_attributeName(IASNode iNode, Object attr_name) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_attributeName");
        }
        return new DebuggerValue("@" + ((DebuggerValue)attr_name).debuggerValue);
    }

    public Boolean reduce_booleanLiteral(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_booleanLiteral");
        }
        return SemanticUtils.getBooleanContent((IASNode)iNode);
    }

    public String reduce_by_concatenation(IASNode iNode, String first, String second) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_by_concatenation");
        }
        return first + "." + second;
    }

    public Object reduce_commaExpr(IASNode iNode, Object payload_expr, Vector<Object> exprs) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_commaExpr");
        }
        Object result = null;
        return result;
    }

    public Object reduce_deleteBracketExpr(IASNode iNode, Object stem, Object index) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_deleteBracketExpr");
        }
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("delete"));
    }

    public Object reduce_deleteAtBracketExpr(IASNode iNode, Object stem, Object index) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_deleteAtBracketExpr");
        }
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("delete"));
    }

    public Object reduce_deleteDescendantsExpr(IASNode iNode, Object stem, Object field) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_deleteDescendantsExpr");
        }
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("delete"));
    }

    public Object reduce_deleteExprExprExpr(IASNode iNode, Object expr) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_deleteExprExprExpr");
        }
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("delete"));
    }

    public Object reduce_deleteMemberExpr(IASNode iNode, Object stem, Object field) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_deleteMemberExpr");
        }
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("delete"));
    }

    public Object reduce_deleteRuntimeNameExpr(IASNode iNode, Object stem, Object rt_name) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_deleteRuntimeNameExpr");
        }
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("delete"));
    }

    public Object reduce_deleteNameExpr(IASNode iNode, Object n) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_deleteNameExpr");
        }
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("delete"));
    }

    public Object reduce_e4xFilter(IASNode iNode, Object stem, Object filter) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_e4xFilter");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_embed(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_embed");
        }
        Object result = null;
        return result;
    }

    public Object reduce_functionAsBracketExpr(IASNode iNode, Object stem, Object index, Vector<Object> args) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_functionAsBracketExpr");
        }
        Object result = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object reduce_functionAsMemberExpr(IASNode iNode, Object stem, Object method_name, Vector<Object> args) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_functionAsMemberExpr");
        }
        try {
            Context context = this.contextStack.scope();
            DebuggerValue lhs = (DebuggerValue)stem;
            Context newContext = context.createContext(lhs.debuggerValue);
            this.contextStack.pushScope(newContext);
            Object object = this.reduce_functionCall_common(iNode, method_name, args, true, false);
            return object;
        }
        finally {
            this.contextStack.popScope();
        }
    }

    public Object reduce_functionAsRandomExpr(IASNode iNode, Object random_expr, Vector<Object> args) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_functionAsRandomExpr");
        }
        return this.reduce_functionCall_common(iNode, random_expr, args, true, false);
    }

    public Object reduce_functionCallExpr_to_expression(IASNode iNode, Object method_name, Vector<Object> args) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_functionCallExpr_to_expression");
        }
        return this.reduce_functionCall_common(iNode, method_name, args, true, false);
    }

    public Object reduce_functionCallSpecial_to_expression(IASNode iNode, Object method_name, Vector<Object> args) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_functionCallSpecial_to_expression");
        }
        IdentifierNode id = (IdentifierNode)method_name;
        Context context = this.contextStack.scope();
        try {
            Object[] argValues = new Object[1];
            for (int i = 0; i < args.size(); ++i) {
                DebuggerValue dv = (DebuggerValue)args.get(i);
                argValues[i] = dv.debuggerValue;
            }
            return new DebuggerValue(this.callFunction(context, false, id.getName(), argValues));
        }
        catch (PlayerDebugException e) {
            throw new ExpressionEvaluatorException(e);
        }
    }

    private Object reduce_functionCall_common(IASNode iNode, Object method_name, Vector<Object> args, boolean need_result, boolean isConstructor) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_functionCall_common");
        }
        Context context = this.contextStack.scope();
        DebuggerValue func = (DebuggerValue)method_name;
        try {
            Object[] argValues = new Object[args.size()];
            for (int i = 0; i < args.size(); ++i) {
                DebuggerValue dv = (DebuggerValue)args.get(i);
                argValues[i] = dv.debuggerValue;
            }
            return new DebuggerValue(this.callFunction(context, isConstructor, func.debuggerValue, argValues));
        }
        catch (PlayerDebugException e) {
            throw new ExpressionEvaluatorException(e);
        }
    }

    public Object reduce_functionCallOfSuperclassMethod_to_expression(IASNode iNode, Object stem, Object method_name, Vector<Object> args) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_functionCallOfSuperclassMethod_to_expression");
        }
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("super"));
    }

    public Object reduce_logicalAndExpr(IASNode iNode, Object l, Object r) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_logicalAndExpr");
        }
        Context eeContext = this.contextStack.scope();
        DebuggerValue lhs = (DebuggerValue)l;
        Value result = eeContext.toValue(lhs.debuggerValue);
        if (ECMA.toBoolean(result)) {
            DebuggerValue rhs = null;
            rhs = r instanceof DebuggerValue ? (DebuggerValue)r : ((UnEvaluatedDebugExpression)r).evaluate(eeContext);
            result = eeContext.toValue(rhs.debuggerValue);
        }
        return new DebuggerValue(result);
    }

    public Object reduce_logicalNotExpr(IASNode iNode, Object expr) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_logicalNotExpr");
        }
        Context eeContext = this.contextStack.scope();
        DebuggerValue arg = (DebuggerValue)expr;
        return new DebuggerValue(new Boolean(!ECMA.toBoolean(eeContext.toValue(arg.debuggerValue))));
    }

    public Object reduce_logicalOrExpr(IASNode iNode, Object l, Object r) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_logicalOrExpr");
        }
        Context eeContext = this.contextStack.scope();
        DebuggerValue lhs = (DebuggerValue)l;
        Value result = eeContext.toValue(lhs.debuggerValue);
        if (!ECMA.toBoolean(result)) {
            DebuggerValue rhs = r instanceof DebuggerValue ? (DebuggerValue)r : ((UnEvaluatedDebugExpression)r).evaluate(eeContext);
            result = eeContext.toValue(rhs.debuggerValue);
        }
        return new DebuggerValue(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object reduce_memberAccessExpr(IASNode iNode, Object stem, Object member, int opcode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_memberAccessExpr");
        }
        DebuggerValue lhs = (DebuggerValue)stem;
        Context context = this.contextStack.scope();
        boolean pushedScope = false;
        if (lhs != null) {
            Value lhsValue = context.toValue(lhs.debuggerValue);
            if (ECMA.equals(context.getSession(), lhsValue, context.toValue(null))) {
                throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("nullPointerException"));
            }
            Context newContext = context.createContext(lhs.debuggerValue);
            this.contextStack.pushScope(newContext);
            pushedScope = true;
        }
        try {
            DebuggerValue rhs;
            DebuggerValue debuggerValue = rhs = (DebuggerValue)this.transform_name_to_expression(iNode, member);
            return debuggerValue;
        }
        finally {
            if (pushedScope) {
                this.contextStack.popScope();
            }
        }
    }

    public Object reduce_qualifiedMemberAccessExpr(IASNode iNode, Object stem, Object qualifier, Object member, int opcode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_qualifiedMemberAccessExpr");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_qualifiedAttributeRuntimeMemberExpr(IASNode iNode, Object stem, Object qualifier, Object runtime_member_selector, int opcode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_qualifiedAttributeRuntimeMemberExpr");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_qualifiedMemberRuntimeNameExpr(IASNode iNode, Object stem, Object qualifier, Object runtime_member_selector) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_qualifiedMemberRuntimeNameExpr");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_qualifiedAttributeExpr(IASNode iNode, Object stem, Object qualifier, Object member, int opcode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_qualifiedAttributeExpr");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_unqualifiedAttributeExpr(IASNode iNode, Object stem, Object rt_attr, int opcode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_unqualifiedAttributeExpr");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_runtimeAttributeExp(IASNode iNode, Object rt_attr) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_runtimeAttributeExp");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_namespaceAccess(IASNode iNode, IASNode qualifier, Object qualified_name) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_namespaceAccess");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_namespaceAsName_to_expression(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_namespaceAsName_to_expression");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_namespaceAsName_to_multinameL(IASNode iNode, boolean is_attribute) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_namespaceAsName_to_multinameL");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_namespaceAsName_to_name(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_namespaceAsName_to_name");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_namespaceMultinameL(IASNode iNode, IASNode qualifier_node, Object expr) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_namespaceMultinameL");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_namespaceRTQName(IASNode iNode, Object qualifier, Object qualified_name) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_namespaceRTQName");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_namespaceRTQNameL(IASNode iNode, Object qualifier, Object expr) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_namespaceRTQNameL");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_neqExpr(IASNode iNode, Object l, Object r) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_neqExpr");
        }
        Object result = null;
        return result;
    }

    public Object reduce_nameToTypeName(Object name, boolean check_name) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_nameToTypeName");
        }
        return name;
    }

    public Object reduce_newMemberProperty(IASNode iNode, Object stem, Object member, Vector<Object> args) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_newMemberProperty");
        }
        Object result = null;
        return result;
    }

    public Object reduce_newAsRandomExpr(IASNode iNode, Object random_expr, Vector<Object> args) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_newAsRandomExpr");
        }
        Object result = null;
        return result;
    }

    public Object reduce_newEmptyArray(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_newEmptyArray");
        }
        Object result = null;
        return result;
    }

    public Object reduce_newEmptyObject(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_newEmptyObject");
        }
        Object result = null;
        return result;
    }

    public Object reduce_newExpr(IASNode iNode, Object class_Object, Vector<Object> args) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_newExpr");
        }
        return this.reduce_functionCall_common(iNode, class_Object, args, true, true);
    }

    public Object reduce_newVectorLiteral(IASNode iNode, Object literal) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_newVectorLiteral");
        }
        return literal;
    }

    public Object reduce_nilExpr_to_expression(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_nilExpr_to_expression");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_nullLiteral_to_constant_value(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_nullLiteral_to_constant_value");
        }
        return new DebuggerValue(null);
    }

    public Object reduce_nullLiteral_to_object_literal(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_nullLiteral_to_object_literal");
        }
        return new DebuggerValue(null);
    }

    public Object reduce_objectLiteral(IASNode iNode, Vector<Object> elements) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_objectLiteral");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_objectLiteralElement(IASNode iNode, Object id, Object value) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_objectLiteralElement");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_parameterizedTypeName(IASNode iNode, Object base, Object param) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_parameterizedTypeName");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_parameterizedTypeExpression(IASNode iNode, Object base, Object param) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_parameterizedTypeExpression");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_postDecBracketExpr(IASNode iNode, Object stem, Object index, boolean need_result) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_postDecBracketExpr");
        }
        return this.reduce_postDecMemberExpr(iNode, stem, index, need_result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object reduce_postDecMemberExpr(IASNode iNode, Object stem, Object field, boolean need_result) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_postDecMemberExpr");
        }
        try {
            DebuggerValue lhs = (DebuggerValue)stem;
            Context context = this.contextStack.scope();
            Context newContext = context.createContext(lhs.debuggerValue);
            this.contextStack.pushScope(newContext);
            Object object = this.reduce_prePostIncDecExpr(iNode, field, true, false);
            return object;
        }
        finally {
            this.contextStack.popScope();
        }
    }

    public Object reduce_postDecNameExpr(IASNode iNode, Object unary, boolean need_result) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_postDecNameExpr");
        }
        return this.reduce_prePostIncDecExpr(iNode, unary, true, false);
    }

    public Object reduce_postIncBracketExpr(IASNode iNode, Object stem, Object index, boolean need_result) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_postIncBracketExpr");
        }
        return this.reduce_postIncMemberExpr(iNode, stem, index, need_result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object reduce_postIncMemberExpr(IASNode iNode, Object stem, Object field, boolean need_result) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_postIncMemberExpr");
        }
        try {
            DebuggerValue lhs = (DebuggerValue)stem;
            Context context = this.contextStack.scope();
            Context newContext = context.createContext(lhs.debuggerValue);
            this.contextStack.pushScope(newContext);
            Object object = this.reduce_prePostIncDecExpr(iNode, field, true, true);
            return object;
        }
        finally {
            this.contextStack.popScope();
        }
    }

    public Object reduce_postIncNameExpr(IASNode iNode, Object unary, boolean need_result) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_postIncNameExpr");
        }
        return this.reduce_prePostIncDecExpr(iNode, unary, true, true);
    }

    public Object reduce_preDecBracketExpr(IASNode iNode, Object stem, Object index, boolean need_result) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_preDecBracketExpr");
        }
        return this.reduce_preDecMemberExpr(iNode, stem, index, need_result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object reduce_preDecMemberExpr(IASNode iNode, Object stem, Object field, boolean need_result) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_preDecMemberExpr");
        }
        try {
            DebuggerValue lhs = (DebuggerValue)stem;
            Context context = this.contextStack.scope();
            Context newContext = context.createContext(lhs.debuggerValue);
            this.contextStack.pushScope(newContext);
            Object object = this.reduce_prePostIncDecExpr(iNode, field, false, false);
            return object;
        }
        finally {
            this.contextStack.popScope();
        }
    }

    public Object reduce_preDecNameExpr(IASNode iNode, Object unary, boolean need_result) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_preDecNameExpr");
        }
        return this.reduce_prePostIncDecExpr(iNode, unary, false, false);
    }

    public Object reduce_preIncBracketExpr(IASNode iNode, Object stem, Object index, boolean need_result) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_preIncBracketExpr");
        }
        return this.reduce_preIncMemberExpr(iNode, stem, index, need_result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object reduce_preIncMemberExpr(IASNode iNode, Object stem, Object field, boolean need_result) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_preIncMemberExpr");
        }
        try {
            DebuggerValue lhs = (DebuggerValue)stem;
            Context context = this.contextStack.scope();
            Context newContext = context.createContext(lhs.debuggerValue);
            this.contextStack.pushScope(newContext);
            Object object = this.reduce_prePostIncDecExpr(iNode, field, false, true);
            return object;
        }
        finally {
            this.contextStack.popScope();
        }
    }

    public Object reduce_preIncNameExpr(IASNode iNode, Object unary, boolean need_result) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_preIncNameExpr");
        }
        return this.reduce_prePostIncDecExpr(iNode, unary, false, true);
    }

    public Object reduce_prePostIncDecExpr(IASNode iNode, Object unary, boolean isPostFix, boolean isIncrement) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_prePostIncDecExpr");
        }
        try {
            DebuggerValue expr = (DebuggerValue)unary;
            Context debuggerContext = this.contextStack.scope();
            String memberName = ECMA.toString(debuggerContext.getSession(), debuggerContext.toValue(expr.debuggerValue));
            Object lookupResult = debuggerContext.lookup(memberName);
            double before = ECMA.toNumber(debuggerContext.getSession(), debuggerContext.toValue(lookupResult));
            double after = isIncrement ? before + 1.0 : before - 1.0;
            debuggerContext.assign(memberName, debuggerContext.toValue(new Double(after)));
            Double result = isPostFix ? new Double(before) : new Double(after);
            return new DebuggerValue(result);
        }
        catch (NoSuchVariableException e) {
            throw new ExpressionEvaluatorException(e);
        }
        catch (PlayerFaultException e) {
            throw new ExpressionEvaluatorException(e);
        }
    }

    public Object reduce_regexLiteral(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_regexLiteral");
        }
        if (iNode instanceof RegExpLiteralNode) {
            String flags;
            String re;
            RegExpLiteralNode rgXNode = (RegExpLiteralNode)iNode;
            String val = rgXNode.getValue(true);
            if (val.length() > 0 && val.charAt(0) == '/') {
                int lastSlash = val.lastIndexOf(47);
                re = val.substring(1, lastSlash);
                flags = val.substring(lastSlash + 1);
            } else {
                re = val;
                flags = "";
            }
            Context eeContext = this.contextStack.scope();
            try {
                return new DebuggerValue(this.callFunction(eeContext, true, "RegExp", new Object[]{re, flags}));
            }
            catch (PlayerDebugException e) {
                throw new ExpressionEvaluatorException(e);
            }
        }
        throw new ExpressionEvaluatorException("Unable to resolve regex");
    }

    public Object reduce_runtimeNameExpression(IASNode iNode, Object expr) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_runtimeNameExpression");
        }
        return expr;
    }

    public Object reduce_simpleName(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_simpleName");
        }
        return new DebuggerValue(((IdentifierNode)iNode).getName());
    }

    public Object reduce_declName(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_declName");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_strictneqExpr(IASNode iNode, Object l, Object r) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_strictneqExpr");
        }
        Context eeContext = this.contextStack.scope();
        DebuggerValue lhs = (DebuggerValue)l;
        DebuggerValue rhs = (DebuggerValue)r;
        return new DebuggerValue(new Boolean(!ECMA.strictEquals(eeContext.toValue(lhs.debuggerValue), eeContext.toValue(rhs.debuggerValue))));
    }

    public Object reduce_superAccess(IASNode iNode, Object qualified_name) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_superAccess");
        }
        throw new ExpressionEvaluatorException(this.keywordNotAllowed("super"));
    }

    public Object reduce_ternaryExpr(IASNode iNode, Object test, Object when_true, Object when_false) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_ternaryExpr");
        }
        DebuggerValue condition = (DebuggerValue)test;
        Context eeContext = this.contextStack.scope();
        boolean b = ECMA.toBoolean(eeContext.toValue(condition.debuggerValue));
        if (b) {
            return when_true;
        }
        return when_false;
    }

    public Object reduce_typedVariableExpression(IASNode iNode, Object var_name, Object var_type) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_typedVariableExpression");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_typeof_expr(IASNode iNode, Object operand) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_typeof_expr");
        }
        Context eeContext = this.contextStack.scope();
        DebuggerValue arg = (DebuggerValue)operand;
        Value value = eeContext.toValue(arg.debuggerValue);
        switch (value.getType()) {
            case 7: {
                return new DebuggerValue("undefined");
            }
            case 6: {
                return new DebuggerValue("object");
            }
            case 1: {
                return new DebuggerValue("boolean");
            }
            case 0: {
                return new DebuggerValue("number");
            }
            case 2: {
                return new DebuggerValue("string");
            }
            case 3: {
                String typeName = value.getTypeName();
                int at = typeName.indexOf(64);
                if (at != -1) {
                    typeName = typeName.substring(0, at);
                }
                if (!typeName.equals("XML") && !typeName.equals("XMLList")) break;
                return new DebuggerValue("xml");
            }
        }
        return new DebuggerValue("object");
    }

    public Object reduce_typeof_name(IASNode iNode, Object object) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_typeof_name");
        }
        Object exprObject = this.transform_name_to_expression(iNode, object);
        return this.reduce_typeof_expr(iNode, exprObject);
    }

    public Object reduce_typeNameParameterAsType(IASNode iNode, Object type_param) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_typeNameParameterAsType");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_vectorLiteral(IASNode iNode, Object type_param, Vector<Object> elements) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_vectorLiteral");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_voidExpr_to_type_name(IASNode node) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_voidExpr_to_type_name");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_void0Literal_to_constant_value(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_void0Literal_to_constant_value");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_void0Literal_to_object_literal(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_void0Literal_to_object_literal");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_void0Operator(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_void0Operator");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_voidOperator_to_constant_value(IASNode iNode, Object constant_value) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_voidOperator_to_constant_value");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_voidOperator_to_expression(IASNode iNode, Object expr) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_voidOperator_to_expression");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object reduce_XMLContent(IASNode iNode, Vector<Object> exprs) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_XMLContent");
        }
        Object result = null;
        return result;
    }

    public Object reduce_XMLList(IASNode iNode, Vector<Object> exprs) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_XMLList");
        }
        Object result = null;
        return result;
    }

    public Object reduce_XMLListConst(IASNode iNode, Vector<String> elements) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduce_XMLListConst");
        }
        Object result = null;
        return result;
    }

    public Object transform_boolean_constant(IASNode iNode, Boolean boolean_constant) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_boolean_constant");
        }
        DebuggerValue result = new DebuggerValue(boolean_constant);
        return result;
    }

    public Object transform_double_constant(IASNode iNode, Double double_constant) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_double_constant");
        }
        DebuggerValue result = new DebuggerValue(double_constant);
        return result;
    }

    public Object transform_numeric_constant(IASNode iNode, Number numeric_constant) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_numeric_constant");
        }
        DebuggerValue result = new DebuggerValue(numeric_constant);
        return result;
    }

    public Object transform_constant_value(IASNode iNode, Object constant_value) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_constant_value");
        }
        return constant_value;
    }

    public Object transform_float_constant(IASNode iNode, Float float_constant) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_float_constant");
        }
        DebuggerValue result = new DebuggerValue(float_constant);
        return result;
    }

    public Object transform_string_constant_to_constant(IASNode iNode, String string_constant) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_string_constant_to_constant");
        }
        return string_constant;
    }

    public Object transform_boolean_constant_to_constant(IASNode iNode, Boolean boolean_constant) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_boolean_constant_to_constant");
        }
        return boolean_constant;
    }

    public Object transform_numeric_constant_to_constant(IASNode iNode, Number numeric_constant) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_numeric_constant_to_constant");
        }
        if (numeric_constant instanceof Float) {
            return new DebuggerValue(new Double(((Float)numeric_constant).floatValue()));
        }
        return new DebuggerValue(new Double((Double)numeric_constant));
    }

    public Object transform_expression_to_constant_value(IASNode iNode, Object expression) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_expression_to_constant_value");
        }
        return null;
    }

    public Object transform_integer_constant(IASNode iNode, Integer integer_constant) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_integer_constant");
        }
        DebuggerValue result = new DebuggerValue(new Double(integer_constant.intValue()));
        return result;
    }

    public Object transform_name_to_constant_value(IASNode iNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_name_to_constant_value");
        }
        Object result = null;
        return result;
    }

    public Object transform_name_to_expression(IASNode iNode, Object name) {
        Object lookupResult;
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_name_to_expression");
        }
        DebuggerValue identifier = (DebuggerValue)name;
        Context eeContext = this.contextStack.scope();
        String nameStr = ECMA.toString(eeContext.getSession(), eeContext.toValue(identifier.debuggerValue));
        Value contextValue = eeContext.toValue();
        if (contextValue != null && this.isXMLType(contextValue) && !this.isNumericIndex(iNode, identifier.debuggerValue, eeContext)) {
            Object arg;
            String function;
            if (nameStr.length() > 0 && nameStr.charAt(0) == '@') {
                function = "attribute";
                arg = nameStr.substring(1);
            } else {
                arg = identifier.debuggerValue;
                boolean isDecendentsOpr = iNode.getNodeID() == ASTNodeID.Op_DescendantsID;
                function = isDecendentsOpr ? "descendants" : "child";
            }
            try {
                return new DebuggerValue(this.callFunction(eeContext, false, function, new Object[]{arg}));
            }
            catch (PlayerDebugException e) {
                throw new ExpressionEvaluatorException(e);
            }
        }
        if (contextValue != null && contextValue.getType() == 2 && ((DebuggerValue)name).debuggerValue.equals("length")) {
            String valuestr = contextValue.getValueAsString();
            return new DebuggerValue(new Double(valuestr.length()));
        }
        try {
            lookupResult = eeContext.lookup(ECMA.toString(eeContext.getSession(), eeContext.toValue(identifier.debuggerValue)));
        }
        catch (NoSuchVariableException e) {
            throw new ExpressionEvaluatorException(e);
        }
        catch (PlayerFaultException e) {
            throw new ExpressionEvaluatorException(e);
        }
        return new DebuggerValue(lookupResult);
    }

    public Object transform_non_resolving_identifier(IASNode iNode, String non_resolving_identifier) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_non_resolving_identifier");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object transform_runtime_name_expression(IASNode iNode, Object runtime_name_expression) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_runtime_name_expression");
        }
        throw new ExpressionEvaluatorException(ASTBuilder.getLocalizationManager().getLocalizedTextString("unsupportedExpression"));
    }

    public Object transform_string_constant(IASNode iNode, String string_constant) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_string_constant");
        }
        return new DebuggerValue(string_constant);
    }

    public Object transform_uint_constant(IASNode iNode, Long uint_constant) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("transform_uint_constant");
        }
        DebuggerValue result = new DebuggerValue(uint_constant);
        return result;
    }

    Object unaryOp(IASNode iNode, Object operand, int opcode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("unaryOp");
        }
        DebuggerValue arg = (DebuggerValue)operand;
        Context eeContext = this.contextStack.scope();
        switch (opcode) {
            case 71: {
                eeContext.toValue(arg.debuggerValue);
                return new DebuggerValue(Value.UNDEFINED);
            }
            case 149: {
                return this.reduce_typeof_expr(iNode, operand);
            }
            case 117: 
            case 122: {
                return new DebuggerValue(new Double(ECMA.toNumber(eeContext.getSession(), eeContext.toValue(arg.debuggerValue))));
            }
            case 144: {
                return new DebuggerValue(new Double(-ECMA.toNumber(eeContext.getSession(), eeContext.toValue(arg.debuggerValue))));
            }
            case 151: {
                return new DebuggerValue(new Double(~ECMA.toInt32(eeContext.getSession(), eeContext.toValue(arg.debuggerValue))));
            }
            case 150: {
                return new DebuggerValue(new Boolean(!ECMA.toBoolean(eeContext.toValue(arg.debuggerValue))));
            }
        }
        throw new UnsupportedOperationException();
    }

    Object errorPackageName(IASNode iNode, String qualifiers, String base_name) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("errorPackageName");
        }
        return null;
    }

    private boolean isNumericIndex(IASNode node, Object index, Context context) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("isNumericIndex");
        }
        if (node.getNodeID() != ASTNodeID.ArrayIndexExpressionID) {
            return false;
        }
        if (index instanceof Double) {
            return true;
        }
        if (index instanceof String) {
            String s = (String)index;
            if (s.length() == 0) {
                return false;
            }
            try {
                Double.parseDouble(s);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (context != null && index != null) {
            Value value = context.toValue(index);
            return value != null && value.getType() == 0;
        }
        return false;
    }

    private boolean isXMLType(Value value) {
        String typename;
        int at;
        if (this.hookallreducercalls) {
            this.hookforreducercalls("isXMLType");
        }
        if ((at = (typename = value.getTypeName()).indexOf(64)) != -1) {
            typename = typename.substring(0, at);
        }
        return typename.equals("XML") || typename.equals("XMLList");
    }

    private String keywordNotAllowed(String keyword) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("keywordNotAllowed");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("keyword", keyword);
        return ASTBuilder.getLocalizationManager().getLocalizedTextString("keywordNotAllowed", parameters);
    }

    public Object reduceLazyExpression(final IASNode expressionNode) {
        if (this.hookallreducercalls) {
            this.hookforreducercalls("reduceLazyExpression");
        }
        UnEvaluatedDebugExpression delayedEvaluator = new UnEvaluatedDebugExpression(){

            @Override
            public DebuggerValue evaluate(Context eeContext) {
                try {
                    DebuggerExpressionEvaluator evalutor = new DebuggerExpressionEvaluator(AS3DebuggerReducer.this.project);
                    return evalutor.evaluate(eeContext, expressionNode);
                }
                catch (Exception e) {
                    throw new ExpressionEvaluatorException(e);
                }
            }
        };
        return delayedEvaluator;
    }

    private static abstract class UnEvaluatedDebugExpression {
        private UnEvaluatedDebugExpression() {
        }

        public abstract DebuggerValue evaluate(Context var1);
    }

    private static enum XMLContentState {

    }

    public static class ContextStack {
        private final List<Context> ctxStckInternal = new ArrayList<Context>();

        public ContextStack(Context context) {
            this.pushScope(context);
        }

        public Context scope(int i) {
            return this.ctxStckInternal.get(i);
        }

        public void pushScope(Context scope) {
            this.ctxStckInternal.add(scope);
        }

        public void popScope() {
            assert (!this.ctxStckInternal.isEmpty());
            this.ctxStckInternal.remove(this.ctxStckInternal.size() - 1);
        }

        public Context scope() {
            return this.ctxStckInternal.get(this.ctxStckInternal.size() - 1);
        }
    }
}

